#
# TABLE STRUCTURE FOR: accounts
#

DROP TABLE IF EXISTS `accounts`;

CREATE TABLE `accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `description` text NOT NULL,
  `balance` double(18,2) NOT NULL DEFAULT '0.00',
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8;

INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (2, 'SALARY', '', '0.00', '2022-03-14 13:23:33', '2022-03-14 13:23:33');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (3, 'DR PRIYA', '', '0.00', '2022-03-14 13:28:11', '2022-03-18 13:00:27');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (4, 'QSC EXPENSE', '', '-1738.00', '2022-03-14 14:09:21', '2022-03-18 13:49:37');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (6, 'PUYAPALLY', '', '100000.00', '2022-03-14 14:18:00', '2022-03-21 09:53:53');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (8, 'HOME EXPENSE', '', '-2030.00', '2022-03-18 12:54:30', '2022-03-18 13:34:44');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (9, 'DOCTORS FEE', '', '0.00', '2022-03-18 12:55:26', '2022-03-18 12:55:26');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (10, 'SALARY ADVANCE', '', '0.00', '2022-03-18 12:55:52', '2022-03-18 12:55:52');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (11, 'OLAYIL', '', '-8550.00', '2022-03-18 12:56:45', '2022-03-18 13:43:03');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (12, 'VEHICLE EXPENSE', '', '-100.00', '2022-03-18 12:57:02', '2022-03-18 13:39:32');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (13, 'INSURANCE', '', '0.00', '2022-03-18 12:57:10', '2022-03-18 12:57:10');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (14, 'NEW CENTRE KPLY', '', '-2850.00', '2022-03-18 12:57:45', '2022-03-18 13:32:34');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (15, 'DR VINOD JACOB', '', '-820.00', '2022-03-18 12:58:14', '2022-03-18 13:33:45');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (16, 'ECHO,TMT,ECG,EEG,FNAC,NCV,BMD,OPG', '', '-1000.00', '2022-03-18 13:36:40', '2022-03-18 13:41:31');
INSERT INTO `accounts` (`id`, `name`, `description`, `balance`, `created_at`, `updated_at`) VALUES (17, 'Collecton', '', '0.00', '2022-03-26 11:11:56', '2022-03-26 11:11:56');


#
# TABLE STRUCTURE FOR: appointment
#

DROP TABLE IF EXISTS `appointment`;

CREATE TABLE `appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` varchar(20) NOT NULL,
  `doctor_id` varchar(20) NOT NULL,
  `patient_id` varchar(20) NOT NULL,
  `consultation_fees` varchar(20) NOT NULL,
  `discount` decimal(18,2) NOT NULL,
  `schedule` varchar(50) NOT NULL,
  `remarks` text NOT NULL,
  `appointment_date` date NOT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `appointment` (`id`, `appointment_id`, `doctor_id`, `patient_id`, `consultation_fees`, `discount`, `schedule`, `remarks`, `appointment_date`, `status`, `created_at`) VALUES (1, '0001', '28', '17', '', '0.00', '1', 'test', '2022-03-21', 1, '2022-03-16 14:45:03');


#
# TABLE STRUCTURE FOR: chemical
#

DROP TABLE IF EXISTS `chemical`;

CREATE TABLE `chemical` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `code` varchar(50) NOT NULL,
  `category_id` int(11) NOT NULL,
  `purchase_unit_id` int(11) NOT NULL,
  `sales_unit_id` int(11) NOT NULL,
  `unit_ratio` varchar(20) DEFAULT '1',
  `purchase_price` decimal(18,2) NOT NULL DEFAULT '0.00',
  `sales_price` decimal(18,2) NOT NULL DEFAULT '0.00',
  `available_stock` varchar(11) NOT NULL DEFAULT '0',
  `photo` varchar(100) DEFAULT NULL,
  `remarks` text NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `chemical` (`id`, `name`, `code`, `category_id`, `purchase_unit_id`, `sales_unit_id`, `unit_ratio`, `purchase_price`, `sales_price`, `available_stock`, `photo`, `remarks`, `created_at`, `updated_at`) VALUES (2, 'SANITIZER', 'SNTIZR', 4, 2, 2, '30', '515.00', '550.00', '0', NULL, '', '2022-03-14 18:04:38', '2022-03-14 18:04:38');


#
# TABLE STRUCTURE FOR: chemical_assigned
#

DROP TABLE IF EXISTS `chemical_assigned`;

CREATE TABLE `chemical_assigned` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_id` int(11) NOT NULL,
  `chemical_id` varchar(20) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: chemical_category
#

DROP TABLE IF EXISTS `chemical_category`;

CREATE TABLE `chemical_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `chemical_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (1, 'SGOT', '2022-03-14 11:07:05', '2022-03-14 11:07:05');
INSERT INTO `chemical_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (2, 'Syringe', '2022-03-14 11:42:29', '2022-03-14 11:42:29');
INSERT INTO `chemical_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (3, 'Fluoride Tube', '2022-03-14 11:43:23', '2022-03-14 11:43:23');
INSERT INTO `chemical_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (4, 'STORES', '2022-03-14 18:02:40', '2022-03-14 18:02:40');


#
# TABLE STRUCTURE FOR: chemical_stock
#

DROP TABLE IF EXISTS `chemical_stock`;

CREATE TABLE `chemical_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inovice_no` varchar(25) NOT NULL,
  `chemical_id` varchar(20) NOT NULL,
  `date` date DEFAULT NULL,
  `stock_quantity` varchar(20) NOT NULL,
  `remarks` varchar(255) NOT NULL,
  `stock_by` varchar(20) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `chemical_stock` (`id`, `inovice_no`, `chemical_id`, `date`, `stock_quantity`, `remarks`, `stock_by`, `created_at`, `updated_at`) VALUES (1, 'C/05279', '1', '2022-03-14', '200', '', '1', '2022-03-14 11:49:03', '2022-03-14 11:49:03');


#
# TABLE STRUCTURE FOR: chemical_unit
#

DROP TABLE IF EXISTS `chemical_unit`;

CREATE TABLE `chemical_unit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `chemical_unit` (`id`, `name`, `created_at`, `updated_at`) VALUES (1, 'NOS', '2022-03-14 11:04:06', '2022-03-14 18:01:30');
INSERT INTO `chemical_unit` (`id`, `name`, `created_at`, `updated_at`) VALUES (2, 'Ltr', '2022-03-14 11:04:11', '2022-03-14 11:04:11');
INSERT INTO `chemical_unit` (`id`, `name`, `created_at`, `updated_at`) VALUES (3, 'Kit', '2022-03-14 11:31:37', '2022-03-14 11:31:37');
INSERT INTO `chemical_unit` (`id`, `name`, `created_at`, `updated_at`) VALUES (4, 'Box', '2022-03-14 11:45:52', '2022-03-14 11:45:52');


#
# TABLE STRUCTURE FOR: ci_sessions
#

DROP TABLE IF EXISTS `ci_sessions`;

CREATE TABLE `ci_sessions` (
  `id` varchar(40) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `data` blob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ci_sessions_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('02lprfb6uj35ofd28soldtgl0n32ifm7', '49.37.227.22', 1648531562, '__ci_last_regenerate|i:1648531562;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('06r9v7f03pknb924bsncduhb4p4bop8f', '207.46.13.110', 1648522358, '__ci_last_regenerate|i:1648522358;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0gekfgmat2fd1c59d5o8imhshccvp2va', '207.46.13.209', 1648522205, '__ci_last_regenerate|i:1648522204;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0r564fk97e7tmqnr82sa8iipf4fkhbtj', '157.55.39.28', 1648522211, '__ci_last_regenerate|i:1648522211;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('10la4p2i3vk4qltrjbkl3icg0epumcdb', '207.46.13.209', 1648522249, '__ci_last_regenerate|i:1648522249;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('136plkep5g268rsoc8e75g7i8petqsjk', '49.37.239.252', 1648705245, '__ci_last_regenerate|i:1648705233;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('15b6n54v1m86492r79qdurpffal722sj', '49.15.202.110', 1648717836, '__ci_last_regenerate|i:1648717833;redirect_url|s:33:\"https://quilonscans.com/dashboard\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('19nuiktnplhos9i40s10v3n3q4l7l408', '157.55.39.81', 1648522201, '__ci_last_regenerate|i:1648522201;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('24u98gr0i7m5qhobnrp3cofdf6t8cgbg', '49.37.227.22', 1648532667, '__ci_last_regenerate|i:1648532514;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2b32vigscglqrfuon9263avk0dh1ihao', '49.37.227.22', 1648530096, '__ci_last_regenerate|i:1648529960;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2r9pqvu9ag0qma6t0vlliv25g8qn9fge', '59.88.226.11', 1648530144, '__ci_last_regenerate|i:1648530144;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2ujtrd1u2bt13ao71ka1m6h479ajlcko', '157.55.39.28', 1648522223, '__ci_last_regenerate|i:1648522223;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3a56ionm6vvc9jt0663pvencsaauq5gd', '157.55.39.81', 1648523240, '__ci_last_regenerate|i:1648523240;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3gevmtatb95stqqh1becbo4blvm25mmf', '207.46.13.10', 1648522228, '__ci_last_regenerate|i:1648522228;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3h4e43meqctslhijtvm7rhn1l647gtvg', '59.88.226.11', 1648531554, '__ci_last_regenerate|i:1648531502;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3kaqle69ldotn4bs1m62id3tgkgbthcn', '157.55.39.28', 1648522226, '__ci_last_regenerate|i:1648522226;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3kjqrfj188nk3scl2rnekj0h29g40hm1', '49.37.227.22', 1648528259, '__ci_last_regenerate|i:1648528259;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3l750ddtdgc59a2qi3aqtro2m6bm43b3', '157.55.39.81', 1648522208, '__ci_last_regenerate|i:1648522208;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3lvj3ftcvve9hljd4515t4i5jflhqvl3', '157.55.39.81', 1648523209, '__ci_last_regenerate|i:1648523209;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3p7vh88alqsv0g38a4lnq47squbgkj78', '207.46.13.10', 1648522220, '__ci_last_regenerate|i:1648522220;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3rup0lln0iboskj60jvko6dhglgvrbjr', '207.46.13.10', 1648522243, '__ci_last_regenerate|i:1648522243;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4a8b2qv4epq4g903fvd6s88mk54ceq3o', '49.37.239.252', 1648718378, '__ci_last_regenerate|i:1648718287;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4gm0qb1afi3to4iqm6jk69bhs47k14n3', '157.55.39.28', 1648522228, '__ci_last_regenerate|i:1648522228;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4jgfimtkefcf0btchpk5sqosm5ohlujk', '61.3.108.184', 1648717668, '__ci_last_regenerate|i:1648717613;redirect_url|s:53:\"https://www.quilonscans.com/billing/collection_report\";name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4meortj1ffb13kk9f66rm9br185jv1g0', '207.46.13.110', 1648522210, '__ci_last_regenerate|i:1648522210;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4mm60hg89hupgh3j531aib4mc60fv6dk', '13.66.139.1', 1648523123, '__ci_last_regenerate|i:1648523123;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4q3jgtal90ssd6ugoo45p1eg57petajc', '207.46.13.209', 1648523245, '__ci_last_regenerate|i:1648523245;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4sd7nnl2d4pgckvlllghvjjn03qkui1d', '59.88.226.11', 1648527997, '__ci_last_regenerate|i:1648527774;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4ug2voa4o8b7n8u77qu4j1280dh04o0s', '207.46.13.209', 1648522354, '__ci_last_regenerate|i:1648522354;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('52ad79orinkd6r792e7dtjj5nc3bpjmi', '157.55.39.28', 1648522234, '__ci_last_regenerate|i:1648522234;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5do1jqh1fe0l3eltg5tvofbeksob5772', '49.37.239.252', 1648704823, '__ci_last_regenerate|i:1648704823;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6590252n6c54frh0tj70mae54nfnfq23', '49.37.227.22', 1648531238, '__ci_last_regenerate|i:1648531235;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6kshelgsju09192vkssnecjldlnlog43', '59.88.226.11', 1648522936, '__ci_last_regenerate|i:1648522752;redirect_url|s:49:\"https://www.quilonscans.com/billing/test_bill_add\";name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6m9iukmncsurv14dt55k0a8c3ts1h72m', '49.37.239.252', 1648707943, '__ci_last_regenerate|i:1648707940;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6scdaqhh2ichvvilj9cmd62iff96sjai', '13.66.139.0', 1648523132, '__ci_last_regenerate|i:1648523132;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6vbp3806mcl4mda8gsv7g1kff7elr803', '157.55.39.81', 1648522198, '__ci_last_regenerate|i:1648522198;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('70hqkvso7om9hinbc98stdicjeorhj63', '49.37.239.252', 1648704944, '__ci_last_regenerate|i:1648704823;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('71g40u3q8t1k548p781o6qcns1ktdtq2', '59.88.226.11', 1648527196, '__ci_last_regenerate|i:1648526930;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7amda13ir3a8codsic6l1bu71jdkpo90', '157.55.39.81', 1648522221, '__ci_last_regenerate|i:1648522221;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7hno2avlo2a7h60mvj3m20ut15rb7m1g', '131.153.143.50', 1648518936, '__ci_last_regenerate|i:1648518936;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7i152um4l362nh13a4gohm22nfjo35ol', '207.46.13.10', 1648522231, '__ci_last_regenerate|i:1648522231;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7m0kg5s62qho4ubn1qs7kgddrkg0mt8h', '157.55.39.28', 1648522225, '__ci_last_regenerate|i:1648522225;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7nnha7sm223guetiah7per8pp3a7bgq4', '49.37.239.252', 1648705832, '__ci_last_regenerate|i:1648705542;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('85flluj291up065rfqqmfne0l5hn3rid', '49.37.227.22', 1648529539, '__ci_last_regenerate|i:1648529147;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('875fnbem5dsq0c5lru0vp51468v3f52b', '207.46.13.209', 1648523248, '__ci_last_regenerate|i:1648523248;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8jf98s1o9rm9bh1ovufe85uk4jjijkba', '61.3.108.184', 1648709870, '__ci_last_regenerate|i:1648709851;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8nqvolkcufnkk8jvc33jaau8ue9per0c', '185.59.221.226', 1648704226, '__ci_last_regenerate|i:1648704226;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8qk7067st7qtdu0boeq0hnciq9hjr4if', '49.37.227.22', 1648533194, '__ci_last_regenerate|i:1648533057;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8shlpkhfcbm02qsl57umujmee2hvk0mp', '59.88.226.11', 1648526097, '__ci_last_regenerate|i:1648526038;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('93rgb8u7671qsp4h4bp5s2653vjv62pv', '49.37.239.252', 1648713730, '__ci_last_regenerate|i:1648713692;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9fa2hst74nhpsf0u7kp5h34ist3b7sq1', '207.46.13.10', 1648523241, '__ci_last_regenerate|i:1648523241;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9i402o34o3qjt7vjlgtm6i7oicif7pac', '49.37.227.22', 1648528301, '__ci_last_regenerate|i:1648528260;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9n732o84ah30v3chjthu4jjk1j3ledte', '207.46.13.10', 1648522199, '__ci_last_regenerate|i:1648522199;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9tllr9v6p89e5epcqotck15fngin5j4j', '207.46.13.110', 1648522208, '__ci_last_regenerate|i:1648522208;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9ujt8drha1670ko6nlqbpussididvtmb', '207.46.13.13', 1648522205, '__ci_last_regenerate|i:1648522205;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9v1p7o1eq2pb22t95h5lv4r90r7q9ptv', '157.55.39.81', 1648522211, '__ci_last_regenerate|i:1648522211;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a1nku5oldbue0mtf9fj1co87c0br2m2b', '49.37.227.22', 1648531326, '__ci_last_regenerate|i:1648531109;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a3q7ehjqorm9911s9e20b3f4gisgecin', '157.55.39.28', 1648522213, '__ci_last_regenerate|i:1648522213;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a6v9l54fg19p01gmugf3ul7ctrqqcb5q', '207.46.13.10', 1648522243, '__ci_last_regenerate|i:1648522242;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('agg3fd6gdfp7sq0eaopvbrq4r3vc8osl', '49.37.239.252', 1648705233, '__ci_last_regenerate|i:1648705233;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aisiel2f8bt9glhhmbtdhmg8dqb1n7hp', '185.59.221.226', 1648704486, '__ci_last_regenerate|i:1648704486;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('av0s6ftpvtvtdnn85s36j2298daoljbj', '13.66.139.1', 1648523123, '__ci_last_regenerate|i:1648523123;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b6ve4u23ceu45tp21tgsatonos1ujj0e', '59.88.226.11', 1648528285, '__ci_last_regenerate|i:1648528133;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b71n62t1ds07v5riffmtvqlp7q9q6k3o', '157.55.39.81', 1648522218, '__ci_last_regenerate|i:1648522218;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bqdag2ahjnpbr29fd94rkvmjb065mr4m', '207.46.13.10', 1648522225, '__ci_last_regenerate|i:1648522225;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bs58kc5bcsdfqiobhcmucnakmuqa3037', '207.46.13.110', 1648522232, '__ci_last_regenerate|i:1648522232;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bs60lbmf0pa1k3felbvjqlqtp9gsq9ds', '207.46.13.209', 1648522245, '__ci_last_regenerate|i:1648522245;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bs9vvacd59urcch9p2mfdbc7est7e7nf', '207.46.13.10', 1648523244, '__ci_last_regenerate|i:1648523244;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c6bnirpn1k9dedb41q8508ujhdqtep30', '207.46.13.209', 1648522403, '__ci_last_regenerate|i:1648522403;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c9f9qkc9nlh61gngnqtm36l8m39staof', '157.55.39.28', 1648523082, '__ci_last_regenerate|i:1648523082;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cqtkmcsgqq2q3a08o8bn35c625vss29e', '93.119.227.91', 1648705630, '__ci_last_regenerate|i:1648705630;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dkd84klrt41a4ips67avlqrbhijcfguc', '207.46.13.110', 1648522220, '__ci_last_regenerate|i:1648522220;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dr7k5mpjmco3raunoi5rgfhcekr4pbkb', '207.46.13.110', 1648523239, '__ci_last_regenerate|i:1648523239;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dvs5esilik9ue04tbbq203384pgatsv4', '207.46.13.110', 1648522348, '__ci_last_regenerate|i:1648522348;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('eb9urkeio0l7tr9e4ucveb1cjdv4ed7r', '157.55.39.81', 1648522205, '__ci_last_regenerate|i:1648522205;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ed94llue7cfi9sb9197v9pgispg6cg9p', '59.88.226.11', 1648528773, '__ci_last_regenerate|i:1648528580;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('eq2b6jdaomk1em2a18kkv8e576quh73l', '207.46.13.209', 1648522240, '__ci_last_regenerate|i:1648522240;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('evoqncpanvpqhckcphdvi3ltafk06ao1', '207.46.13.110', 1648522218, '__ci_last_regenerate|i:1648522218;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('f0b736s000q6rblf868ea1fnan9dr0u8', '34.77.162.19', 1648516782, '__ci_last_regenerate|i:1648516782;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fitfgo1eadess6d6qbaq5cikcokm5nqr', '59.88.226.11', 1648530523, '__ci_last_regenerate|i:1648530470;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fopbjr1l4pua54e2c5v63pj585lu3rog', '157.55.39.28', 1648523243, '__ci_last_regenerate|i:1648523243;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fsria3he69qcmvrr4v7lke7fr4qm0hna', '157.55.39.81', 1648522207, '__ci_last_regenerate|i:1648522207;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gj9k52rq8h59lkm439p1044mkmndvl3o', '207.46.13.110', 1648522177, '__ci_last_regenerate|i:1648522177;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gouf5ddqmjb629av3rf8cttt6anb71av', '207.46.13.13', 1648522254, '__ci_last_regenerate|i:1648522254;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gue7qkf2ql4cosobqoaiecrlsa08094u', '157.55.39.28', 1648522219, '__ci_last_regenerate|i:1648522219;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ha60d5kqtj8tqm4ta19bdsb7dthku1ni', '185.59.221.226', 1648704614, '__ci_last_regenerate|i:1648704614;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('hnu8juu4lorundsq8vhkjfqe8bq03k46', '207.46.13.209', 1648522213, '__ci_last_regenerate|i:1648522213;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('i2eci54sdlislpdkmuj48rvau37s2332', '49.37.227.22', 1648529918, '__ci_last_regenerate|i:1648529913;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('i5gifkovmsjcvlvnklk7acashrp8o9lr', '157.55.39.28', 1648522206, '__ci_last_regenerate|i:1648522206;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ih769sap2721cft9vs9v9luh76npe17i', '59.88.226.11', 1648523871, '__ci_last_regenerate|i:1648523871;redirect_url|s:49:\"https://www.quilonscans.com/billing/test_bill_add\";name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ih80ufcp8fpsrst6g41gd2s2o7hckffm', '207.46.13.13', 1648523246, '__ci_last_regenerate|i:1648523246;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('iotk4mb86p1r0cal1m4d1un1j1hkjbvc', '69.4.89.106', 1648705758, '__ci_last_regenerate|i:1648705758;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('iroc59pkhv9mnifo824hrdm80tjfr38o', '207.46.13.10', 1648522209, '__ci_last_regenerate|i:1648522209;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ium56ab6dv88cn30dg4ctscsf38acj2p', '117.230.34.234', 1648708459, '__ci_last_regenerate|i:1648708335;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('j3otq7a2eu6ob27ktof3mrbqiqpn86if', '157.44.168.70', 1648704251, '__ci_last_regenerate|i:1648704251;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('j6emvr5vsh2n1q2l2fkl4klvi31tvq7r', '59.88.226.11', 1648527752, '__ci_last_regenerate|i:1648527333;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('j9hfhmehoe5gg1jc7tii4q82vuo6t06n', '59.88.226.11', 1648526924, '__ci_last_regenerate|i:1648526624;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jd1t466v44sj81s6q1fl0eirkqt8d0u7', '207.46.13.110', 1648522388, '__ci_last_regenerate|i:1648522388;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jfad283uba36nc4mne3epchjuth5s7l4', '207.46.13.13', 1648522224, '__ci_last_regenerate|i:1648522224;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jgpp900insj7ro5obiq9vsr48m1365eu', '49.37.227.22', 1648529742, '__ci_last_regenerate|i:1648529565;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jltooupmbj1ccile4pg5p12sg6q27ddr', '49.37.239.252', 1648719113, '__ci_last_regenerate|i:1648719098;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:25:\"Database Backup Completed\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('k687e5fq5iansj8t4574tng7d9i60m65', '49.37.239.252', 1648704796, '__ci_last_regenerate|i:1648704515;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('kbmorr26nmjumnv6031e34mkispfa8jj', '207.46.13.110', 1648522187, '__ci_last_regenerate|i:1648522187;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('kc9bbg48b15bb12k7b6mp2qb37enfa50', '49.37.239.252', 1648706840, '__ci_last_regenerate|i:1648706753;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('km0h9pgrkrt3gk3do2rqrtqklighlibd', '207.46.13.209', 1648522252, '__ci_last_regenerate|i:1648522252;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('lfn0p8r47njhusok73bqk091ljmfsj8h', '157.55.39.28', 1648522222, '__ci_last_regenerate|i:1648522222;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('lmc14995503rm039plk9e99uneq2j3ld', '40.117.185.219', 1648712046, '__ci_last_regenerate|i:1648712046;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('lpshe2kcku0i1p3c43gpkbh5ufiv5sak', '207.46.13.10', 1648522230, '__ci_last_regenerate|i:1648522230;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('lrh7pkbqnjo9k1ln1iboqffsmkcaagmi', '61.3.108.184', 1648710740, '__ci_last_regenerate|i:1648710686;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mbb0oe8a3uapupqedg6oe9aaasnjjdlf', '59.88.226.11', 1648530143, '__ci_last_regenerate|i:1648529724;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mce92vnbnk4i3cm9a930mmik051kse1a', '207.46.13.10', 1648522360, '__ci_last_regenerate|i:1648522360;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mdfvu187ktmg854e726lifqc6ns94t2n', '207.46.13.10', 1648522240, '__ci_last_regenerate|i:1648522240;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mjhagp1joauii9v4lgeie8qih9qs57lo', '40.77.167.104', 1648522175, '__ci_last_regenerate|i:1648522175;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mn608k3kie16k7b3drjm3e463djb373q', '61.3.108.184', 1648705579, '__ci_last_regenerate|i:1648705306;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mts96kuhefchcuph12ejdf8ojdubtkvo', '61.3.108.184', 1648719105, '__ci_last_regenerate|i:1648718938;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mushr0l2ek9hktrp9066fnbcdauisfb1', '59.88.226.11', 1648528798, '__ci_last_regenerate|i:1648528662;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('nrnei70a7m993rhl926547ip8mdve148', '54.227.32.154', 1648524308, '__ci_last_regenerate|i:1648524308;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('obd6ejm1rfa12vumq3mmhviir0gmjao5', '59.88.226.11', 1648530410, '__ci_last_regenerate|i:1648530135;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('oeaudhjlibpteut62h8g0bmcq7fjeg1m', '59.88.226.11', 1648523871, '__ci_last_regenerate|i:1648523520;redirect_url|s:49:\"https://www.quilonscans.com/billing/test_bill_add\";name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('pem3dovr2goonak9dgbsnu76e9ecbjcc', '13.66.139.0', 1648523128, '__ci_last_regenerate|i:1648523128;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ph6hbvi4h45fhmu1p0eahj00qelsjk4v', '49.37.239.252', 1648719041, '__ci_last_regenerate|i:1648718748;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:25:\"Database Backup Completed\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('pqpig4i5v8d2l72f67a9s0sub6njhti3', '59.88.226.11', 1648526552, '__ci_last_regenerate|i:1648526290;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('psgbi49891pbe8jtkra10pgjt028mr8n', '61.3.108.184', 1648711084, '__ci_last_regenerate|i:1648711066;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('pvt3mm5jpbihu491okul2tka8r31922g', '207.46.13.209', 1648522244, '__ci_last_regenerate|i:1648522244;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('q3a3gc763hfll3s18omdkubqoc6dcdeo', '207.46.13.13', 1648522214, '__ci_last_regenerate|i:1648522214;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qcej5uqpj63e37fsq6f12v9t9s1ffvvr', '207.46.13.110', 1648523089, '__ci_last_regenerate|i:1648523089;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qk3mi7ts1c2gdukrq30rhmu2hsj4ph1o', '207.46.13.209', 1648522237, '__ci_last_regenerate|i:1648522237;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ql7oaft227i2kuejvqm7sp9n761tv92u', '157.55.39.28', 1648522216, '__ci_last_regenerate|i:1648522216;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qlbk4nea3u392ajb473o8jk6c4k3g9js', '59.88.226.11', 1648531084, '__ci_last_regenerate|i:1648530838;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:39:\"Information Has Been Saved Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qn6p3dke0v01ki8k82vp9ookpq8tjn9p', '207.46.13.10', 1648522236, '__ci_last_regenerate|i:1648522236;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qp9p45vf0nnbk993lg8f4kt57d4281br', '207.46.13.110', 1648522378, '__ci_last_regenerate|i:1648522378;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('r17r7bq2h5grr00vrkh5ac1egbna898i', '40.117.185.219', 1648716465, '__ci_last_regenerate|i:1648716465;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('r3q3ikfqikq0j3on1tplqfshrfgp16ar', '207.46.13.209', 1648522248, '__ci_last_regenerate|i:1648522248;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('raavktolag9luprnp39qsd0pvba662og', '61.3.108.184', 1648713058, '__ci_last_regenerate|i:1648713023;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('rh86e786snkhgpistqn3606k99r5aeov', '157.55.39.28', 1648522241, '__ci_last_regenerate|i:1648522241;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('rira4ahjtj77vbm20n87un2ligd7lbee', '59.88.226.11', 1648528982, '__ci_last_regenerate|i:1648528982;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('rmg6kre915b8e3df1fe6ej11kfc244u6', '207.46.13.10', 1648522222, '__ci_last_regenerate|i:1648522222;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('rn6ods4rflkhg53di3fauqq2cc5iaigm', '59.88.226.11', 1648525789, '__ci_last_regenerate|i:1648525704;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('s9p958dtffuvscuu7v7jq47h52amc7dc', '185.59.221.226', 1648704333, '__ci_last_regenerate|i:1648704333;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('s9u8vkr2v48aahh8u56pmhns0r674sjo', '207.46.13.10', 1648522246, '__ci_last_regenerate|i:1648522246;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('sjud9hhkqsif3gt54doaem23q41pmm3m', '207.46.13.13', 1648522257, '__ci_last_regenerate|i:1648522257;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('sud6q6ltsn7cq04r1eflu0li18j18tqq', '61.3.108.184', 1648715494, '__ci_last_regenerate|i:1648715494;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('t6vfhat9qummkj4mgd2o81v4b77s4117', '69.4.87.74', 1648706631, '__ci_last_regenerate|i:1648706631;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('tanc8qmbe763op1i40vguqdlq3tjdva8', '207.46.13.209', 1648522234, '__ci_last_regenerate|i:1648522234;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('tbrmjpq4hhqohpiqst4vmjm5dngt2ase', '207.46.13.209', 1648522246, '__ci_last_regenerate|i:1648522246;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('tbt30o6j33949eipqftnqu5lf4tfkoj6', '131.153.240.10', 1648704843, '__ci_last_regenerate|i:1648704843;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('tcl7evdjddvl8elu8sfojda2h93al4ik', '49.37.239.252', 1648704439, '__ci_last_regenerate|i:1648704176;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('tico4qndf73mud3nio0nqgj3bfa9m7q2', '54.237.250.240', 1648524299, '__ci_last_regenerate|i:1648524299;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('tmp7uvp49unt7kiji0rnriu5uesfa5cm', '157.55.39.28', 1648522231, '__ci_last_regenerate|i:1648522231;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ts319dq38u2u86csbo63vg3us80stdbf', '49.15.202.38', 1648705282, '__ci_last_regenerate|i:1648705185;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('u1u6mc69e2p2ckdu68e30hdb5epth1o0', '207.46.13.10', 1648522212, '__ci_last_regenerate|i:1648522212;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('u6ajbvjrvfj1qodpmlpakh3eholbtddf', '207.46.13.209', 1648522251, '__ci_last_regenerate|i:1648522251;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('u9vbaleq8sdo1k503tftq7aphunkuotc', '59.88.226.11', 1648530801, '__ci_last_regenerate|i:1648530797;name|N;uniqueid|N;logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('uvv08ijpv60m0tlsm9ieru98je8u4bfe', '207.46.13.209', 1648522255, '__ci_last_regenerate|i:1648522255;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('v2ne38lu6oo57dk5gto1onnuc3lqu6sc', '207.46.13.10', 1648522240, '__ci_last_regenerate|i:1648522239;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('v477l9o6p051ijb2h4vtdh4i95tf6io8', '93.119.227.19', 1648710383, '__ci_last_regenerate|i:1648710383;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('v5o7167jhn6e95prnah3o7rns2jh4g4i', '207.46.13.10', 1648522235, '__ci_last_regenerate|i:1648522234;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vhdpib8rg6vhc8nkgu9rqmok20vb3ihk', '157.55.39.28', 1648522204, '__ci_last_regenerate|i:1648522204;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('viajnknhgis4ug6pkoaa0ppgfn20h9p5', '207.46.13.110', 1648522368, '__ci_last_regenerate|i:1648522368;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vjnvi9gsijfvmfpll2eejc7pabfcht08', '49.15.202.38', 1648705159, '__ci_last_regenerate|i:1648704879;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vpfolve7gt0pp67apebmliru7fahnpmh', '207.46.13.110', 1648522229, '__ci_last_regenerate|i:1648522229;');


#
# TABLE STRUCTURE FOR: email_config
#

DROP TABLE IF EXISTS `email_config`;

CREATE TABLE `email_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(200) DEFAULT NULL,
  `email_protocol` varchar(10) NOT NULL,
  `smtp_host` varchar(25) NOT NULL,
  `smtp_user` varchar(25) DEFAULT NULL,
  `smtp_pass` text NOT NULL,
  `smtp_port` varchar(100) NOT NULL,
  `smtp_encryption` varchar(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `email_config` (`id`, `email`, `email_protocol`, `smtp_host`, `smtp_user`, `smtp_pass`, `smtp_port`, `smtp_encryption`) VALUES (1, 'example@gmail.com', 'sendmail', 'smtp.gmail.com', 'example@gmail.com', '1234', '25', 'ssl');


#
# TABLE STRUCTURE FOR: email_templates
#

DROP TABLE IF EXISTS `email_templates`;

CREATE TABLE `email_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email_type` varchar(200) NOT NULL,
  `subject` varchar(250) NOT NULL,
  `template_body` longtext NOT NULL,
  `tags` longtext NOT NULL,
  `notified` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (1, 'account_registered', 'Account Registered', '', '{institute_name}, {name}, {username}, {password}, {user_role}, {login_url}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (2, 'forgot_password', 'Forgot Password', '', '{institute_name}, {name}, {username}, {reset_url}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (5, 'payslip_generated', 'Payslip generated', '', '{institute_name}, {name}, {month_year}, {payslip_no}, {payslip_url}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (6, 'absent', 'Absent Notice', '', '{institute_name}, {name}, {date}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (7, 'leave_approve', 'Your leave request has been approved', '', '{institute_name}, {name}, {admin_comments}, {start_date}, {end_date}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (8, 'leave_reject', 'Your leave request has been reject', '', '{institute_name}, {name}, {admin_comments}, {start_date}, {end_date}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (9, 'appointment_confirmation', 'Appointment Confirmation', '', '{institute_name}, {patient_name}, {doctor_name}, {consultation_fees}, {schedule_time}, {appointment_date}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (10, 'appointment_canceled', 'Appointment Canceled', '', '{institute_name}, {patient_name}, {doctor_name}, {consultation_fees}, {schedule_time}, {appointment_date}', 0);


#
# TABLE STRUCTURE FOR: front_cms_about
#

DROP TABLE IF EXISTS `front_cms_about`;

CREATE TABLE `front_cms_about` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `subtitle` varchar(255) DEFAULT NULL,
  `page_title` varchar(255) NOT NULL,
  `content` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `about_image` varchar(255) NOT NULL,
  `elements` mediumtext NOT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_about` (`id`, `title`, `subtitle`, `page_title`, `content`, `banner_image`, `about_image`, `elements`, `meta_description`, `meta_keyword`) VALUES (1, 'Welcome to Hospitals', 'Best Medical &amp; Healthcare Needs to Our Patients', 'About Us', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut volutpat rutrum eros amet sollicitudin interdum. Suspendisse pulvinar, velit nec pharetra interdum, ante tellus ornare mi, et mollis tellus neque vitae elit. Mauris adipiscing mauris fringilla turpis interdum sed pulvinar nisi malesuada. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>\r\n\r\n<p>Donec sed odio dui. Nulla vitae elit libero, a pharetra augue. Nullam id dolor id nibh ultricies vehicula ut id elit. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Duis mollis, est non commodo luctus, nisi erat porttitor ligula. Mauris sit amet neque nec nunc gravida.</p>\r\n\r\n<div class=\"row\">\r\n<div class=\"col-sm-6 col-12\">\r\n<ul class=\"list-unstyled list-style-3\">\r\n	<li><a href=\"#\">Cardiothoracic Surgery</a></li>\r\n	<li><a href=\"#\">Cardiovascular Diseases</a></li>\r\n	<li><a href=\"#\">Ophthalmology</a></li>\r\n	<li><a href=\"#\">Dermitology</a></li>\r\n</ul>\r\n</div>\r\n\r\n<div class=\"col-sm-6 col-12\">\r\n<ul class=\"list-unstyled list-style-3\">\r\n	<li><a href=\"#\">Cardiothoracic Surgery</a></li>\r\n	<li><a href=\"#\">Cardiovascular Diseases</a></li>\r\n	<li><a href=\"#\">Ophthalmology</a></li>\r\n</ul>\r\n</div>\r\n</div>', 'about.jpg', 'about.jpg', '{\"cta_title\":\"Get in touch to join our community\",\"button_text\":\"Contact Our Office\",\"button_url\":\"contact\"}', '', '');


#
# TABLE STRUCTURE FOR: front_cms_appointment
#

DROP TABLE IF EXISTS `front_cms_appointment`;

CREATE TABLE `front_cms_appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `page_title` varchar(255) DEFAULT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_appointment` (`id`, `title`, `description`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`) VALUES (1, 'Make An Appoinment', '<p><span style=\"color: rgb(156, 156, 156); font-family: Poppins, sans-serif; font-size: 14px; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;\">Lorem ipsum dolor sit amet, eum illum dolore concludaturque ex, ius latine adipisci no. Pro at nullam laboramus definitiones. Mandamusconceptam omittantur cu cum. Brute appetere it scriptorem ei eam, ne vim velit novum nominati. Causae volutpat percipitur at sed ne.</span></p>\r\n', 'Appointment', 'appointment.jpg', '', '');


#
# TABLE STRUCTURE FOR: front_cms_contact
#

DROP TABLE IF EXISTS `front_cms_contact`;

CREATE TABLE `front_cms_contact` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `box_title` varchar(255) DEFAULT NULL,
  `box_description` varchar(500) DEFAULT NULL,
  `box_image` varchar(255) DEFAULT NULL,
  `form_title` varchar(355) DEFAULT NULL,
  `address` varchar(355) DEFAULT NULL,
  `phone` varchar(355) DEFAULT NULL,
  `email` varchar(355) DEFAULT NULL,
  `submit_text` varchar(355) NOT NULL,
  `map_iframe` text,
  `page_title` varchar(255) NOT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_contact` (`id`, `box_title`, `box_description`, `box_image`, `form_title`, `address`, `phone`, `email`, `submit_text`, `map_iframe`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`) VALUES (1, 'WE\'D LOVE TO HEAR FROM YOU', 'Fusce convallis diam vitae velit tempus rutrum. Donec nisl nisl, vulputate eu sapien sed, adipiscing vehicula massa. Mauris eget commodo neque, id molestie enim.', 'contact-info-box.png', 'Get in touch by filling the form below', '4896  Romrog Way, LOS ANGELES,\r\nCalifornia', '954-648-1802, \r\n963-612-1782', 'info@example.com\r\nsupport@example.com', 'Send', '<iframe width=\"100%\" height=\"350\" id=\"gmap_canvas\" src=\"https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3313.3833161665298!2d-118.03745848530627!3d33.85401093559897!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x80dd2c6c97f8f3ed%3A0x47b1bde165dcc056!2sOak+Dr%2C+La+Palma%2C+CA+90623%2C+USA!5e0!3m2!1sen!2sbd!4v1544238752504\" frameborder=\"0\" scrolling=\"no\" marginheight=\"0\" marginwidth=\"0\"></iframe>', 'Contact Us', 'contact.jpg', '', '');


#
# TABLE STRUCTURE FOR: front_cms_doctor_bio
#

DROP TABLE IF EXISTS `front_cms_doctor_bio`;

CREATE TABLE `front_cms_doctor_bio` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `doctor_id` varchar(20) NOT NULL,
  `biography` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_doctor_bio` (`id`, `doctor_id`, `biography`) VALUES (1, '2', '<p>Senior Surgeon</p>');


#
# TABLE STRUCTURE FOR: front_cms_doctors
#

DROP TABLE IF EXISTS `front_cms_doctors`;

CREATE TABLE `front_cms_doctors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_title` varchar(255) DEFAULT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_doctors` (`id`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`) VALUES (1, 'Doctors', 'doctors.jpg', '', '');
INSERT INTO `front_cms_doctors` (`id`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`) VALUES (2, 'Doctor Profile', 'doctor_profile.jpg', '', '');


#
# TABLE STRUCTURE FOR: front_cms_faq
#

DROP TABLE IF EXISTS `front_cms_faq`;

CREATE TABLE `front_cms_faq` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `page_title` varchar(255) DEFAULT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_faq` (`id`, `title`, `description`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`) VALUES (1, 'Frequently Asked Questions', '<p>Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident.</p>\r\n\r\n<p>Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven&#39;t heard of them accusamus labore sustainable VHS.</p>', 'Faq', 'faq.jpg', '', '');


#
# TABLE STRUCTURE FOR: front_cms_faq_list
#

DROP TABLE IF EXISTS `front_cms_faq_list`;

CREATE TABLE `front_cms_faq_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`) VALUES (1, 'Any Information you provide on applications for disability, life or accidental insurance ?', '<p>\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco quat. It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.\r\n</p>\r\n<ul>\r\n<li>Lorem ipsum dolor sit amet, consectetur adipisicing elit.</li>\r\n<li>Sed do eiusmod tempor incididunt ut labore et dolore magna aliq.</li>\r\n<li>Ut enim ad minim veniam, quis nostrud exercitation ullamco quat. It is a long established fact.</li>\r\n<li>That a reader will be distracted by the readable content of a page when looking at its layout.</li>\r\n<li>Lorem ipsum dolor sit amet, consectetur adipisicing elit.</li>\r\n<li>Eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam.</li>\r\n<li>Quis nostrud exercitation ullamco quat. It is a long established fact that a reader will be distracted.</li>\r\n<li>Readable content of a page when looking at its layout.</li>\r\n<li>The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters.</li>\r\n<li>Opposed to using \'Content here, content here\', making it look like readable English.</li>\r\n</ul>');
INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`) VALUES (2, 'Readable content of a page when looking at its layout ?', '<p>\r\n                                Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven\'t heard of them accusamus labore sustainable VHS.\r\n                            </p>\r\n                            <ol>\r\n                                <li>Quis nostrud exercitation ullamco quat. It is a long established fact that a reader will be distracted.</li>\r\n                                <li>Readable content of a page when looking at its layout.</li>\r\n                                <li>The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters.</li>\r\n                                <li>Opposed to using \'Content here, content here\', making it look like readable English.</li>\r\n                            </ol>\r\n                            <p>\r\n                                Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\r\n                            </p>');
INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`) VALUES (3, 'Opposed to using \'Content here, content here\', making it look like readable English ?', '<p>\r\n                                Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven\'t heard of them accusamus labore sustainable VHS.\r\n                            </p>\r\n                            <ol>\r\n                                <li>Quis nostrud exercitation ullamco quat. It is a long established fact that a reader will be distracted.</li>\r\n                                <li>Readable content of a page when looking at its layout.</li>\r\n                                <li>The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters.</li>\r\n                                <li>Opposed to using \'Content here, content here\', making it look like readable English.</li>\r\n                            </ol>\r\n                            <p>\r\n                                Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\r\n                            </p>');
INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`) VALUES (4, 'Readable content of a page when looking at its layout ?', '<p>\r\n                                Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven\'t heard of them accusamus labore sustainable VHS.\r\n                            </p>\r\n                            <ol>\r\n                                <li>Quis nostrud exercitation ullamco quat. It is a long established fact that a reader will be distracted.</li>\r\n                                <li>Readable content of a page when looking at its layout.</li>\r\n                                <li>The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters.</li>\r\n                                <li>Opposed to using \'Content here, content here\', making it look like readable English.</li>\r\n                            </ol>\r\n                            <p>\r\n                                Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\r\n                            </p>');
INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`) VALUES (5, 'What types of documents are required to travel?', '<p><strong>Lorem ipsum</strong> dolor sit amet, an labores explicari qui, eu nostrum copiosae argumentum has. Latine propriae quo no, unum ridens expetenda id sit, at usu eius eligendi singulis. Sea ocurreret principes ne. At nonumy aperiri pri, nam quodsi copiosae intellegebat et, ex deserunt euripidis usu. Per ad ullum lobortis. Duo volutpat imperdiet ut, postea salutatus imperdiet ut per, ad utinam debitis invenire has.</p>\r\n\r\n<ol>\r\n	<li>labores explicari qui</li>\r\n	<li>labores explicari qui</li>\r\n	<li>labores explicari quilabores explicari qui</li>\r\n	<li>labores explicari qui</li>\r\n</ol>');


#
# TABLE STRUCTURE FOR: front_cms_home
#

DROP TABLE IF EXISTS `front_cms_home`;

CREATE TABLE `front_cms_home` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `subtitle` varchar(255) DEFAULT NULL,
  `item_type` varchar(20) NOT NULL,
  `description` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `elements` mediumtext NOT NULL,
  `active` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (1, 'We Offer Fast &amp; Reliable', 'Medical &amp; Healthcare Needs', 'wellcome', 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using content.\r\n\r\nMaking it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).', '{\"image\":\"wellcome.jpg\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (2, 'Experience Doctor Team', NULL, 'doctors', 'Making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident.', '{\"doctor_start\":\"1\",\"image\":\"featured-parallax.jpg\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (3, 'Our Best Medical Services', NULL, 'services', 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.', '', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (4, 'Online Hassle Free Appointment Booking', 'Medical Services', 'cta', '', '{\"mobile_no\":\"+2484-398-8987\",\"button_text\":\"Book your Appointment\",\"button_url\":\"appointment\",\"image\":\"appointment-booking-img.png\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (5, 'Best <span>Digital</span> Experience', NULL, 'slider', 'Lorem Ipsum is simply dummy text printer took a galley of type and scrambled it to make a type specimen book.', '{\"position\":\"c-left\",\"button_text1\":\"View Services\",\"button_url1\":\"#\",\"button_text2\":\"Learn More\",\"button_url2\":\"#\",\"image\":\"home-slider-1578743357.jpg\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (6, 'Main Heading <span>Some Caption</span> Here', NULL, 'slider', 'Lorem Ipsum is simply dummy text printer took a galley of type and scrambled it to make a type specimen book.', '{\"position\":\"c-center\",\"button_text1\":\"Read More\",\"button_url1\":\"#\",\"button_text2\":\"Get Started\",\"button_url2\":\"#\",\"image\":\"home-slider-1578743366.jpg\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (7, 'Here creative & professional <span>PHP</span> template', NULL, 'slider', 'Lorem Ipsum is simply dummy text printer took a galley of type and scrambled it to make a type specimen book.', '{\"position\":\"c-right\",\"button_text1\":\"Read More\",\"button_url1\":\"#\",\"button_text2\":\"Contact us\",\"button_url2\":\"contact\",\"image\":\"home-slider-1578743373.jpg\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (8, 'Qualified Doctors', NULL, 'features', 'Nulla metus metus ullamcorper vel tincidunt sed euismod nibh Quisque volutpat condimentum velit class aptent taciti sociosqu.', '{\"button_text\":\"Read More\",\"button_url\":\"#\",\"icon\":\"fas fa-user-md\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (9, 'Regular Checkup', NULL, 'features', 'Nulla metus metus ullamcorper vel tincidunt sed euismod nibh Quisque volutpat condimentum velit class aptent taciti sociosqu.', '{\"button_text\":\"Read More\",\"button_url\":\"#\",\"icon\":\"fas fa-stethoscope\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (10, 'Neurosurgeon', NULL, 'features', 'Nulla metus metus ullamcorper vel tincidunt sed euismod nibh Quisque volutpat condimentum velit class aptent taciti sociosqu.', '{\"button_text\":\"Read More\",\"button_url\":\"#\",\"icon\":\"fas fa-vial\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (11, '24 Hours  Service', NULL, 'features', 'Nulla metus metus ullamcorper vel tincidunt sed euismod nibh Quisque volutpat condimentum velit class aptent taciti sociosqu.', '{\"button_text\":\"Read More\",\"button_url\":\"#\",\"icon\":\"far fa-clock\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (12, 'Our Happy Patients Opinion', NULL, 'testimonial', 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.', '', 0);


#
# TABLE STRUCTURE FOR: front_cms_home_seo
#

DROP TABLE IF EXISTS `front_cms_home_seo`;

CREATE TABLE `front_cms_home_seo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_title` varchar(255) NOT NULL,
  `meta_keyword` text NOT NULL,
  `meta_description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_home_seo` (`id`, `page_title`, `meta_keyword`, `meta_description`) VALUES (1, 'Home', '', '');


#
# TABLE STRUCTURE FOR: front_cms_menu
#

DROP TABLE IF EXISTS `front_cms_menu`;

CREATE TABLE `front_cms_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `alias` varchar(100) NOT NULL,
  `ordering` int(11) NOT NULL,
  `parent_id` int(11) DEFAULT '0',
  `open_new_tab` int(11) NOT NULL DEFAULT '0',
  `ext_url` int(11) NOT NULL DEFAULT '0',
  `ext_url_address` text,
  `publish` int(11) NOT NULL,
  `system` varchar(10) NOT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (1, 'Home', 'index', 1, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (2, 'Appointment', 'appointment', 3, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (3, 'Doctors', 'doctors', 4, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (4, 'About Us', 'about', 2, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (5, 'FAQ', 'faq', 5, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (6, 'Contact Us', 'contact', 6, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');


#
# TABLE STRUCTURE FOR: front_cms_pages
#

DROP TABLE IF EXISTS `front_cms_pages`;

CREATE TABLE `front_cms_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_title` varchar(255) NOT NULL,
  `content` longtext CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `menu_id` int(11) NOT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_services
#

DROP TABLE IF EXISTS `front_cms_services`;

CREATE TABLE `front_cms_services` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `subtitle` varchar(255) DEFAULT NULL,
  `parallax_image` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_services` (`id`, `title`, `subtitle`, `parallax_image`) VALUES (1, 'Get Well Soon', 'Our Hosptial <span>Services</span>', 'service_parallax.jpg');


#
# TABLE STRUCTURE FOR: front_cms_services_list
#

DROP TABLE IF EXISTS `front_cms_services_list`;

CREATE TABLE `front_cms_services_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `icon` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (1, 'First Aid', 'Making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text.', 'fas fa-medal');
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (2, 'Dental Care', 'Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover.', 'fas fa-heartbeat');
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (3, '24x7 Ambulance', 'Making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model.', 'fas fa-ambulance');
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (4, 'Qualified Doctors', 'Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will.', 'fas fa-capsules');
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (5, 'Medical Pharmacy', 'Making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover.', 'fas fa-stethoscope');
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (6, 'Pulmonary', 'Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a for \'lorem ipsum\' will uncover.', 'fas fa-medkit');


#
# TABLE STRUCTURE FOR: front_cms_setting
#

DROP TABLE IF EXISTS `front_cms_setting`;

CREATE TABLE `front_cms_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `application_title` varchar(255) NOT NULL,
  `captcha_status` varchar(20) NOT NULL,
  `recaptcha_site_key` varchar(255) NOT NULL,
  `recaptcha_secret_key` varchar(255) NOT NULL,
  `address` varchar(350) NOT NULL,
  `mobile_no` varchar(60) NOT NULL,
  `fax` varchar(60) NOT NULL,
  `receive_contact_email` varchar(255) NOT NULL,
  `email` varchar(60) NOT NULL,
  `footer_text` varchar(255) NOT NULL,
  `fav_icon` varchar(255) NOT NULL,
  `logo` varchar(255) NOT NULL,
  `working_hours` varchar(300) NOT NULL,
  `facebook_url` varchar(100) NOT NULL,
  `twitter_url` varchar(100) NOT NULL,
  `youtube_url` varchar(100) NOT NULL,
  `google_plus` varchar(100) NOT NULL,
  `linkedin_url` varchar(100) NOT NULL,
  `pinterest_url` varchar(100) NOT NULL,
  `instagram_url` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_setting` (`id`, `application_title`, `captcha_status`, `recaptcha_site_key`, `recaptcha_secret_key`, `address`, `mobile_no`, `fax`, `receive_contact_email`, `email`, `footer_text`, `fav_icon`, `logo`, `working_hours`, `facebook_url`, `twitter_url`, `youtube_url`, `google_plus`, `linkedin_url`, `pinterest_url`, `instagram_url`) VALUES (1, 'DMS- Diagnostic Management System With CMS', 'disable', '', '', 'Quilon Scans', '+1-954-648-1802', '001 - 785 987 1234', 'info@example.com', 'info@demo.com', '©2022 <span>Quilon Scans</span> - Developed by Logiprompt Techno Solutions India Pvt Ltd', 'fav_icon.ico', 'logo.png', '<span>Hours : </span>  Mon To Fri - 9:00 - 20:00,  Sunday Closed', 'https://facebook.com', 'https://twitter.com', 'https://youtube.com', 'https://google.com', 'https://linkedin.com', 'https://pinterest.com', 'https://instagram.com');


#
# TABLE STRUCTURE FOR: front_cms_testimonial
#

DROP TABLE IF EXISTS `front_cms_testimonial`;

CREATE TABLE `front_cms_testimonial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_name` varchar(255) NOT NULL,
  `surname` varchar(355) NOT NULL,
  `image` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `rank` int(5) NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_testimonial` (`id`, `patient_name`, `surname`, `image`, `description`, `rank`, `created_by`, `created_at`) VALUES (1, 'Gartrell Wright', 'Los Angeles', 'defualt.png', 'Intexure have done an excellent job presenting the analysis & insights. I am confident in saying  have helped encounter  is to be welcomed and every pain avoided”.', 1, 1, '2019-08-23 18:26:42');
INSERT INTO `front_cms_testimonial` (`id`, `patient_name`, `surname`, `image`, `description`, `rank`, `created_by`, `created_at`) VALUES (2, 'Clifton Hyde', 'Newyork City', 'defualt.png', '“Owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted always holds”.', 4, 1, '2019-08-23 18:26:42');
INSERT INTO `front_cms_testimonial` (`id`, `patient_name`, `surname`, `image`, `description`, `rank`, `created_by`, `created_at`) VALUES (3, 'Emily Lemus', 'Los Angeles', 'defualt.png', '“Intexure have done an excellent job presenting the analysis & insights. I am confident in saying  have helped encounter  is to be welcomed and every pain avoided”.', 5, 1, '2019-08-23 18:26:42');
INSERT INTO `front_cms_testimonial` (`id`, `patient_name`, `surname`, `image`, `description`, `rank`, `created_by`, `created_at`) VALUES (4, 'Michel Jhon', 'CEO', 'defualt.png', '“Owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted always holds”.', 3, 1, '2019-08-23 18:26:42');
INSERT INTO `front_cms_testimonial` (`id`, `patient_name`, `surname`, `image`, `description`, `rank`, `created_by`, `created_at`) VALUES (5, 'Hilda Howard', 'Chicago City', 'defualt.png', '“Owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted always holds”.', 4, 1, '2019-08-23 18:26:42');


#
# TABLE STRUCTURE FOR: global_settings
#

DROP TABLE IF EXISTS `global_settings`;

CREATE TABLE `global_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `institute_name` varchar(255) NOT NULL,
  `institute_email` varchar(100) NOT NULL,
  `address` text NOT NULL,
  `mobileno` varchar(50) NOT NULL,
  `currency` varchar(50) NOT NULL,
  `currency_symbol` varchar(50) NOT NULL,
  `translation` varchar(20) NOT NULL,
  `footer_text` text NOT NULL,
  `animations` varchar(50) NOT NULL,
  `timezone` varchar(30) NOT NULL,
  `date_format` varchar(20) CHARACTER SET utf32 COLLATE utf32_unicode_ci NOT NULL,
  `facebook_url` varchar(255) NOT NULL,
  `twitter_url` varchar(255) NOT NULL,
  `linkedin_url` varchar(255) NOT NULL,
  `youtube_url` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `global_settings` (`id`, `institute_name`, `institute_email`, `address`, `mobileno`, `currency`, `currency_symbol`, `translation`, `footer_text`, `animations`, `timezone`, `date_format`, `facebook_url`, `twitter_url`, `linkedin_url`, `youtube_url`, `created_at`, `updated_at`) VALUES (1, 'Quilon Scans', 'quilonscans@yahoo.com', 'LDNRA 118, Near Taluk Office, Vadakkumbhagam, Kollam-1', '9562506027 / 0474-2743114 / 0474 - 2743115', 'INR', '₹', 'english', '© 2022 Quilon Scans - Developed by Logiprompt Techno Solutions India Pvt Ltd', 'fadeInUp', 'Asia/Dhaka', '%d-%b-%Y', '', '', '', '', '2018-10-22 15:07:49', '2022-03-26 11:20:26');


#
# TABLE STRUCTURE FOR: lab_report_template
#

DROP TABLE IF EXISTS `lab_report_template`;

CREATE TABLE `lab_report_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `template` longtext NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=226 DEFAULT CHARSET=utf8;

INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (16, 'EXAMINATION OF STOOL', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">EXAMINATION OF STOOL</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Colour&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;&nbsp;&nbsp;Brown&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Consistency&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp;Formed&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Blood&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; :&nbsp; &nbsp; &nbsp; Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Mucus&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><u><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\"><strong>MICROSCOPICAL EXAMINATION</strong></span></span></span></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Ova&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;NotSeen&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Cysts&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;NotSeen&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Pus Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;4-6 /HPF&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">R B Cs&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Undigested food particles&nbsp; &nbsp;:&nbsp; &nbsp;Nil&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 11:11:22', '2022-03-17 12:20:05');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (17, 'OCCULT BLOOD TEST', '<p style=\"margin-bottom:14px\"><u><strong>OCCULT BLOOD TEST</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Occult Blood&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;&nbsp;Negative</span></span></span></p>\r\n', '2022-03-17 11:14:06', '2022-03-17 16:24:04');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (18, 'EXAMINATION OF URINE ', '<p style=\"margin-bottom:14px\"><strong><u>EXAMINATION OF URINE</u></strong>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">a) PHYSICAL CHARACTERS :&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Colour&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Pale Yellow&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Transparency&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Clear&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Reaction&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Acidic&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">b) CHEMICAL CONSTITUENTS :&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Albumin&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Sugar&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">c) MICROSCOPICAL EXAMINATION :&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;Amorphous Urates &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;Epithelial Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; : 0-2/HPF&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;Pus Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; : 1-2/HPF&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; R B C s &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; : Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; Casts&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; : Nil&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; </span></span></span>Crystals Uric Acid&nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">: Nil&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; </span></span></span>Bacteria&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">: Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; </span></span></span>Yeast Cells&nbsp;<span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; : Nil</span></span></span></p>\r\n', '2022-03-17 11:25:47', '2022-03-29 11:20:57');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (19, 'THYROID FUNCTION TEST (Child)            ', '<p style=\"margin-bottom:14px\"><u><strong>THYROID FUNCTION TEST (Child)</strong></u> &nbsp;&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;T3(CLIA METHOD)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;141.8ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Cord blood:15.0-75.0ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1-3 Days:32.0-216.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3-30 Days::50.0-250.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;1-12 Months:105.0-280.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;1-5 Years:105.0-269.0,ng/dL&nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">5-10Years:94.0-241.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">10-16Years:83.0-213.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">15-18 Years:80.0-210.0ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T4 (CLIA METHOD)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 9.3 ug/dL&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Cord blood :&nbsp;4.6-&nbsp;13.0,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1- 3 Days&nbsp; :&nbsp; 11.8-23.2,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;3-10 Days&nbsp; :&nbsp;&nbsp; 9.9-21.9,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 10-45 Days :&nbsp;&nbsp; 8.2-16.2ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 45-95 Days :&nbsp;&nbsp; 6.4-14.0ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3-12 Months:&nbsp;&nbsp; 7.8-16.5,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1- 5 Years :&nbsp;&nbsp; 7.3-15.0,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 5-10 Years :&nbsp;&nbsp; 6.4-13.3,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;10-15 Years :&nbsp;&nbsp; 5.6-11.7,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;15-18 Years :&nbsp;&nbsp; 4.2-11.8&#39;ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">TSH (CLIA-ULTRASENSITIVE)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 4.31 uIU/ml&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&lt;1 Month : 0.4 - 20.0 uIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1 Month to 10 Year : 0.4 - 10.0 uIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Above 10 Year : 0.4 - 4.5 uIU/mL</span></span></span></p>\r\n', '2022-03-17 11:36:11', '2022-03-22 16:12:50');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (20, 'DENGUE  IgM TEST', '<p style=\"margin-bottom:14px\"><u><strong>DENGUE &nbsp;IgM TEST</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">DENGUE&nbsp; IgM (serum by EIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; EQUIVOCAL(9.20)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; Negative&nbsp; &nbsp;&lt; 9.0 PanBio Units</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Equivocal 9-11 PanBio Units</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Positive &gt; 11 PanBio Units</span></span></span></p>\r\n', '2022-03-17 11:53:23', '2022-03-17 12:16:51');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (21, 'LACTATE,PLASMA TEST                  ', '<p style=\"margin-bottom:14px\"><u><strong>LACTATE,PLASMA TEST</strong></u> &nbsp; &nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Lactate,Plasma&nbsp;(Plasma,Colorimetry) &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2.3 mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; 0.4&nbsp;-&nbsp;2.0mmol/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 11:58:12', '2022-03-17 12:14:44');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (22, 'E2 - ESTRADIOL LEVEL      ', '<p style=\"margin-bottom:14px\"><u><strong>E2 - ESTRADIOL LEVEL</strong></u><em><strong> </strong></em>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">E2 - Estradiol level&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 79.7 pg/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Normal Menstruating Women:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Follicular phase: 21 to 251 pg/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Mid cycle peak :38 - 649 pg/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Luteal phase :21 to 312 pg/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Menopause :&lt; 10 to 28 pg/mL</span></span></span></p>\r\n', '2022-03-17 12:04:42', '2022-03-17 12:14:02');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (23, 'SERUM PHOSPHORUS TEST', '<p style=\"margin-bottom:14px\"><u><strong>SERUM PHOSPHORUS TEST</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"tab-stops:84.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;Phosphorus&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 5 . 4 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;2.3 &ndash; 4.7 mg/dL</span></span></span></span></p>\r\n', '2022-03-17 12:13:08', '2022-03-17 12:53:05');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (24, 'SERUM CALCIUM TEST', '<p><u><strong>SERUM CALCIUM TEST</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"tab-stops:84.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">S.Calcium&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 10.1 mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Adult : 8.5 - 10. 1 mg/dL</span></span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"tab-stops:84.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Children : 9 - 11 mg/dL</span></span></span></span></p>\r\n', '2022-03-17 12:23:24', '2022-03-17 12:23:24');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (25, 'WIDAL TEST TUBE METHOD', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">WIDAL TEST TUBE METHOD</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <strong>TEST&nbsp;</strong> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <strong>&nbsp; DILUTION</strong>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;<strong>NORMAL RANGE</strong></span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;&nbsp; &nbsp;Salmonella typhi&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&quot;O&quot; Antigen&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1:20</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; Salmonella typhi&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &quot;H&quot; Antigen&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1:20</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; Salmonella paratyphi&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &quot;AH&quot; Antigen&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1:20</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; Salmonella Paratyphi&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &quot;BH&quot; Antigen&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1:20</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; (Significant Dilution&nbsp; 1: 80 or more)&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 12:31:44', '2022-03-17 12:31:44');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (26, 'URINE MICROALBUMINURIA REPORT', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">URINE MICROALBUMINURIA REPORT</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Microalbumin,urine&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 92.5 mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine Urine by Drychemistry&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 505.7 mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Microalbuminuria&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;18.3 ug/mgC&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;30ug/mgC</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Microalbuminuria&nbsp; 30 - 300ug/mgC</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Clinical albuminuria &gt; 300ug/mgC</span></span></span></p>\r\n', '2022-03-17 12:36:50', '2022-03-17 12:36:50');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (27, ' LDH TEST', '<p><strong>&nbsp;</strong><u><strong>LDH TEST</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">LDH Lactate Dehydrogenase (Serum IFCC method )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;241 U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 125&nbsp; -&nbsp; 220 U/L</span></span></span><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;</span></span></span><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 12:47:00', '2022-03-17 12:48:25');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (28, 'BETA HCG TEST', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">BETA HCG TEST</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HCG Beta Subunit.Serum</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Serum,ECLIA)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HCG Beta Subunit&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1213.0 IU/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Non Pregnant:&lt; 10 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Peri&amp;Post menopausal:5-50 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Pregnant: ReferInterpretation</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1 to2 Weeks:50 to 500 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 2 to 3 Weeks:100to 500 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3 to 4 Weeks:500 to 10000 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 4 to 5 Weeks:1000 to 50000 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 5 to 6 Weeks:10.000to1.00.000 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 6 to 8 Weeks:15.0000 to 2.00.000 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 2 to 3 Weeks : 10.000 to1.00.000 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 11 to 16 Weeks : 6000 to 30. 000 IU/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 16 to 21 Weeks : 400 to 15,000 IU/L</span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 21 to 39 Weeks:2,700 to 78,100&nbsp; IU/L</span></span></span></p>\r\n', '2022-03-17 12:58:57', '2022-03-17 12:58:57');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (29, 'FREE TESTOSTERONE', '<p><u><strong>FREE TESTOSTERONE</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Free Testosterone(serum by RIA) &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;3.70 pg/mL&nbsp; &nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Normal Female:0.29-3.18 pg/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Follicular Phase: 0.45-3.17 pg/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Luteal Phase:0.46-2.48 pg/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Oral Contraceptives:0.29-1.73 pg/mL</span></span></span></p>\r\n', '2022-03-17 13:02:11', '2022-03-17 13:02:11');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (30, 'ANTI CARDIOLIPIN ANTIBODY-IgG ', '<p><u><strong>ANTI CARDIOLIPIN ANTIBODY-IgG&nbsp;</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Anti Cardiolipin antibody-IgG&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative(4.00) GPL U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative : &lt;10 GPL U/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; High Positive:&gt;=40 GPL U/mL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Low Positive:10-20 GPL U/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Moderate Positive:20.01-40 GPLU/mL</span></span></span></p>\r\n', '2022-03-17 13:05:22', '2022-03-17 13:26:56');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (31, 'Anti CARDIOLIPIN ANTIBODY-IgM ', '<p><u><strong>Anti CARDIOLIPIN ANTIBODY-IgM&nbsp;</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Anti Cardiolipin Antibody-IgM&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative(3.80)&nbsp; MPL U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative :&lt; 7 MPL U/mL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive :&gt; = 7 MPL U/mL</span></span></span></p>\r\n', '2022-03-17 13:08:44', '2022-03-17 13:27:11');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (32, 'APA -(PHOSPHOLIPIDS)-lgG ', '<p><u><strong>APA -(PHOSPHOLIPIDS)-lgG&nbsp;</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">APA -(Phospholipids)-lgG(Serum,ElA)&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative(6.40) GPL/U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Negative&lt;=10 GPLU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive:&gt;10 GPL U/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 13:12:38', '2022-03-17 13:27:28');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (33, 'APA -(PHOSPHOLIPIDS)-lgM ', '<p><strong><u>APA -(PHOSPHOLIPIDS)-lgM&nbsp;</u></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">APA -(Phospholipids)-lgM(Serum,ElA)&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Negative(5.20) MPL U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative &lt;=10 MPL U/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Positive: &gt; 10 MPL U/mL</span></span></span></p>\r\n', '2022-03-17 13:18:16', '2022-03-17 13:27:48');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (34, 'LUPUS ANTICOAGULANT *             ', '<p><u><strong>LUPUS ANTICOAGULANT * </strong></u>&nbsp; &nbsp; &nbsp;&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Lupus Anticoagulant * (Citrated Plasma)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1.0&nbsp; Ratio&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0 -1.3 Ratio </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 13:21:41', '2022-03-17 13:28:07');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (35, 'BETA-2-GLYCOPROTEIN 1-IgG* ', '<p><u><strong>BETA-2-GLYCOPROTEIN 1-IgG*&nbsp;</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Beta-2-Glycoprotein 1-IgG* (Serum,ElA)&nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative(7) RU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative:&lt;20 RU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Positive:&gt;=20 RU/mL</span></span></span></p>\r\n', '2022-03-17 13:26:34', '2022-03-17 13:26:34');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (36, 'BETA-2-GLYCOPROTEIN 1-IgM*', '<p><u><strong>BETA-2-GLYCOPROTEIN 1-IgM*</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Beta-2-Glycoprotein 1-IgM*&nbsp;(Serum,ELA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative(8.8) RU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative:&lt;20 RU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive:&gt;=20 RU/mL</span></span></span></p>\r\n', '2022-03-17 13:30:03', '2022-03-17 13:30:03');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (37, 'TESTOSTERONE(TOTAL)', '<p><u><strong>TESTOSTERONE(TOTAL)</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Testosterone(Total),(serum by CLIA )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 751.56 ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 260-1000&nbsp; ng/dL</span></span></span></p>\r\n', '2022-03-17 14:37:07', '2022-03-17 14:37:07');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (38, 'FSH-FOLLICLE STIMULATING HORMONE', '<p><u><strong>FSH-FOLLICLE STIMULATING HORMONE</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">FSH-Follicle Stimulating Hormone&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; 2.00mIU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Follicular Phase:1.4-9.9 mIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Mid Cycle Peak :0.2-17.2 mIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Luteal Phase&nbsp;&nbsp; :1.1-9.2 mIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Post Menopausal:19.3-100.6 mIU/mL</span></span></span></p>\r\n', '2022-03-17 14:39:45', '2022-03-17 14:39:45');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (39, 'LH-LEUTINISING HORMONE', '<p><u><strong>LH-LEUTINISING HORMONE</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">LH-Leutinising Hormone&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 8.40 mIU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Follicular Phase:1.7-15 mIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Mid Cycle Peak:21.9-56.6 mIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Lutel Phase&nbsp;&nbsp;&nbsp;&nbsp; :0.6-16.3 mIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Post Menopausal :14.2-52.3mIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 14:41:29', '2022-03-17 14:41:29');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (40, 'PROGESTERONE', '<p><u><strong>PROGESTERONE</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Progesterone&nbsp;(Serum,CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;1.00 ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Menstrual Cycle:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Follicular Phase:&nbsp;&lt;0.3ng/mL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;LutealPhase:1.2-15.9ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Post menopausal:&lt;0.2ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Pregnancy:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;First Trimester:2.8-147.3ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Second Trimester:22.5-95.3ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Third trimester:27.9-242.5ng/mL</span></span></span></p>\r\n', '2022-03-17 14:45:04', '2022-03-17 14:45:04');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (42, 'DHEAS', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">DHEAS</span></span></span></strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">DHEAS Serum bby RIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;100 - 800 ng/dL</span></span></span></p>\r\n', '2022-03-17 14:46:53', '2022-03-17 14:46:53');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (43, 'ALDOSTERONE', '<p><u><strong>ALDOSTERONE</strong></u></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Aldosterone&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;380.0 pg/ml&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Supine:8-12 pg/ml</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Upright:30-355 pg/ml</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Children:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;At birth:300-1900 pg/ml</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1month to 2years:20-1100 pg/ml</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; From 3-16years:12-340 pg/ml</span></span></span></p>\r\n', '2022-03-17 14:48:31', '2022-03-17 14:48:31');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (44, 'LEPTOSPIRA-IgM              ', '<p><u><strong>LEPTOSPIRA-IgM</strong></u></p>\r\n\r\n<p>&nbsp;<span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Leptospira-IgM&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative(2) PanBio Units&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative:&lt;9 PanBio Units </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Equivocal 9-11 PanBio Units</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive:&gt;=11 PanBio Units</span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-17 14:52:00', '2022-03-17 14:52:00');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (45, 'LEPTOSPIRA-IgG       ', '<p><u><strong>LEPTOSPIRA-IgG </strong></u>&nbsp; &nbsp; &nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Leptospira-IgG&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive 2.8 NTU&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive:&lt;9 NTU</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Weak Reactive:9 -11 NTU</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Reactive:&gt;=9 NTU&nbsp; </span></span></span></p>\r\n', '2022-03-17 14:53:40', '2022-03-17 14:53:40');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (47, ' CPK', '<p><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;</span></span></span></strong><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">CPK</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine Phospho Kinase(CPK)(Serum by IFCC)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;170.0 U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;30 - 200 U/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 15:02:22', '2022-03-17 15:03:40');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (48, 'CK MB', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">CK MB</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">MB Fraction of Creatinine Kinase(CK MB)(Serum,ECLIA&nbsp;)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 30.0 U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt; 24.0 U/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 15:03:28', '2022-03-17 15:03:28');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (49, 'TROPONIN T QUANTITATIVE', '<p><u><strong>TROPONIN T QUANTITATIVE</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Troponin T Quantitative(Serum by ECLIA )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.01 ug/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative : 0.01 ug/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive : &gt;0.01 ug/L</span></span></span></p>\r\n', '2022-03-17 15:05:30', '2022-03-17 15:06:35');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (50, 'TROPONIN-I               ', '<p><u><strong>TROPONIN-I</strong></u><strong> &nbsp; &nbsp;</strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Troponin-l&nbsp;&nbsp;(Serum,CMlA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;ug/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;Negative : &lt;0.11ug/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 15:08:37', '2022-03-17 15:08:37');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (51, 'URINE VMA', '<p><u><strong>URINE VMA</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Vanillyl Mandelic Acid(VMA),Urine&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3.8 ug/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Normal &lt; 4.5 ug/mL</span></span></span></p>\r\n', '2022-03-17 15:09:25', '2022-03-17 15:09:25');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (52, 'HELICOBACTER PYLORI -IgG       ', '<p><u><strong>HELICOBACTER PYLORI -IgG</strong></u> &nbsp; &nbsp; &nbsp;</p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Helicobacter pylori -IgG&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 15.3 Eu/ml&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;20 Eu/ml</span></span></span>&nbsp;</p>\r\n', '2022-03-17 15:10:51', '2022-03-17 15:10:51');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (53, 'HELICOBACTER PYLORI -IgM       ', '<p><u><strong>HELICOBACTER PYLORI -IgM</strong></u> &nbsp; &nbsp; &nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Helicobacter pylori -IgM&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative:&lt; 8 U/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; quivocal:8-12U/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Positive:&gt;12 U/mL</span></span></span></p>\r\n', '2022-03-17 15:12:38', '2022-03-17 15:12:38');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (54, 'FREE-PSA*', '<p><u><strong>FREE-PSA*</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Free-PSA(Prostate Specific Antigen)*&nbsp;(Serum,CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.975 ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0 - 0.5 ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 15:14:31', '2022-03-17 15:14:31');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (55, 'PSA', '<p><strong><u>PSA</u></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">PSA-Prostate Specific Antigen(Serum,ECLlA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Coventional for all ages:0 - 4ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;60 - 69 Yrs:0- 4.5 ng/mL</span></span></span></p>\r\n', '2022-03-17 15:16:35', '2022-03-17 15:16:35');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (56, 'CEA', '<p><strong><u><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">CEA</span></span></span></u></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Carcino Embryonic Antigen(CEA)Serum by CLIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;NonSmoking0-2.5 ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Smoking 0 - 50.0 ng/mL&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 15:18:00', '2022-03-17 15:18:00');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (57, 'LITHIUM TEST', '<p><strong><u>LITHIUM TEST</u></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Lithium(Serum,Colorimetry)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Therapeutic range : 0.6 - 1.2 mmol/L </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Toxic :Potentially: &gt; 1.5 mmol/L&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Toxic :Severely&nbsp;&nbsp; : &gt; 2.0 mmol/L</span></span></span></p>\r\n', '2022-03-17 15:19:40', '2022-03-17 15:19:40');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (58, 'ANTI HCV', '<p><u><strong>ANTI HCV</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">IMMUNOASSAY :</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HCV-Antibody&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; 0.08(Non-Reactive)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Reactive:&gt;=1.0 Cut Off Index</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Non-Reactive:&lt;1.0 Cut Off Index</span></span></span></p>\r\n', '2022-03-17 15:22:23', '2022-03-17 15:22:23');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (59, 'HEV-IgM', '<p><strong><u>HEV-IgM</u></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HEV-IgM Hepatitis E virus&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;NEGATIVE&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt;COV:Negative</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &gt;COV:Positive</span></span></span></p>\r\n', '2022-03-17 15:23:13', '2022-03-17 15:23:13');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (60, 'HAV-IgG', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HAV-IgG</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HAV-IgG Ab to Hepatitis A Virus(serum by CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; Reactive(14.1) S/CO&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive:&lt; 1.0 S/CO</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Reactive:&gt;=1.0 S/CO</span></span></span></p>\r\n', '2022-03-17 15:26:50', '2022-03-17 15:26:50');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (61, 'HAV-IgM', '<p><strong><u><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">HAV-IgM</span></span></span></u></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HAV-IgM Ab to Hepatitis A Virus (serum by CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive(0.377) &nbsp;S/COratio&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; NonRactive:&lt;0.80 S/COratio</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Grayzone:0.80-1.2 S/COratio</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Reactive: &gt;1.2 S/COratio</span></span></span></p>\r\n', '2022-03-17 15:28:34', '2022-03-17 15:28:34');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (62, 'ANTI HBs', '<p><u><strong>ANTI HBs</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Anti HBs by CMIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mIU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Immune : &gt;=10 mIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Non Immune : &lt;10 mIU/mL</span></span></span></p>\r\n', '2022-03-17 15:31:04', '2022-03-17 15:31:04');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (63, 'ANTI HBc', '<p><u><strong>ANTI HBc</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Anti HBc by CMIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 13.2(Reactive)&nbsp;&nbsp; COI&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Reactive : &gt; 1.01 COI</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive : &lt;=1.00 COI</span></span></span></p>\r\n', '2022-03-17 15:31:59', '2022-03-17 15:31:59');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (64, 'CORTISOL', '<p><u><strong>CORTISOL</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Cortisol,Serum(8AM)by CMIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; ug/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; AM: 5 - 23 ug/dL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; PM: 3 - 16 ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; PM:Values are normally 50% of AM value</span></span></span></p>\r\n', '2022-03-17 15:33:32', '2022-03-17 15:33:32');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (65, 'PROLACTIN', '<p><strong><u>PROLACTIN</u></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Prolactin,serum by CMIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 2.5 - 18.2 ng/mL</span></span></span></p>\r\n', '2022-03-17 15:38:57', '2022-03-17 15:38:57');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (66, 'THYROID ANTIBODY REPORT', '<p><u><strong>THYROID ANTIBODY REPORT</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Microsomal ( TPO ) Antibody&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;IU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt; 60.0 IU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;Thyroglobulin Antibody ( ATA )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;IU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt; 60.0 IU/mL&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 15:41:20', '2022-03-17 15:41:20');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (67, 'VIT D3(25 HYDROXY)', '<p><u><strong>VIT D3(25 HYDROXY)</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">25 Hydroxy (OH) Vit D3,Serum by CMIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Deficiency : &lt; 10 ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Insufficiency : 10-30ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Sufficiency :30-100 ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Hypervitaminosis:&gt;100 ng/mL</span></span></span></p>\r\n', '2022-03-17 15:43:11', '2022-03-17 15:43:11');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (68, 'THYROID FUNCTION TEST (TFT) FEMALE', '<p><strong><u>THYROID FUNCTION TEST (TFT)</u></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">THYROID PANEL-1 (T3,T4,TSH) Serum, ECLIA</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T3 (Total)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;60 - 180 ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1st Trimester:81-190 ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2nd Trimester:100-260ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;3rd Trimester:100-260ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T4 (Total)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;ug/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;5.0&nbsp; -&nbsp; 11.5 ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">TSH (Ultrasensitive)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;uIU/mL &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0.4&nbsp; -&nbsp; 4.5 uIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1st&nbsp;Trimester:0.1-&nbsp;2.5uIU/mL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">2nd Trimester:0.2-3.0uIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;3rd Trimester:0.3-3.0uIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n', '2022-03-17 15:51:00', '2022-03-22 16:11:49');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (69, 'T3 (Total)Female', '<p><u><strong>T3 (Total)</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T3 (Total)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;60 - 180 ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1st Trimester:81-190 ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2nd Trimester:100-260ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;3rd Trimester:100-260ng/dL</span></span></span></p>\r\n', '2022-03-17 15:53:00', '2022-03-22 16:10:38');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (70, 'T4 (Total)Female', '<p><u><strong>T4 (Total)</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T4 (Total)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ug/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;5.0&nbsp; -&nbsp; 11.5 ug/dL</span></span></span></p>\r\n', '2022-03-17 15:56:03', '2022-03-22 16:11:00');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (71, ' TSH (FEMALE)', '<p><span style=\"font-size:16px;\"><u><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">TSH</span></span></strong></u></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">TSH (Ultrasensitive)(Serum,ECLIA)&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;uIU/mL &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0.4&nbsp; -&nbsp; 4.5 uIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1st Trimester:0.1-2.5uIU/mL&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2nd Trimester:0.2-3.0uIU/mL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;3rd Trimester:0.3-3.0uIU/mL</span></span></span></p>\r\n', '2022-03-17 15:57:00', '2022-03-22 16:12:15');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (72, 'E3', '<p><u><strong>E3</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">E3-Unconjugated Estriol serum by RIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Weeks&nbsp;&nbsp; Ref.Range</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Post LMP&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; (ng/ mL)</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 12&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.25-0.95&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 13&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.28-1.10&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 14&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.34-1.30&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 15&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.38-1.60&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 16&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.43-2.00&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;17&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.48-2.40&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;18&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.53-2.90&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;19&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.58-3.40&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;20&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.65-4.00&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;21&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.75-4.70&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;22-24&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.80-6.20&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;24-26&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1.10-7.60&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;26-28&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1.50-9.00&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;28-30&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2.30-10.3&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;30-32&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3.10-11.9&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 32-34&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 4.00-15.7&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 34-36&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 4.90-20.1&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 36-38&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 5.80-22.7&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 38-40&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 6.40-24.0&nbsp; ng/ mL</span></span></span></p>\r\n\r\n<p style=\"text-align:justify; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 40-42&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 6.50-24.4&nbsp; ng/ mL</span></span></span></p>\r\n', '2022-03-17 16:07:11', '2022-03-17 16:07:11');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (73, 'AFP', '<p><u><strong>AFP</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Alpha Feto Protein(AFP)(Serum ,CLIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;47.2ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Nonpregnant :0.0-10.0 ng/ mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;15weeks : 6.5-70.0 ng/ mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;16weeks : 7.0-82.9 ng/ mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;18weeks : 10.5-102 ng/ mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 19-23weeks : 26.5-165 ng/ mL</span></span></span></p>\r\n', '2022-03-17 16:08:21', '2022-03-17 16:09:48');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (74, 'ANA', '<p><u><strong>ANA</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Anti Nuclear Antibody Screening(Serum,EIA)&nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative (2.4)U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive:&gt;=10 U/mL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative:&lt;10 U/mL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 16:09:21', '2022-03-17 16:09:21');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (75, 'ANTI CCP', '<p><u><strong>ANTI CCP</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">CCP Antibody Cyclic Citrullinated Peptide(Serum by CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative &lt;5 U/mL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive &gt;= 5 U/mL </span></span></span></p>\r\n', '2022-03-17 16:11:36', '2022-03-17 16:11:36');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (76, 'LE Cell', '<p><u><strong>LE Cell</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Systemic Lupus Erythematosus Cells (LE Cell)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Not Detected</span></span></span></p>\r\n', '2022-03-17 16:13:00', '2022-03-17 16:33:35');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (77, 'HBeAg', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">HBeAg</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HBeAg-HepatitsBEnvelopeAntigen&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt; 1.0 COI: NON REACTIVE</span></span></span></p>\r\n', '2022-03-17 16:14:02', '2022-03-17 16:14:02');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (78, 'RA Factor     ', '<p><u><strong>RA Factor</strong></u>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">RA Factor&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; IU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt; 8 IU/mL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Slide Agglutination Method Dillution : 1:16 </span></span></span></strong></p>\r\n\r\n<p><strong>&nbsp; &nbsp; &nbsp;</strong></p>\r\n', '2022-03-17 16:15:20', '2022-03-22 16:28:42');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (79, 'A.S.O Titre    ', '<p><u><strong>A.S.O Titre</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;A.S.O Titre&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;IU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt; 200 IU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;Silde Agglutination Method Dillution : 1:2</span></span></span></p>\r\n\r\n<p>&nbsp; &nbsp;</p>\r\n', '2022-03-17 16:16:28', '2022-03-17 16:32:49');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (80, 'C.R.P (C - REACTIVE PROTEIN )  ', '<p><u><strong>C.R.P (C - REACTIVE PROTEIN </strong></u><strong><u>)</u> </strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">C.R.P (C - Reactive Protein )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative : &lt; 6 mg/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Slide Agglutination Method Dillution : 1:16&nbsp; </span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-17 16:17:53', '2022-03-17 16:17:53');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (81, 'CA-125', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">CA-125</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Cancer Antigen-125(CA-125)(Serum,ECLIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt;30.2 U/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 16:18:43', '2022-03-17 16:18:43');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (82, 'CERULOPLASMIN', '<p><u><strong>CERULOPLASMIN</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Ceruloplasmin&nbsp;(Serum,Nephelometry)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;20 - 60 mg/dL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 16:26:53', '2022-03-17 16:26:53');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (83, 'SERUM IgE', '<p><u><strong>SERUM IgE</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">IgE Total antibody,(Serum,ECLIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;&nbsp;IU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt; 100 IU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 16:28:29', '2022-03-17 16:28:29');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (84, 'SERUM lgG', '<p><u><strong>SERUM lgG</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">lgG Total&nbsp;(Serum,Nephelometry)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;700 -1600 mg/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 16:29:28', '2022-03-17 16:29:28');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (85, 'HbcAb-Total', '<p><u><strong>HbcAb-Total</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HbcAb-Total Ab to Hep-B Core Ag (Serum,CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive(0.21) &lt;1 Index&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp; Non Reactive:&lt;1 Index</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Reactive: &gt;= 1 Index</span></span></span></p>\r\n', '2022-03-17 16:32:11', '2022-03-17 16:32:11');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (86, 'HbcAb-lgM Ab', '<p><u><strong>HbcAb-lgM Ab</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HbcAb-lgM Ab Hepatitis B Core antigen(Serum,CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;S/CO&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive:&lt; 1.0 S/CO</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Reactive: &gt;= 1.0 S/CO</span></span></span></p>\r\n', '2022-03-17 16:38:06', '2022-03-17 16:38:06');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (87, 'INDIRECT COOMB\'S TEST(ICT)', '<p><u><strong>INDIRECT COOMB&#39;S TEST(ICT)</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Coomb&#39;s Test -lndirect(Serum,Gel Card Centrifugation)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 16:40:04', '2022-03-17 16:40:04');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (89, 'FREE T3 (FEMALE)', '<p><u><strong>FREE T3</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Free T3 (Serum,CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;pg/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1.4 - 4.2 pg/mL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Pregnacy : 2.3-8 pg/mL</span></span></span></strong></p>\r\n', '2022-03-17 16:41:18', '2022-03-22 16:34:50');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (90, 'FREE T4 (FEMALE)                                  ', '<p><u><strong>FREE T4</strong></u> &nbsp;&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Free T4(Serum,CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp; ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.8 - 1.8 ng/dL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; First Trimester:0.7 -2.0 ng/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Second Trimester:0.5 -1.6 ng/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Third Trimester:0.5-1.6 ng/dL&nbsp;&nbsp;</span></span></span></strong></p>\r\n', '2022-03-17 16:42:48', '2022-03-22 17:33:51');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (91, 'AMYLASE TEST   ', '<p><u><strong>AMYLASE TEST</strong></u> &nbsp;&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;Amylase Level&nbsp;(Serum CNPG3 Substrate)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 25-125 U/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 16:44:13', '2022-03-17 16:44:13');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (92, 'LIPASE TEST', '<p><u><strong>LIPASE TEST</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Lipase(Serum Neumann Colorimetric)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 10 - 160U/L</span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 16:45:30', '2022-03-17 16:45:30');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (93, 'D-DlMER Quantitative          ', '<p><u><strong>D-DlMER Quantitative</strong></u> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">D-DlMER Quantitative(Citrated plasma,lmmunoturbidimetry)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;163 ngFEU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.0 - 500 ngFEU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 16:46:41', '2022-03-17 16:47:02');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (94, 'PROTHROBIN TIME(PT INR)', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">PROTHROBIN TIME (PT) REPORT</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">TEST&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 11&nbsp; -&nbsp; 16 Seconds&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">CONTROL&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">PT(INR) Value&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Normal Population:0.8 - 1.2</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Standard Therapy:2 to 3</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;High dose Therapy: 3 to 4.5</span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-17 16:51:54', '2022-03-17 16:51:54');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (95, 'APTT', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">ACTIVATED PARTIAL THROMBOPLASTIN TIME (APTT) REPORT</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">TEST&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 30 - 40 Seconds</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">CONTROL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 16:53:40', '2022-03-17 16:53:40');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (96, 'HbA1C', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">GLYCATED HAEMOGLOBIN (HbA1C) REPORT</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HbA1C-Glycated Haemoglobin&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;Non diabetic:&lt;= 5.6 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Nephelometry)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Pre diabetic:5.7-6.4 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Diabetic : &gt;= 6.5 %&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Estimated Average Glucose(eAG) 122.63 mg/dL</span></span></span></p>\r\n', '2022-03-17 16:58:51', '2022-03-17 16:58:51');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (97, 'PERIPHERAL SMEAR', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">PERIPHERAL SMEAR REPORT</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">RBCs appear&nbsp; Normochromic and Normocytic. </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">WBC count normal.No atypical cells seen.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Platelets adequate&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; P 58%&nbsp;&nbsp; L 37 %&nbsp;&nbsp; E 05%&nbsp;&nbsp; M 00%&nbsp;&nbsp;&nbsp; B 00%</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">IMPRESSION: Peripheral smear appears within normal limit.</span></span></span></p>\r\n', '2022-03-17 17:00:16', '2022-03-17 17:00:16');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (98, 'PTH', '<p><u><strong>PTH REPORT</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">PTH-(lNTACT Molecule)(Serum,ECLIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; pg/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;15 -65 pg/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 17:01:38', '2022-03-17 17:01:38');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (99, 'URINE PROTEIN/CREATININE RATIO', '<p><u><strong>URINE PROTEIN/CREATININE RATIO</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">URINE CHEMISTRY</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">URINE PROTEIN/CREATININE RATIO: </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Protein,Urine by Pyrogallol red method&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine,Urine by Jaffe Method&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Protein - Creatinine Ratio&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt; 0-0.3</span></span></span></p>\r\n', '2022-03-17 17:03:41', '2022-03-17 17:03:41');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (100, 'INSULIN', '<p><u><strong>INSULIN</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Insulin(Random)*&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;uIU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Post glucose samples after:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Serum CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 30 minutes : 18 - 172 ulU/mL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 60 minutes : 12 - 134 ulU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 90 minutes : 12 - 107 ulU/mL&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 120 minutes: 12 - 82 ulU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 180 minutes: 2 -23 ulU/mL</span></span></span></p>\r\n', '2022-03-17 17:06:32', '2022-03-17 17:06:32');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (101, 'FERRITIN', '<p><u><strong>FERRITIN</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Ferritin&nbsp;(Serum,ECILA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;4.6 -204 ng/mL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 17:20:30', '2022-03-17 17:20:30');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (102, '24 HR URINE CREATININE CLEARANCE TEST', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">24 hr Urine Creatinine Clearance Test</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine Clearance Test</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.9- 1.3 ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Serum,jaffes Kinetic)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine,Urine by jaffe Method&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg%</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(24 Hrs Urine jaffes Kinetic)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Urine volume in 24 hours&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ml</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine,24hrs Urine(Calculated)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;58 mg/ 24 hrs&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;1000 - 2000</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(jaffes Kinetic)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Body surface area&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Sq m</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine Clearence (Calculated)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;44 ml/min/1.73 sq m&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 76-120</span></span></span></p>\r\n', '2022-03-17 17:26:09', '2022-03-17 17:44:13');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (103, 'AMH', '<p><u><strong>AMH</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">AMH Mullerian Inhibiting Substance(Serum,ECLlA)&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.9 -9.5 ng/mL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 17:28:07', '2022-03-17 17:28:07');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (104, 'HbsAg( CMIA)', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">HbsAg</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HbsAg,CMlA*&nbsp;(Serum,CMlA)&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Reactive(4640.39)S/CO&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;Non Reactive:&lt;1.0S/CO</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Reactive: &gt;=1.0S/CO</span></span></span></p>\r\n', '2022-03-17 17:30:05', '2022-03-22 16:54:48');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (105, 'CA- 15.3                      ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>CA- 15.3</strong></u></span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">CA- 15.3&nbsp;(Serum,CMlA) &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 00 - 31.3 U/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><strong>&nbsp;</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 17:31:05', '2022-03-17 17:31:05');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (106, 'VITAMIN B12', '<p><u><strong>VITAMIN B12</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;Vitamin B12 level(Serum,ECLIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; pg/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;197 - 771 pg/mL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 17:31:57', '2022-03-17 17:31:57');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (107, 'CMV IgG', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">CMV IgG</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">CMV IgG,Serum by CMIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; aU/ml&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Non Reactive : &lt;6.0 aU/ml</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Reactive&nbsp; : &gt;=6.0 aU/ml&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 22:14:59', '2022-03-17 22:14:59');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (108, 'SPUTUM AFB', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">SPUTUM AFB</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><u><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">SPUTUM EXAMINATION REPORT</span></span></span></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(1). Specimen Type&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Sputum&nbsp; (1st day)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp; Ziehl-Neelsen&#39;s Stain(Z.N.Stain)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Acid Fast Bacilli Not seen.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp; Result&nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(2). Specimen Type&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Sputum (2nd day)&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp; Ziehl-Neelsen&#39;s Stain(Z.N.Stain)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Acid Fast Bacilli Not seen.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp; Result&nbsp; &nbsp; &nbsp; &nbsp;&nbsp;:&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(3). Specimen Type&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Sputum (3rd day)&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp; Ziehl-Neelsen&#39;s Stain(Z.N.Stain)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Acid Fast Bacilli Not seen.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp; Result&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n', '2022-03-17 22:18:29', '2022-03-17 22:18:29');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (109, 'FOLIC ACID               ', '<p><u><strong>Folic Acid</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Folic Acid&nbsp;(Serum,ECLIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;1.2 - 7.1 ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 22:20:17', '2022-03-17 22:20:17');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (110, 'Urea Nitrogen(BUN)', '<p><u><strong>Urea Nitrogen(BUN)</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">BUN- Blood Urea Nitrogen(Serum,Urease)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp;8.9 - 20.6 mg/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-17 22:21:32', '2022-03-17 22:21:32');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (111, 'MANTOUX TEST', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">MANTOUX TEST REPORT</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">PPD 10TU GIVEN ON THE LEFT FORE ARM&nbsp; AT 12:30 PM</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">INDURATION&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2 X 2 mm</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">ERYTHEMA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;:&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><u><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">RESULTS &amp; INTERPRETATION</span></span></span></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">POSITIVE&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; INDURATION MEASURING 10mm OR MORE.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">DOUBTFUL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; INDURATION MEASURING BETWEEN 5mm AND 9mm.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">NEGATIVE&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; INDURATION OF LESS THAN 5mm.&nbsp;</span></span></span></p>\r\n', '2022-03-17 22:24:16', '2022-03-17 22:24:16');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (112, 'LDL CHOLESTEROL          ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>LDL CHOLESTEROL TEST</strong></u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">LDL CHOLESTEROL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Optimal: &lt; 100 mg/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Near Optimal/above Potimal:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;100-129 mg/ dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Borderline High:130-159 mg/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;High: 160-189 mg/dL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Very High: &gt;=189 mg/ dL</span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 22:26:13', '2022-03-17 22:26:13');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (113, 'Toxoplasma IgG', '<p><u><strong>Toxoplasma IgG</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Toxoplasma IgG(Serum by CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; IU/ml&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;Non Reactive:&lt;1.6 IU/ml</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Grayzone:1.6-3.0 IU/ml</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Reactive:&gt;=3.0 IU/ml</span></span></span></p>\r\n', '2022-03-17 22:28:01', '2022-03-17 22:28:01');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (114, 'Toxoplasma IgM', '<p><u><strong>Toxoplasma IgM</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Toxoplasma IgM(Serum by CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Index&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive: &lt; 0.5&nbsp;&nbsp; Index&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Grayzone:0.5-0.59 Index&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Reactive:&gt;=0.6 Index &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n', '2022-03-17 22:30:17', '2022-03-17 22:30:17');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (115, 'Anti Sperm Antibody (ASAB)', '<p><u><strong>Anti Sperm Antibody (ASAB) TEST</strong></u></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Anti Sperm Antibody (ASAB)(Serum,ElA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative:&lt;=60 U/mL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">Positive:&gt; 60U/mL&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-17 22:33:40', '2022-03-17 22:33:40');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (116, 'Albumin/Creatinine Ratio Urine          ', '<p><u><strong>Albumin/Creatinine Ratio Urine</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Albumin/Creatinine Ratio Urine&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Urine)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Albumin/Microalbumin in Urine&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(immuno Turbidiometry)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine Urine&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&gt; 50 mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Jaffes kinetic)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Albumin/creatinine Ratio&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;0.3&gt; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(calculated)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n', '2022-03-17 22:36:01', '2022-03-17 22:36:01');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (117, '125 VITAMIN D', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">125 VITAMIN D</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Vitamin D-125 Dihydroxy,serum by CLIA&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp;&nbsp;pg/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;19.9&nbsp; -&nbsp; 79.3 pg/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Please note&nbsp;change&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><font face=\"Calibri, sans-serif\"><span style=\"font-size: 14.6667px;\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></font><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">in ref.range and method.</span></span></span></p>\r\n', '2022-03-22 10:33:41', '2022-03-22 10:33:41');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (118, 'S.Acid Phosphatase(Total)', '<p><u><strong>S.Acid Phosphatase(Total)</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">S.Acid Phosphatase(Total)</span></span><span style=\"tab-stops:346.85pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Enzymatic</span></span></span><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.3 &nbsp;-&nbsp; 9.2 U/L </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"tab-stops:346.85pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></span></p>\r\n', '2022-03-22 10:34:45', '2022-03-22 10:34:45');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (119, '24 HRS URINE PROTEINS', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">PROTEINS URINE 24Hrs</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-family: Calibri, sans-serif; font-size: 11pt;\">Urine Chemistry :</span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Protein Urine 24 hrs,Colourimetry&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/24hrs.&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; upto 150mg/24hrs.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Protein,Urine&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine,Urine by Drychemistry&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Protein-Creatinine Ratio&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Normal:&lt;0.3:1</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Calcium Creatinine Ratio&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt; 0.3:1</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 10:47:24', '2022-03-22 11:58:11');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (120, 'ANTI DS  DNA', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>DNA(Double Strand)Antibody</strong></u></span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">DNA(Double Strand)Antibody(Serum,ELISA)&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;IU/ml&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative:&lt; 25 IU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive:&gt; 25 IU/mL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp; </span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 10:58:40', '2022-03-22 10:58:40');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (121, ' ACE', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">ACE (Angiotensin Converting Enzyme)</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">ACE (Angiotensin Converting Enzyme)(Serum,Kinetic Assay)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt; 40 U/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:00:39', '2022-03-22 11:00:39');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (122, ' DHEA', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">DHEA TEST</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-left:250px; text-indent:-186.75pt; margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">DHEA &ndash; Dehydroepiandrostenedione(Serum,ELISA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1.2 - 6.3 ng/mL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Please note change in&nbsp;reference range</span></span></span></p>\r\n', '2022-03-22 11:03:21', '2022-03-22 11:03:21');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (123, ' Iron', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">Iron Test</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Iron(Serum,Ferrozine Method)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Ug/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;33-193 Ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:04:21', '2022-03-22 11:04:21');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (124, 'TIBC', '<p><u><strong>TIBC TEST</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">TIBC&nbsp;&nbsp;(Calculated)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Ug/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;250-450 Ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Ferritin&nbsp;(SERUM,CMIA) &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 13 -150 ng/mL </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Transferin Saturation(Calculated)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;14 - 50 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 11:05:53', '2022-03-22 11:08:00');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (125, 'lron, lCPMS**           ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>lron,Serum, lCPMS**</strong></u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">lron,Serum, lCPMS**(Serum,lCPMS)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ug/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 55 - 120 ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Reference : Rodushkin l. et al.,Pure &amp; Applied Chem.,2001,5,pp 51-66.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-22 11:09:11', '2022-03-22 11:09:11');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (126, 'GAMMA GT                ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>Gamma GT (GGTP)</strong></u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Gamma GT (GGTP)(Serum,IFCC method)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;9 -36 U/L </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:11:26', '2022-03-22 11:11:26');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (127, 'Anti Nuclear Antibody, IFA', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Anti Nuclear Antibody, IFA</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Anti Nuclear Antibody , lFA&nbsp;&nbsp;(Serum,lmmunofluorescence)&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Result&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Pattern&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; -&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;-</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Grade&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; -&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; -</span></span></span></p>\r\n', '2022-03-22 11:13:32', '2022-03-22 11:13:32');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (128, 'AFP-Alpha Feto Protein             ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>AFP-Alpha Feto Protein</strong></u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">AFP-Alpha Feto ProteinSerum,ECLlA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt; 7 ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-22 11:14:36', '2022-03-22 11:14:36');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (129, 'C3(Complement-3)', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">C3(Complement-3)</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">C3(Complement-3),Serum by Nephelometry&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;90&nbsp; -&nbsp; 180 mg/dL</span></span></span></p>\r\n', '2022-03-22 11:15:43', '2022-03-22 11:15:43');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (130, 'C4(Complement-4)', '<p><u><strong>C4(Complement-4)</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">C4(Complement-4),Serum by Nephelometry&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 10&nbsp;-&nbsp;40 mg/dL</span></span></span></p>\r\n', '2022-03-22 11:16:38', '2022-03-22 11:16:38');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (131, 'Homogentisic Acid   ', '<p><u><strong>Homogentisic Acid Test</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Homogentisic Acid(Alkaptanuria)(Urine)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:24:06', '2022-03-22 11:24:06');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (132, 'Osmolality Urine*             ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>Osmolality Urine*</strong></u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Osmolality Urine*(Urine,Freezing Point Depression)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;mOsm/kg&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 50 -1400 mosm/kg</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:25:01', '2022-03-22 11:25:01');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (133, 'Valproic Acid                  ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>Valproic Acid</strong></u>&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Valproic Acid(Serum,CLIA)&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;ug/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Therapeutic range:50-100 ug/ml</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-22 11:25:45', '2022-03-22 11:25:45');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (134, 'S.Homocysteine', '<p><u><strong>S.Homocysteine</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Homocysteine(Serum,CMlA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;umol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 5.46 -16.2 umol/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:26:32', '2022-03-22 11:26:32');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (135, 'C-Peptide                   ', '<p style=\"margin-bottom:14px\"><u><strong>C-Peptide</strong></u> &nbsp; &nbsp; &nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">C-Peptide(Serum CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;pMol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Fasting:259 -1728 pMol/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Stimulated: 500 -3000pMol/L</span></span></span></p>\r\n', '2022-03-22 11:27:39', '2022-03-22 11:27:39');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (136, 'CRP-C Reactive protein        ', '<p><u><strong>CRP-C Reactive protein</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">CRP-C Reactive protein&nbsp;(Serum,Nephelometry)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;&nbsp;6 mg/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:28:58', '2022-03-22 16:50:30');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (137, 'ASO titre        ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>ASO titre&nbsp;</strong></u>&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">ASO titre Quantitative(Serum Nephelometry)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;IU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt; 200 IU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-22 11:30:11', '2022-03-22 11:30:11');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (138, 'URINE CULTURE & SENSITIVITY', '<p><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">MICROBIOLOGY REPORT</span></span></span></strong></u></p>\r\n\r\n<p><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">URINE CULTURE &amp; SENSITIVITY</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Collection Date :&nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Reporting Date :&nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Specimen Type&nbsp; :&nbsp;&nbsp; &nbsp;Urine</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">ORGANISM GROWTH&nbsp; : Culture shows no growth after 48 hours of incubation at 37 C.</span></span></span></p>\r\n', '2022-03-22 11:32:18', '2022-03-22 11:32:18');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (139, ' SODIUM', '<p><u><strong>SODIUM</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">SODIUM&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 135 - 148 mmol/L&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:33:52', '2022-03-22 11:33:52');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (140, 'POTASSIUM', '<p><u><strong>POTASSIUM TEST</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">POTASSIUM&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3.5 - 5.1 mmol/L</span></span></span></p>\r\n', '2022-03-22 11:34:35', '2022-03-22 11:34:35');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (141, 'Serotonin', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">Serotonin</span></span></span></strong></u></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Serotonin , Serum&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;40 - 400 ng/mL</span></span></span></p>\r\n', '2022-03-22 11:35:15', '2022-03-22 11:35:15');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (142, 'CA-19.9                       ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>CA-19.9</strong></u>&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">CA-19.9(Serum,ECLIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; U/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&lt;&nbsp;27 U/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-22 11:35:58', '2022-03-22 11:35:58');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (143, 'BLOOD CULTURE & SENSITIVITY ', '<p style=\"margin-bottom:14px\"><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">MICROBIOLOGY REPORT</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">BLOOD CULTURE &amp; SENSITIVITY </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Collection Date&nbsp; &nbsp;:&nbsp; &nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Collection Time&nbsp; &nbsp;:&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Reporting Date&nbsp; &nbsp; :&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">ORGANISM GROWTH : Blood culture shows no Pathogenic Organism seen after 7 days of incubation at 37 C.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">CULTURE&amp;SENSITIVITY-BLOOD</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Microscopy Result&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;Sample Date :</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Report Date :</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Specimen&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; :&nbsp;&nbsp; Blood&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Gram Stain&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; :&nbsp;&nbsp; No micro-Organisms seen.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <u>Final Report</u></span></span></b></span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Organism(s)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; :&nbsp;&nbsp;&nbsp; No growth after one week of incubation.</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:37:33', '2022-03-22 12:28:22');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (144, 'SEMEN ANALYSIS', '<p><u><strong>SEMEN ANALYSIS REPORT</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">PHYSICAL CHARACTERISTICS</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Volume&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;ml&nbsp;( 2&nbsp; -&nbsp; 5 ml )</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Colour&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Reaction&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Consistency&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Liquefaction Time&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">MICROSCOPICAL EXAMINATION</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Total Sperm Count&nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; &nbsp;Millions/ml&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">MOTILITY GRADING</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">a).(Rapid Progressive)&nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; 40 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">b).(Slow Progressive)&nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; 30 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">c).(Non-progressive)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; 20 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">d).(Immobile)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;10 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">MORPHOLOGICAL GRADING</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Normal&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; 40 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Abnormal&nbsp; &nbsp; &nbsp; :&nbsp;&nbsp; 60 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Pus Cells&nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; 1-2 /hpf</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">RBC&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp; &nbsp;Nil /hpf</span></span></span></p>\r\n', '2022-03-22 11:43:46', '2022-03-22 11:43:46');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (145, 'HLA B27', '<p><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HLA B27</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HLA B27(Human Luecocyte Antigen B27)&nbsp;(EDTA Whole Blood)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HLA B27 Detection&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Remark&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp;:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Result Confirmed by Molecularmethod</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Method&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp; : &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Flow Cytometry&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 11:59:57', '2022-03-22 11:59:57');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (146, '17 Hydroxy Progesterone ', '<p style=\"margin-bottom:14px\"><u><strong>17 Hydroxy Progesterone&nbsp;</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">17 Hydroxy Progesterone (serum by RIA Method)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Adult Female&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Follicular Phase 0.15 - 1.1ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Luteal phase 0.7 - 5.0 ng/ mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Pregnancy&nbsp; 2.5&nbsp; -&nbsp; 18.9 ng/ mL</span></span></span></p>\r\n', '2022-03-22 12:02:53', '2022-03-22 12:02:53');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (147, 'Dengue (NS1)', '<p><u><strong>Dengue (NS1)</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Dengue (NS1) Antigen(Serum,ElA)&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; PanBio Units&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Negative : &lt;9PanBio Units</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Equivocal:9-11PanBio Units</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Positive:&gt;11PanBio Units</span></span></span></p>\r\n', '2022-03-22 12:04:16', '2022-03-22 12:04:16');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (148, 'ACTH', '<p><u><strong>ACTH</strong></u></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">ACTH-Adreno Corticotropic Hormone(Plasma)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; pg/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.0 to 46pg/mL&nbsp; </span></span></span></p>\r\n', '2022-03-22 12:05:22', '2022-03-22 12:05:22');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (149, 'AMMONIA', '<p><u><strong>AMMONIA</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Ammonia(Heparin Whole Blood,Enzymatic)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;umol/L&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;30 - 65 umol/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 12:06:56', '2022-03-22 12:06:56');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (150, 'SEMEN CULTURE & SENSITIVITY', '<p><u><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">MICROBIOLOGY REPORT</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">SEMEN CULTURE &amp; SENSITIVITY</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Collection Date&nbsp; &nbsp; &nbsp;:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Reporting Date&nbsp; &nbsp; &nbsp;:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Specimen Type&nbsp; &nbsp; &nbsp;:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">ORGANISM GROWTH&nbsp; : Culture shows no growth after 48 hours of incubation at 37 C.</span></span></span></p>\r\n', '2022-03-22 12:08:56', '2022-03-22 12:08:56');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (151, 'TPHA', '<p><u><strong>TPHA</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">TPHA(Serum)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">lnterpretation:&nbsp; &nbsp;&nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Treponema Pallidium Haemagglutination (TPHA)</span></span></span></p>\r\n', '2022-03-22 12:09:50', '2022-03-22 12:09:50');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (152, 'HIV 1&11', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">HIV 1&amp;11</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HIV 1&amp;11,CMIA*&nbsp;(Serum,CMlA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; COl&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive: &lt; 1.0 COl</span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Reactive&nbsp;&nbsp;&nbsp; : &gt;=1.0 COl</span></span></span></p>\r\n', '2022-03-22 12:11:44', '2022-03-22 12:11:44');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (153, 'Hepatitis B Surface Antibody', '<p><u><strong>Hepatitis B Surface Antibody</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Hepatitis B Surface Antibody(Anti HBs) &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; mlU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive(Below</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(Serum,CMlA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Protection):&lt;10mlU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Reactive(Protective):&gt;=10mlU/mL</span></span></span></p>\r\n', '2022-03-22 12:14:03', '2022-03-22 12:14:55');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (154, 'MPO- ANCA', '<p><u><strong>MPO- ANCA</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">MPO- ANCA(p-ANCA)*(Serum,ELISA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; RU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative:&lt; 20 RU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Positive:&gt;=20 RU/mL</span></span></span></p>\r\n', '2022-03-22 12:29:56', '2022-03-22 12:29:56');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (155, 'PR3 -ANCA                         ', '<p><u><strong>PR3 -ANCA</strong></u><strong> </strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">PR3 -ANCA (c -ANCA)*(Serum,EIA)&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; RU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative:&lt;20 RU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Positive:&gt;=20 RU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">ADDITIONAL TEST : PLA2R(phospholipase A2 receptor)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Antibody : A novel marker for IMN(ldiopathic Membranous Nephropathy)</span></span></span></p>\r\n\r\n<p><strong>&nbsp;</strong> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</p>\r\n', '2022-03-22 12:31:17', '2022-03-22 12:31:17');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (156, 'GFR', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">GFR</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">GFR With Creatinine(Serum)</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Creatinine(jaffes kinetic)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0.8 1.3 mg/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">eGFR(CKD-EPl)(jaffe)&nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ml/min/1.73 sqm&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Normal OR high:&gt;=90</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Mild or decrease:60 -89</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Mild to moderate decrease:45-59</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Mild to severe decrease:30-44</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;severe decrease:15-29</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Kidney failure:&lt;15</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Note:Equation is notvalid for patients below 18 years of age Caculated</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; by lDMS-TraceableCKD-EPl Creatinine equation.</span></span></span></p>\r\n', '2022-03-22 12:34:43', '2022-03-22 12:34:43');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (157, 'HsCRP', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">HsCRP</span></span></span></strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HsCRP-High Sensitivity CRP*(Serum,Nephelometry)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt;= 3 mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 12:35:54', '2022-03-22 12:35:54');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (158, 'Lipoprotein(a)*               ', '<p><u><strong>Lipoprotein(a)*</strong></u> &nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Lipoprotein(a)*(Serum,Nephelometry)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;0 -30 mg/dl</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 12:36:39', '2022-03-22 12:36:39');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (159, 'Bicarbonate', '<p><u><strong>Bicarbonate</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Bicarbonate&nbsp;(Serum,Enzymatic)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;16 - 25 mmol/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n', '2022-03-22 12:37:26', '2022-03-22 12:37:26');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (160, ' G6PD', '<p><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;</span></span></span></strong><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">G6PD</span></span></span></strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">G6PD-quantitative,&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Not Deficiennt(7.1)Units/gm of HB&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 6.97-20.5 Units/gm of HB</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">blood by kinetic method*</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">(EDTA Whole Blood,Enzymatic)</span></span></span></p>\r\n', '2022-03-22 12:38:23', '2022-03-22 12:38:23');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (161, 'Protein S Activity*            ', '<p><u><strong>Protein S Activity*</strong></u><strong> &nbsp;</strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Protein S Activity*&nbsp;(Citrated plasma)&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Non Pregnant: 55 -123 %</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;First Trimester: 57 -95%</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Second Trimester:42 68%</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Third Trimester: 16 42%</span></span></span></p>\r\n', '2022-03-22 12:39:55', '2022-03-22 12:39:55');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (162, 'Protein C Activity*           ', '<p><u><strong>Protein C Activity*</strong></u>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Protein C Activity*(Citrated plasma)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Pregnant: 70 -130%</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; First Trimester:78 -121%</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Second Trimester:83 -133%</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Third Trimester:67 -135%</span></span></span></p>\r\n', '2022-03-22 12:41:44', '2022-03-22 12:41:44');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (163, 'Beta-2-Microglobulin*                ', '<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\"><u><strong>Beta-2-Microglobulin*</strong></u><strong>&nbsp;</strong>&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Beta-2-Microglobulin*(Serum,ELFA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.670-2.143 mg/L</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-22 12:43:19', '2022-03-22 12:43:19');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (164, 'MICRO FILARIA ', '<p><u><strong>MICRO FILARIA<span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">(MF)</span></span></span></strong></u>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Filaria Antigen detection(EDTA Whole Blood)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative</span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Filaria Antibody detection(Serum)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative</span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Method&nbsp; &nbsp; :&nbsp; &nbsp; &nbsp;Immunochromatography</span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 12:45:52', '2022-03-22 12:45:52');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (165, 'HSV-1&2', '<p><u><strong>HSV-1&amp;2</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HSV-1&amp;2 (Herpes Simplex&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; lndex&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative:&lt; 0.8 lndex</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Virus-1&amp;2)lgG antibody*(Serum,CLlA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Equivocal:0.8-1.1 lndex</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Positive:&gt;=1.1 lndex</span></span></span></p>\r\n', '2022-03-22 12:47:31', '2022-03-22 12:47:31');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (166, 'HSV-1&2 IgM', '<p><u><strong><span style=\"font-size:11.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">HSV-1&amp;2 IgM</span></span></span></strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">HSV-1&amp;2 IgM antibody*(Serum,ElA)&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Ratio&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative:&lt;0.8 Ratio&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Borderline:0.8-1.1 Ratio&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\"><strong>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Positive:&gt;1.1 Ratio&nbsp;&nbsp;&nbsp;&nbsp;</strong>&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n', '2022-03-22 12:49:36', '2022-03-22 12:49:36');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (167, '24 HRS Urine  Albumin Quantitative ', '<p><u><strong>24 HRS Urine &nbsp;Albumin Quantitative</strong></u><strong>&nbsp;</strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Albumin QuantitativeUrine 24H(24 Hrs URINE)</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Albumin/Microalbumin in Urine(lmmunoturbidimetry)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp;&nbsp;mg/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt;= 30 mg/L</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Urine Volume in 24 hours&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;ml</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Albumin/Microalbumin urea&nbsp; by&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; mg/24hrs&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Normal: &lt; 150 mg/24hrs&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">lmmunoturbidimetry</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;(lmmunoturbidimetry)</span></span></span></strong></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 13:06:38', '2022-03-22 13:08:45');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (168, ' EPTOIN', '<p><strong>&nbsp;</strong><u><strong>EPTOIN</strong></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Phenytoin(Eptoin)(Serum,CMIA)&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ug/mL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Therapeutic range : 10-20 ugmL </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Toxic range : &gt; 20 ug/mL</span></span></span></strong></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 13:08:04', '2022-03-22 13:08:21');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (169, 'LIVER FUNCTION TEST           ', '<p><u><strong>LIVER FUNCTION TEST</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Serum Bilirubin - Total&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; mg/dl&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Upto 1.2 mg/dl&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Serum Bilirubin -&nbsp; Direct&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;<b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">mg/dl&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Upto 0.2 mg/dl&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></b></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">SGOT / AST&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M Upto 40 F Upto 31 U/L&nbsp; </span></span></span></b></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;SGPT / ALT&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; M Upto 40 F Upto 31 U/L&nbsp; </span></span></span></b></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Serum Alkaline Phosphatase&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; U/L&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">80 - 290 U/L&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b></p>\r\n\r\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Children 245 - 770 U/L&nbsp;&nbsp; </span></span></span></b></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Total Protein </span></span></span></b>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; gm %&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">6.0 - 8.0 gm %&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Albumin&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; gm %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3.7 - 5.3 gm %&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Globulin&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;gm %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 2.3 - 3.6 gm %&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">A/G Ratio&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1.0 -2.3&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 14:56:36', '2022-03-22 15:15:23');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (170, 'Serum Bilirubin - Total       ', '<p><u><strong>Serum Bilirubin - Total</strong></u><strong> &nbsp;</strong></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Serum Bilirubin - Total&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Upto 1.2 mg/dL</span></span></span></b></p>\r\n', '2022-03-22 15:16:48', '2022-03-22 15:16:48');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (171, 'Serum Bilirubin -  Direct     ', '<p><span style=\"font-size:16px;\"><u><strong>Serum Bilirubin - &nbsp;Direct</strong></u></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Serum Bilirubin -&nbsp; Direct&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Upto 0.2 mg/dL &nbsp;&nbsp;</span></span></span></b></p>\r\n', '2022-03-22 15:18:33', '2022-03-22 15:18:33');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (172, 'SGOT / AST                    ', '<p><span style=\"font-size:16px;\"><u><strong>SGOT / AST&nbsp;</strong></u></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">SGOT / AST&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; M Upto 40 F Upto 31 U/L&nbsp; </span></span></span></b></p>\r\n', '2022-03-22 15:20:06', '2022-03-22 15:20:06');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (173, 'SGPT / ALT                    ', '<p><span style=\"font-size:16px;\"><u><strong>SGPT / ALT</strong></u></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\"><span style=\"color:#000000;\">SGPT / ALT</span>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; M Upto 40 F Upto 31 U/L&nbsp; &nbsp; &nbsp;</span></span></span></b></p>\r\n', '2022-03-22 15:21:58', '2022-03-22 15:21:58');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (174, 'Serum Alkaline Phosphatase    ', '<p><u><strong>Serum Alkaline Phosphatase</strong></u></p>\r\n\r\n<p><strong>Serum Alkaline Phosphatase&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</strong><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;U/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 80 - 290 U/L&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span></span></b><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Children 245 - 770 U/L</span></span></b></span></span></span><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\"> &nbsp; &nbsp; &nbsp;&nbsp;</span></span></span></b></p>\r\n', '2022-03-22 15:25:29', '2022-03-22 15:25:29');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (175, 'Total Protein                 ', '<p><span style=\"font-size:16px;\"><u><strong>Total Protein</strong></u></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Total Protein&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;<b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;gm %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;6.0 - 8.0 gm %</span></span></span></b></p>\r\n', '2022-03-22 15:26:39', '2022-03-22 15:26:39');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (176, 'S.Albumin', '<p><span style=\"font-size:16px;\"><u><strong>S.Albumin</strong></u></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Albumin&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;gm %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3.7 - 5.3 gm %&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b></p>\r\n', '2022-03-22 15:28:02', '2022-03-22 17:12:45');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (177, 'Globulin', '<p><span style=\"font-size:16px;\"><u><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Globulin</span></span></strong></u></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Globulin&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;gm %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2.3 - 3.6 gm %&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b></p>\r\n', '2022-03-22 15:29:09', '2022-03-22 15:29:09');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (178, 'COMPLETE  BLOOD  COUNT        ', '<p><span style=\"font-size:16px;\"><b><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\"><u>COMPLETE&nbsp; BLOOD&nbsp; COUNT</u></span></span></b></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;Hb&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; gm%&nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M:12.5-18 F:11.5-16gm%</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">WBC:-</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Total Count&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Cells/cmm&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;4,000 -11,000 Cells/cmm</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;Differential Count:-</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Polymorphs&nbsp;</span></span></b></span></span></span>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;45 - 74 %</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Lymphocytes&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;16 - 45 %</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Eosinophils&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;0 -&nbsp; 7 %</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Monocytes&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;4 - 10 %</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Basophils&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;0 -&nbsp; 2 %</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">RBC&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;millions/cmm&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M: 5.5-6.5 F:4.0-5.5milli</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Platelet Count&nbsp;</span></span></b></span></span></span>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;lakhs/cmm&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1.5 - 4.0 lakhs/cmm</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">PCV&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M : 40-54 % F: 36-47 %&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">MCV&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;fl&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;82.0 - 96.0 fl&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">MCH&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;pg&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;27.0 - 34.0 pg&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">MCHC&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;g/dl&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;32.0 - 38.0 g/dl&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">ESR&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; mm/hr&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M:0-9F:0-15 mm/hr</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 15:40:29', '2022-03-22 15:40:29');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (179, 'Hb  ', '<p><span style=\"font-size:16px;\"><u><strong>Hb</strong></u></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Hb</span></span></span></b><strong>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</strong><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">gm%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; M:12.5-18 F:11.5-16gm%&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span></span></b></p>\r\n\r\n<p>&nbsp; &nbsp;</p>\r\n', '2022-03-22 15:42:54', '2022-03-22 15:42:54');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (180, 'WBC', '<p><span style=\"font-size:16px;\"><u><strong>WBC</strong></u></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Total Count&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Cells/cmm&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;4,000 -11,000 Cells/cmm&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 15:44:30', '2022-03-22 15:44:30');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (181, 'Differential Count', '<p><span style=\"font-size:16px;\"><u><strong>Differential Count</strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Polymorphs&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 45 - 74 %</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Lymphocytes&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 16 - 45 %&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Eosinophils&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;0 -&nbsp; 7 %</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Monocytes&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 4 - 10 %</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Basophils&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0 -&nbsp; 2 %&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 15:49:05', '2022-03-22 15:49:05');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (182, 'RBC', '<p><span style=\"font-size:16px;\"><u><strong>RBC</strong></u></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">RBC&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; millions/cmm&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M: 5.5-6.5 F:4.0-5.5milli</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 15:51:27', '2022-03-22 15:51:27');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (183, 'Platelet Count                ', '<p><span style=\"font-size:16px;\"><u><strong>Platelet Count&nbsp;</strong></u></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;Platelet Count&nbsp;&nbsp;</span></span></b></span></span></span>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;<span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">lakhs/cmm&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;1.5 - 4.0 lakhs/cmm&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><br />\r\n&nbsp;</p>\r\n', '2022-03-22 15:52:53', '2022-03-22 15:52:53');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (184, ' PCV                           ', '<p><span style=\"font-size:16px;\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;</span></span><strong><u><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">PCV</span></span></u><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;</span></span></strong></span><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></b></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;PCV&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;M : 40-54 % F: 36-47 %&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;\r\n<p>&nbsp;</p>\r\n</p>\r\n', '2022-03-22 15:54:34', '2022-03-22 15:54:34');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (185, 'ESR', '<p><span style=\"font-size:16px;\"><u><strong>ESR</strong></u></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">ESR&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;mm/hr&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M:0-9F:0-15 mm/hr</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 15:56:01', '2022-03-22 15:56:01');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (186, 'LIPID PROFILE                 ', '<p><span style=\"font-size:14px;\"><u><strong>LIPID PROFILE</strong></u><strong>&nbsp;</strong></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Total Cholesterol&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b><span style=\"font-size:14px;\"><strong>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</strong></span><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;mg/dL&nbsp;</span></span></b></span></span></span><span style=\"font-size:14px;\"><strong>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</strong></span><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Adults:140-200mg/dL&nbsp;</span></span></b></span></span></span><span style=\"font-size:14px;\"><strong>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</strong></span></p>\r\n\r\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;<span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">children :&lt;150 mg/dL&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Triglycerides&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></b><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;40-165&nbsp; mg/dL&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">HDL - Cholesterol&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span></span></b><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M:30-55 F: 45-65 mg/dL&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">LDL - Cholesterol&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span></span></b><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Upto 150&nbsp; mg/dL&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">VLDL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Upto 40&nbsp; mg/dL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span></span></b></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><br />\r\n&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:02:53', '2022-03-22 16:02:53');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (187, 'Total Cholesterol             ', '<p><span style=\"font-size:16px;\"><strong><u><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Total Cholesterol</span></span></u></strong></span><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;&nbsp;&nbsp;</span></span></span></b></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Total Cholesterol&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Adults:140-200mg/dL&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">children :&lt;150 mg/dL&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b></p>\r\n', '2022-03-22 16:05:18', '2022-03-22 16:05:18');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (188, 'Triglycerides', '<p><span style=\"font-size:16px;\"><u><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Triglycerides</span></span></strong></u></span></p>\r\n\r\n<p><span style=\"font-size:16px;\"><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Triglycerides&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span></strong></span><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;40-165&nbsp; mg/dL&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:06:35', '2022-03-22 16:06:35');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (189, 'HDL - Cholesterol             ', '<p><span style=\"font-size:16px;\"><u><strong>HDL - Cholesterol</strong></u><strong> </strong></span>&nbsp; &nbsp;</p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">HDL - Cholesterol&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M:30-55 F: 45-65 mg/dL&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:10:19', '2022-03-22 16:10:19');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (190, 'LDL - Cholesterol             ', '<p><span style=\"font-size:16px;\"><u><strong>LDL - Cholesterol</strong></u></span> &nbsp; &nbsp;</p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">LDL- Cholesterol&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Upto 150&nbsp; mg/dL&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n', '2022-03-22 16:14:04', '2022-03-22 16:14:04');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (191, 'RENAL FUNCTION TEST           ', '<p><span style=\"font-size:16px;\"><u><strong>RENAL FUNCTION TEST</strong></u></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Blood Urea&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; mg%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;14 - 40&nbsp;&nbsp; mg%&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">S.Creatinine&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; M :- 0.6 - 1.2 mg%&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;F :- 0.5 - 1.1 mg%&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">S.Uric Acid&nbsp;</span></span></b></span></span></span>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">mg%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; M :- 3.5 - 7.2 mg%&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;F : - 2.6 - 6.0 mg%&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:16px;\"><strong>&nbsp;</strong></span> &nbsp; &nbsp;</p>\r\n', '2022-03-22 16:16:22', '2022-03-22 16:18:24');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (192, 'Blood Urea   ', '<p><span style=\"font-size:16px;\"><u><strong>Blood Urea</strong></u></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Blood Urea&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;mg%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;14 - 40&nbsp;&nbsp; mg%&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:19:50', '2022-03-22 16:19:50');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (193, ' S.Creatinine                  ', '<p><strong>&nbsp;</strong><span style=\"font-size:16px;\"><u><strong>S.Creatinine</strong></u></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;S.Creatinine&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;mg%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M :- 0.6 - 1.2 mg%&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;F :- 0.5 - 1.1 mg%</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:21:24', '2022-03-22 16:21:24');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (194, 'S.Uric Acid                   ', '<p><span style=\"font-size:16px;\"><u><strong>S.Uric Acid</strong></u></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;S.Uric Acid&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;M :- 3.5 - 7.2 mg%&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;F : - 2.6 - 6.0 mg%&nbsp;&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:23:25', '2022-03-22 16:23:25');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (195, 'Blood Sugar (Random)          ', '<p><span style=\"font-size:16px;\"><u><strong>Blood Sugar</strong></u></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Blood Sugar (Random)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/dl&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Upto 150 mg/dl&nbsp;&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Corr .Urine Sugar&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Nil&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:31:16', '2022-03-22 16:31:16');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (196, 'Blood Sugar(Fasting)', '<p><strong><u><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">BLOOD SUGAR</span></span></span></u></strong></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Blood Sugar(Fasting)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mg/dl&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;70-110 mg/dl&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Corr .Urine Sugar&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Nil&nbsp;</span></span></b></span></span></span></p>\r\n', '2022-03-22 16:32:57', '2022-03-22 16:32:57');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (197, 'Blood Sugar ( PPBS )          ', '<p><u><strong><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">BLOOD&nbsp; SUGAR</span></span></span></strong></u><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;</span></span></span></b></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Blood Sugar ( PPBS )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; mg/dl&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Up to 140 mg/dl&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Corr. Urine Sugar&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Green</span></span></b></span></span></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b></p>\r\n', '2022-03-22 16:34:25', '2022-03-22 16:34:25');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (198, 'BLOOD GROUPING                ', '<p><u><strong>BLOOD GROUPING</strong></u>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:14px;\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;BLOOD GROUPING&nbsp; &nbsp;</span></b></span></span></span><span style=\"font-size:16px;\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&quot;B&quot;&nbsp;&nbsp;&nbsp;&nbsp;</span></b></span></span><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp; &nbsp; &nbsp;</span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:14px;\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;Rh TYPING</span></b></span></span></span><span style=\"font-size:16px;\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;&nbsp;&nbsp;&nbsp;</span></b></span></span><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Positive&nbsp;&nbsp;</span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:38:00', '2022-03-22 16:38:00');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (199, 'GLUCOSE TOLERANCE TEST', '<p><u><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">GLUCOSE TOLERANCE TEST</span></span></span></b></u></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;After 75gm Glucose :-&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp; &nbsp; &nbsp; &nbsp;2&nbsp; Hour&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 110 mg/dl&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp; &nbsp; &nbsp; &nbsp;Corr. Urine Sugar&nbsp;&nbsp;</span></span></b></span></span></span>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Nil&nbsp;&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span>&nbsp;</p>\r\n', '2022-03-22 16:39:34', '2022-03-22 16:39:34');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (200, 'GCT ', '<p><span style=\"font-size:16px;\"><u><strong>GCT&nbsp;</strong></u></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;Blood Sugar&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; mg/dl&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Up to 140 mg/dl&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;(1 hr after 50gm glucose given)</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;Corr.Urine Sugar&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Nil&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:41:32', '2022-03-22 16:41:32');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (201, 'BLOOD  ROUTINE(R/E)', '<p><span style=\"font-size:16px;\"><u><strong>BLOOD &nbsp;ROUTINE(R/E)</strong></u></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\"><span style=\"font-size:14px;\">EXAMINATION OF BLOOD&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></span></b></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><b>&nbsp;Hb&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;gm%&nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M:12.5-18 F:11.5-16gm%</b></p>\r\n\r\n<p><b>WBC:-</b></p>\r\n\r\n<p><b>Total Count&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Cells/cmm&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;4,000 -11,000 Cells/cmm</b></p>\r\n\r\n<p><b>&nbsp;Differential Count:-</b></p>\r\n\r\n<p><b>Polymorphs&nbsp;</b>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<b>%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;45 - 74 %</b></p>\r\n\r\n<p><b>Lymphocytes&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;16 - 45 %</b></p>\r\n\r\n<p><b>Eosinophils&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;%&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;0 -&nbsp; 7 %</b></p>\r\n\r\n<p><b>Monocytes&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;4 - 10 %</b></p>\r\n\r\n<p><b>Basophils&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; %&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;0 -&nbsp; 2 %</b></p>\r\n\r\n<p><b>ESR&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; mm/hr&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;M:0-9F:0-15 mm/hr</b></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b></p>\r\n', '2022-03-22 16:48:36', '2022-03-22 16:48:36');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (202, 'SEROLOGY', '<p><span style=\"font-size:16px;\"><u><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">SEROLOGY</span></span></strong></u></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">HBs Ag&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">HIV 1 &amp; 2&nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">VDRL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Non Reactive&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">HCV&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 16:53:25', '2022-03-22 16:53:25');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (203, 'HBs Ag(Card)                    ', '<p><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\"><span style=\"font-size:18px;\"><strong><u>HBs Ag</u></strong>&nbsp;</span>&nbsp;</span></span></span><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;&nbsp;</span></span></span></b></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">HBs Ag&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b></p>\r\n', '2022-03-22 16:56:03', '2022-03-22 16:56:03');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (204, 'HIV 1 & 2                     ', '<p><span style=\"font-size:16px;\"><u><strong>HIV 1 &amp; 2 </strong></u></span>&nbsp; &nbsp;</p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">HIV 1 &amp; 2&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Negative&nbsp;&nbsp; </span></span></span></b></p>\r\n', '2022-03-22 16:57:05', '2022-03-22 16:57:05');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (205, 'VDRL', '<p><span style=\"font-size:18px;\"><u><b><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">VDRL</span></span></b></u></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">VDRL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Non Reactive&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></b></p>\r\n', '2022-03-22 16:58:05', '2022-03-22 16:58:05');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (206, 'HCV ', '<p><span style=\"font-size:16px;\"><u><strong>HCV</strong></u><strong>&nbsp;</strong></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">HCV&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative&nbsp;&nbsp; </span></span></span></b></p>\r\n', '2022-03-22 16:59:24', '2022-03-22 16:59:24');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (207, 'Bleeding Time, Clotting Time', '<p><u><strong><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Bleeding Time, Clotting Time</span></span></span></strong></u></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;Bleeding Time&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1&#39; 15&quot;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1 - 3&nbsp; minutes&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Clotting Time&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2&#39; 50&quot;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;3- 7&nbsp; minutes&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 17:00:53', '2022-03-22 17:00:53');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (208, 'ABSOLUTE EOSINOPHIL COUNT (AEC)', '<p style=\"margin-bottom:14px\"><u><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">ABSOLUTE EOSINOPHIL COUNT (AEC)</span></span></span></b></span></span></span></u></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">ABOLUTE EOSINOPHIL COUNT&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Cells/cmm&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;40-440 Cells/ cmm&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 17:02:07', '2022-03-22 17:02:07');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (209, 'A.S.O  Titre                  ', '<p><span style=\"font-size:16px;\"><u><strong>A.S.O &nbsp;Titre</strong></u></span> &nbsp; &nbsp;</p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;A.S.O&nbsp; Titre&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;<span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">lU/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt; 200 lU/mL&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n', '2022-03-22 17:03:17', '2022-03-22 17:03:17');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (210, 'Urine Pregnancy', '<p><span style=\"font-size:16px;\"><u><strong>Urine Pregnancy Test</strong></u></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Urine Pregnancy Test&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Negative&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 17:04:23', '2022-03-22 17:04:23');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (211, 'Urine B J Protein             ', '<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\"><span style=\"font-size:16px;\"><u>Urine B J Protein&nbsp;</u></span>&nbsp;&nbsp;</span></span></span></b></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;Urine B J Protein&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span></span></b><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Negative&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n', '2022-03-22 17:05:23', '2022-03-22 17:05:48');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (212, ' ELECTROPHORESIS', '<p><span style=\"font-size:16px;\"><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">&nbsp;</span></span></strong><u><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">ELECTROPHORESIS</span></span></strong></u></span></p>\r\n', '2022-03-22 17:06:28', '2022-03-22 17:06:28');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (213, 'ANA PROFILE', '<p><span style=\"font-size:16px;\"><u><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">ANA PROFILE</span></span></strong></u></span></p>\r\n', '2022-03-22 17:06:48', '2022-03-22 17:06:48');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (214, 'SERUM ELECTROLYTES          ', '<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\"><u>SERUM ELECTROLYTES</u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></b></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Sodium&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span></span></b><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;135 -&nbsp; 155&nbsp; mmol / L&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><font face=\"Times New Roman, serif\"><span style=\"font-size: 16px;\"><b>Potassium&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</b></span></font><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;3.5 -&nbsp; 5.5&nbsp; mmol /&nbsp; L&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;Bicarbonate&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</span></span></span></b><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 21 - 32 mmol/L&nbsp;&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><b><span style=\"font-size:12.0pt\"><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">&nbsp;Chloride&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span></b><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 98 - 107 mmol/L&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n', '2022-03-22 17:10:26', '2022-03-22 17:10:26');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (215, 'Chloride', '<p><span style=\"font-size:16px;\"><u><b><span style=\"line-height:115%\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Chloride</span></span></b></u></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Chloride&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;mmol/L&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;98 - 107 mmol/L&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 17:11:37', '2022-03-22 17:11:37');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (216, 'Urine Albumin', '<p><span style=\"font-size:16px;\"><u><strong>Urine Albumin</strong></u></span></p>\r\n\r\n<p><strong>Urine Albumin&nbsp; &nbsp; :&nbsp; &nbsp; Nill</strong></p>\r\n', '2022-03-22 17:16:06', '2022-03-22 17:16:06');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (217, 'Urine Sugar', '<p><span style=\"font-size:16px;\"><strong><u>Urine Sugar</u>&nbsp;</strong></span>&nbsp;</p>\r\n\r\n<p><strong>Urine Albumin&nbsp; &nbsp; &nbsp; :&nbsp; &nbsp; Nil</strong></p>\r\n', '2022-03-22 17:17:17', '2022-03-22 17:17:17');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (218, 'MICROSCOPICAL EXAMINATION (Deposit)', '<p><span style=\"font-size:16px;\"><u><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">MICROSCOPICAL EXAMINATION (Deposit)</span></span></strong></u></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Amorphous Urates&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Epithelial Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;0-2/HPF</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Pus Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;1-2/HPF</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">R B C s&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Casts&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Crystals Uric Acid&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Bacteria&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Yeast Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n', '2022-03-22 17:23:10', '2022-03-22 17:23:10');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (219, 'Urine Bile                    ', '<p><span style=\"font-size:16px;\"><u><strong>Urine Bile</strong></u></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Bile Pigment&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Negative&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n\r\n<p><span style=\"font-size:11pt\"><span style=\"line-height:normal\"><span style=\"font-family:Calibri,sans-serif\"><b><span style=\"font-size:12.0pt\"><span style=\"font-family:&quot;Times New Roman&quot;,serif\">Bile salt&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Negative&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></b></span></span></span></p>\r\n', '2022-03-22 17:24:56', '2022-03-22 17:24:56');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (220, 'THYROID FUNCTION TEST (MALE)', '<p style=\"margin-bottom:14px\"><span style=\"font-size:16px;\"><u><strong><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">THYROID FUNCTION TEST</span></span></strong></u></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T3 (CLIA METHOD )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Euthyroid : 60 - 180 ng/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Hypothyroid : Below 60 ng/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Hyperthyroid : Above 180 ng/dL </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T4 ( CLIA METHOD )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ug/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Euthyroid : 5 - 11.5 ug/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hypothyroid : Below 5.0 ug/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hyperthyroid : Above 11.5 ug/dL&nbsp; </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T.S.H(CLIA- ULTRASENSITIVE)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;uIU/ml&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Euthyroid:0.4-4.0 uIU/ml</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hypothyroid : Above 4.0uIU/ml</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hyperthyroid : Below 0.4 uIU/ml</span></span></span></strong></p>\r\n', '2022-03-22 17:27:31', '2022-03-22 17:27:31');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (221, 'T3(MALE)', '<p><span style=\"font-size:16px;\"><u><strong>T3</strong></u></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T3 (ECLIA METHOD )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Euthyroid : 60 - 180 ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hypothyroid : Below 60 ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Hyperthyroid : Above 180 ng/dL </span></span></span></p>\r\n', '2022-03-22 17:30:23', '2022-03-22 17:30:23');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (222, 'T4 (MALE)', '<p><u><strong><span style=\"font-size:16px;\">T4</span></strong></u><strong><span style=\"font-size:16px;\">&nbsp;</span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T4 ( ECLIA METHOD )&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ug/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Euthyroid : 5 - 11.5 ug/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hypothyroid : Below 5.0 ug/dL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\"><strong>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hyperthyroid : Above 11.5 ug/dL</strong>&nbsp; </span></span></span></p>\r\n', '2022-03-22 17:37:22', '2022-03-22 17:37:22');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (223, 'TSH(MALE)', '<p><span style=\"font-size:16px;\"><u><strong><span style=\"line-height:115%\"><span style=\"font-family:&quot;Calibri&quot;,sans-serif\">T.S.H(MALE)</span></span></strong></u></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T.S.H(ECLIA- ULTRASENSITIVE)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; uIU/ mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Euthyroid:0.4-4.0 uIU/mL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; Hypothyroid : Above 4.0uIU/ mL</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Hyperthyroid : Below 0.4 uIU/ mL</span></span></span></strong></p>\r\n', '2022-03-22 17:38:45', '2022-03-22 17:38:45');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (224, 'FREE T4(MALE)', '<p><span style=\"font-size:14px;\"><u><strong>FREE T4</strong></u></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\"><strong>Free T4(Serum,CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 0.8 - 1.8 ng/ dL&nbsp;&nbsp;</strong>&nbsp; </span></span></span></p>\r\n', '2022-03-22 17:40:48', '2022-03-22 17:40:48');
INSERT INTO `lab_report_template` (`id`, `name`, `template`, `created_at`, `updated_at`) VALUES (225, 'FREE T3 (MALE)', '<p><u><strong>FREE T3</strong></u></p>\r\n\r\n<p><strong>Free T3 (Serum,CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;pg/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1.4 - 4.2 pg/mL</strong></p>\r\n\r\n<p><strong>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</strong></p>\r\n', '2022-03-22 17:55:38', '2022-03-22 17:55:38');


#
# TABLE STRUCTURE FOR: lab_test
#

DROP TABLE IF EXISTS `lab_test`;

CREATE TABLE `lab_test` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `name` varchar(155) NOT NULL,
  `patient_price` decimal(18,2) NOT NULL DEFAULT '0.00',
  `production_cost` decimal(18,2) NOT NULL DEFAULT '0.00',
  `test_code` varchar(20) NOT NULL,
  `date` date NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=435 DEFAULT CHARSET=utf8;

INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (4, 16, 'OPG', '600.00', '500.00', 'OPG', '2022-03-14', 1, '2022-03-14 13:56:20', '2022-03-28 15:22:11');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (6, 10, 'CONSUMERABLE ITEMS', '50.00', '35.00', 'CONS', '2022-03-14', 1, '2022-03-14 16:00:17', '2022-03-14 16:00:17');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (8, 9, 'LUMBO SACRAL SPINE AP-LAT', '300.00', '250.00', 'LSS', '2022-03-14', 1, '2022-03-14 17:07:27', '2022-03-14 17:07:27');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (9, 9, 'CERVICAL SPINE AP-LAT', '300.00', '250.00', 'CS', '2022-03-14', 1, '2022-03-14 17:07:56', '2022-03-14 17:07:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (10, 9, 'THORACIC SPINE AP-LAT', '300.00', '250.00', 'TS', '2022-03-14', 1, '2022-03-14 17:08:30', '2022-03-14 17:08:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (11, 9, 'PELVIS AP', '250.00', '200.00', 'PEL', '2022-03-14', 1, '2022-03-14 17:09:01', '2022-03-14 17:09:01');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (12, 9, 'CHEST PA', '250.00', '200.00', 'CXR', '2022-03-14', 1, '2022-03-14 17:09:53', '2022-03-14 17:09:53');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (13, 9, 'CHEST PA WITH REPORT', '280.00', '200.00', 'CXR', '2022-03-14', 1, '2022-03-14 17:13:41', '2022-03-14 17:13:41');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (14, 9, 'CHEST AP', '300.00', '250.00', 'CXR', '2022-03-14', 1, '2022-03-14 17:14:06', '2022-03-14 17:14:06');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (15, 9, 'KUB', '250.00', '200.00', 'KUB', '2022-03-14', 1, '2022-03-14 17:17:13', '2022-03-14 17:17:13');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (16, 9, 'KNEE RIGHT AP-LAT', '300.00', '250.00', 'KNEE', '2022-03-14', 1, '2022-03-14 17:17:47', '2022-03-14 17:18:22');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (17, 9, 'KNEE LEFT AP-LAT', '300.00', '250.00', 'KNEE', '2022-03-14', 1, '2022-03-14 17:18:48', '2022-03-14 17:18:48');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (18, 9, 'KNEE AP-LAT-SUNRISE', '350.00', '300.00', 'KNEE', '2022-03-14', 1, '2022-03-14 17:19:24', '2022-03-14 17:19:24');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (19, 17, 'MAMMOGRAM SINGLE', '1250.00', '1000.00', 'MMG', '2022-03-15', 1, '2022-03-15 13:04:13', '2022-03-29 09:43:00');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (20, 17, 'MAMMOGRAM BOTH', '2500.00', '2200.00', 'MMG', '2022-03-15', 1, '2022-03-15 13:05:13', '2022-03-29 09:43:15');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (23, 16, 'CEPH', '250.00', '100.00', 'CEPH', '2022-03-15', 1, '2022-03-15 15:49:30', '2022-03-28 15:22:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (24, 24, '5D/4D DOPPLER', '3000.00', '2000.00', '5D', '2022-03-15', 1, '2022-03-15 16:27:25', '2022-03-29 10:06:55');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (30, 14, 'ECG WITH REPORT', '250.00', '100.00', 'ECG REPORT', '2022-03-16', 1, '2022-03-16 13:27:11', '2022-03-16 13:27:11');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (31, 23, 'DOPPLER NECK', '1300.00', '500.00', 'DOPP.', '2022-03-16', 1, '2022-03-16 13:29:32', '2022-03-29 09:36:48');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (33, 7, 'USG NB/NT', '1000.00', '500.00', 'NB/NT', '2022-03-16', 1, '2022-03-16 13:31:59', '2022-03-16 13:31:59');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (34, 7, 'USG ABDOMEN PELVIS(F)', '950.00', '400.00', 'ABD/PEL(F)', '2022-03-16', 1, '2022-03-16 13:33:42', '2022-03-16 13:37:38');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (36, 7, 'USG ABDOMEM(M)', '850.00', '400.00', 'ABD(M)', '2022-03-16', 1, '2022-03-16 13:37:05', '2022-03-16 13:37:05');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (37, 9, 'OPG...', '650.00', '300.00', 'MEDICITY', '2022-03-16', 1, '2022-03-16 13:41:18', '2022-03-16 13:41:18');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (40, 15, 'BMD', '2500.00', '1000.00', 'BMD MEDICITY', '2022-03-16', 1, '2022-03-16 13:46:45', '2022-03-16 13:46:45');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (41, 8, 'CT BRAIN AND LIMITED PNS', '3850.00', '2500.00', 'CT', '2022-03-16', 1, '2022-03-16 13:47:42', '2022-03-17 12:38:40');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (42, 10, 'CONSUMERABLE 5D', '100.00', '50.00', 'CONS', '2022-03-16', 1, '2022-03-16 17:15:32', '2022-03-16 17:15:32');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (43, 9, 'SKULL AP-LAT', '350.00', '300.00', 'SKL', '2022-03-17', 1, '2022-03-17 13:54:55', '2022-03-17 13:54:55');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (44, 9, 'PNS', '250.00', '200.00', 'PNS', '2022-03-17', 1, '2022-03-17 13:55:23', '2022-03-17 13:55:23');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (45, 9, 'MASTOID', '250.00', '200.00', 'MAST', '2022-03-17', 1, '2022-03-17 13:55:58', '2022-03-17 13:55:58');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (46, 9, 'NASAL BONE LAT', '250.00', '200.00', 'NSL B', '2022-03-17', 1, '2022-03-17 13:56:57', '2022-03-17 13:56:57');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (47, 9, 'ADENOID', '250.00', '200.00', 'ADN', '2022-03-17', 1, '2022-03-17 13:57:32', '2022-03-17 13:57:32');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (48, 9, 'NECK AP-LAT', '300.00', '250.00', 'NECK', '2022-03-17', 1, '2022-03-17 13:58:14', '2022-03-17 13:58:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (49, 9, 'NECK LAT', '250.00', '200.00', 'NE', '2022-03-17', 1, '2022-03-17 13:59:06', '2022-03-17 13:59:06');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (50, 9, 'SHOULDER AP', '250.00', '200.00', 'SHLD', '2022-03-17', 1, '2022-03-17 13:59:37', '2022-03-17 13:59:37');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (51, 9, 'SHOULDER AP-LAT', '300.00', '250.00', 'SHLD', '2022-03-17', 1, '2022-03-17 14:00:15', '2022-03-17 14:00:15');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (52, 9, 'SHOULDER AP-AXIAL', '250.00', '200.00', 'SHLD', '2022-03-17', 1, '2022-03-17 14:00:44', '2022-03-17 14:00:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (53, 9, 'CLAVICLE AP', '250.00', '200.00', 'CVCL', '2022-03-17', 1, '2022-03-17 14:06:27', '2022-03-17 14:06:27');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (54, 7, 'USG ABDOMEN PELVIS UNM', '850.00', '500.00', 'UNM', '2022-03-17', 1, '2022-03-17 15:27:52', '2022-03-17 15:27:52');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (56, 11, 'BLOOD SUGAR FASTING', '50.00', '30.00', 'FB', '2022-03-24', 1, '2022-03-24 09:34:00', '2022-03-24 09:34:00');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (57, 11, 'BLOOD SUGAR PPS', '50.00', '30.00', 'PPS', '2022-03-24', 1, '2022-03-24 09:34:58', '2022-03-24 09:34:58');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (58, 11, 'BLOOD SUGAR RANDAM', '50.00', '30.00', 'RBS', '2022-03-24', 1, '2022-03-24 09:37:17', '2022-03-24 09:37:17');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (59, 11, 'BLOOD RE', '200.00', '150.00', 'BRE', '2022-03-24', 1, '2022-03-24 09:37:51', '2022-03-24 09:37:51');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (60, 11, 'COMPLET BLOOD COUNT', '250.00', '200.00', 'CBC', '2022-03-24', 1, '2022-03-24 09:40:05', '2022-03-24 09:40:05');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (61, 11, 'HEMO GLOBIN', '40.00', '30.00', 'HB', '2022-03-24', 1, '2022-03-24 09:41:17', '2022-03-24 09:41:17');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (62, 11, 'ESR', '30.00', '20.00', 'ESR', '2022-03-24', 1, '2022-03-24 09:45:07', '2022-03-24 09:45:07');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (63, 11, 'LIVER FUNCTION TEST', '400.00', '350.00', 'LFT', '2022-03-24', 1, '2022-03-24 09:45:57', '2022-03-24 09:45:57');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (64, 11, 'THYROID FUNCTION TEST', '450.00', '400.00', 'TFT', '2022-03-24', 1, '2022-03-24 09:46:38', '2022-03-24 09:46:38');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (65, 11, 'RENAL FUNCTION TEST', '400.00', '350.00', 'RFT', '2022-03-24', 1, '2022-03-24 09:48:03', '2022-03-24 09:48:03');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (66, 11, 'LIPID PROFILE', '400.00', '350.00', 'LIPID', '2022-03-24', 1, '2022-03-24 09:51:44', '2022-03-24 09:51:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (67, 11, 'HBA1C', '500.00', '300.00', 'HBA1C', '2022-03-24', 1, '2022-03-24 09:52:20', '2022-03-24 09:52:20');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (68, 11, 'THYROID ANTIBODIES', '1000.00', '800.00', 'THYROID PROFILE', '2022-03-24', 1, '2022-03-24 09:53:28', '2022-03-24 09:53:28');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (69, 11, 'UREA', '130.00', '50.00', 'UREA', '2022-03-24', 1, '2022-03-24 09:53:56', '2022-03-24 09:53:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (70, 11, 'CREATINE', '130.00', '100.00', 'CREATINE', '2022-03-24', 1, '2022-03-24 09:54:16', '2022-03-24 09:54:16');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (71, 11, 'URIC ACID', '130.00', '100.00', 'UA', '2022-03-24', 1, '2022-03-24 09:54:43', '2022-03-24 09:54:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (72, 11, 'PLATELET COUNT', '130.00', '100.00', 'PLATELET', '2022-03-24', 1, '2022-03-24 09:55:30', '2022-03-24 09:55:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (73, 11, 'PSA', '500.00', '300.00', 'PSA', '2022-03-24', 1, '2022-03-24 09:55:47', '2022-03-24 09:55:47');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (75, 11, 'URINE RE', '100.00', '50.00', 'URINE ROUTINE', '2022-03-24', 1, '2022-03-24 09:57:14', '2022-03-24 09:57:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (76, 11, 'URINE CULTURE', '160.00', '100.00', 'UC', '2022-03-24', 1, '2022-03-24 09:57:35', '2022-03-24 09:57:35');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (77, 11, 'SGPT', '130.00', '100.00', 'SGPT', '2022-03-24', 1, '2022-03-24 09:57:57', '2022-03-24 09:57:57');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (78, 11, 'SGOT', '130.00', '100.00', 'SGOT', '2022-03-24', 1, '2022-03-24 09:58:15', '2022-03-24 09:58:15');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (79, 11, 'CA 125', '990.00', '500.00', 'CA', '2022-03-24', 1, '2022-03-24 09:58:56', '2022-03-24 09:58:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (80, 11, 'BETA 2 GLYCOPROTEIN', '1300.00', '1000.00', 'BETA', '2022-03-24', 1, '2022-03-24 10:00:28', '2022-03-24 10:00:28');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (81, 11, 'BICARBONATE', '130.00', '120.00', 'BICARBONATE', '2022-03-24', 1, '2022-03-24 10:02:13', '2022-03-24 10:02:13');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (82, 11, 'BILLRUBINE(T)', '130.00', '120.00', 'BILLRUBINE TOTAL', '2022-03-24', 1, '2022-03-24 10:04:27', '2022-03-24 10:04:27');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (83, 11, 'BILLRUBIN(D)', '130.00', '120.00', 'BLIIRUBIN DIRECT', '2022-03-24', 1, '2022-03-24 10:05:27', '2022-03-24 10:05:27');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (84, 11, 'AMH', '1700.00', '1000.00', 'AMH', '2022-03-24', 1, '2022-03-24 10:35:28', '2022-03-24 10:35:28');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (85, 11, 'BJ PROTEIN', '300.00', '250.00', 'BJP', '2022-03-24', 1, '2022-03-24 10:40:17', '2022-03-24 10:40:17');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (86, 11, 'BLOOD GROUP &RH TYPE', '100.00', '90.00', 'BLOOD GROUP', '2022-03-24', 1, '2022-03-24 10:42:03', '2022-03-24 10:42:03');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (87, 11, 'PREGNANCY TEST', '150.00', '100.00', 'PREGNANCY TEST', '2022-03-24', 1, '2022-03-24 10:44:33', '2022-03-24 10:44:33');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (88, 11, 'PROGESTERONE', '500.00', '450.00', 'PROGESTRONE', '2022-03-24', 1, '2022-03-24 10:45:48', '2022-03-24 10:45:48');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (89, 11, 'PROJESTRONE 17 OH', '1400.00', '1300.00', 'P 17 OH', '2022-03-24', 1, '2022-03-24 10:47:37', '2022-03-24 10:47:37');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (90, 11, 'PROLACTIN', '500.00', '450.00', 'PROLACTIN', '2022-03-24', 1, '2022-03-24 10:48:24', '2022-03-24 10:48:24');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (91, 11, 'PROSTATE SPECIFIC ANTIGEN (PSA)', '500.00', '400.00', 'PSA', '2022-03-24', 1, '2022-03-24 10:50:00', '2022-03-24 10:50:00');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (92, 11, 'TSH', '200.00', '150.00', 'TSH', '2022-03-24', 1, '2022-03-24 11:18:18', '2022-03-24 11:18:18');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (93, 11, 'PROSTATIC ACID PROSTATE (PAP)', '200.00', '150.00', 'PAP', '2022-03-24', 1, '2022-03-24 11:19:56', '2022-03-24 11:19:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (94, 11, 'PAPPA', '900.00', '800.00', 'PAPPA', '2022-03-24', 1, '2022-03-24 11:26:00', '2022-03-24 11:26:00');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (95, 11, 'DS DNA', '1100.00', '1000.00', 'DS DNA', '2022-03-24', 1, '2022-03-24 12:16:34', '2022-03-24 12:16:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (96, 11, 'ELECTROLYTE', '450.00', '400.00', 'ELECTROLYTE', '2022-03-24', 1, '2022-03-24 12:23:12', '2022-03-24 12:23:12');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (97, 11, 'ELECTROPHORSIS', '600.00', '450.00', 'ELEPH', '2022-03-24', 1, '2022-03-24 12:25:20', '2022-03-24 12:25:20');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (98, 11, 'ERYTHROPROTIEN(EPO)', '2000.00', '1900.00', 'EPO', '2022-03-24', 1, '2022-03-24 12:27:52', '2022-03-24 12:27:52');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (99, 11, 'ESTRADIOL', '500.00', '400.00', 'ESTRADIOL', '2022-03-24', 1, '2022-03-24 12:30:10', '2022-03-24 12:30:10');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (100, 11, 'FREE PSA', '1200.00', '1100.00', 'F PSA', '2022-03-24', 1, '2022-03-24 12:31:43', '2022-03-24 12:31:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (101, 11, 'FREE T3', '180.00', '150.00', 'FREE T3', '2022-03-24', 1, '2022-03-24 12:32:21', '2022-03-24 12:32:21');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (102, 11, 'FREE T4', '180.00', '170.00', 'FREE T4', '2022-03-24', 1, '2022-03-24 12:32:54', '2022-03-24 12:32:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (103, 11, 'FREE TESTISTRONE', '1800.00', '1700.00', 'F TEST', '2022-03-24', 1, '2022-03-24 12:34:19', '2022-03-24 12:34:19');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (104, 11, 'FSH', '500.00', '400.00', 'FSH', '2022-03-24', 1, '2022-03-24 12:37:40', '2022-03-24 12:37:40');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (105, 11, 'FTA ABS', '2350.00', '1250.00', 'FTA', '2022-03-24', 1, '2022-03-24 12:39:20', '2022-03-24 12:39:20');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (106, 11, 'FTA ABS 1GG', '1250.00', '1200.00', 'FA IGG', '2022-03-24', 1, '2022-03-24 12:40:30', '2022-03-24 12:40:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (107, 11, 'CULTURE FUNGUS', '130.00', '120.00', 'FUNGUS', '2022-03-24', 1, '2022-03-24 12:41:22', '2022-03-24 12:41:22');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (108, 11, 'G6PD', '550.00', '500.00', 'G6PD', '2022-03-24', 1, '2022-03-24 12:42:14', '2022-03-24 12:42:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (109, 11, 'GAMA GT', '350.00', '300.00', 'GGT', '2022-03-24', 1, '2022-03-24 12:43:40', '2022-03-24 12:43:40');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (110, 11, 'GCT', '200.00', '150.00', 'GCT', '2022-03-24', 1, '2022-03-24 12:44:17', '2022-03-24 12:44:17');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (111, 11, 'GLOBULIN', '160.00', '150.00', 'GLOBULIN', '2022-03-24', 1, '2022-03-24 12:46:34', '2022-03-24 12:46:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (112, 11, 'FTI (FREE THYROXINE INDEX)', '300.00', '200.00', 'FTI', '2022-03-24', 1, '2022-03-24 12:50:17', '2022-03-24 12:50:17');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (113, 11, 'GLUCOESTOLERENT TEST(EXTENDED)', '300.00', '200.00', 'GT', '2022-03-24', 1, '2022-03-24 12:55:34', '2022-03-24 12:55:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (114, 11, 'GLYCATE HB (HBA1C)', '500.00', '400.00', 'GHB', '2022-03-24', 1, '2022-03-24 14:11:50', '2022-03-24 14:11:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (115, 11, 'GRAMSTAIN', '60.00', '40.00', 'GRAMSTAIN', '2022-03-24', 1, '2022-03-24 14:13:06', '2022-03-24 14:13:06');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (116, 11, 'GRAM STAINING FOR GONOCOCCI', '80.00', '70.00', 'G S G', '2022-03-24', 1, '2022-03-24 14:14:50', '2022-03-24 14:14:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (117, 11, 'GROUP RH TYPING', '100.00', '90.00', 'GROUP', '2022-03-24', 1, '2022-03-24 14:16:28', '2022-03-24 14:16:28');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (118, 11, 'GROWTH HORMONE', '600.00', '500.00', 'GH', '2022-03-24', 1, '2022-03-24 14:17:09', '2022-03-24 14:17:09');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (119, 11, 'GTT', '300.00', '200.00', 'GTT', '2022-03-24', 1, '2022-03-24 14:17:39', '2022-03-24 14:17:39');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (120, 11, 'HPYLORI IGG', '1450.00', '1400.00', 'H IGG', '2022-03-24', 1, '2022-03-24 14:18:54', '2022-03-24 14:18:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (121, 11, 'HPYLORI IGM', '950.00', '900.00', 'H IGM', '2022-03-24', 1, '2022-03-24 14:20:30', '2022-03-24 14:20:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (122, 11, 'HAEMOGLOBIN ELECTROPHO', '800.00', '700.00', 'HB ELECTROPHORISIS', '2022-03-24', 1, '2022-03-24 14:35:14', '2022-03-24 14:35:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (123, 11, 'HAEMOGRAM', '150.00', '100.00', 'HG', '2022-03-24', 1, '2022-03-24 14:46:44', '2022-03-24 14:46:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (124, 11, 'HANGING DROP (VIBRIO CHOLERAC)', '200.00', '190.00', 'HD', '2022-03-24', 1, '2022-03-24 14:49:15', '2022-03-24 14:49:15');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (125, 11, 'HAV 1GM', '700.00', '600.00', 'HAV', '2022-03-24', 1, '2022-03-24 14:50:16', '2022-03-24 14:50:16');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (126, 11, 'HB  ANTIBODY(ANTI HBEG)', '500.00', '400.00', 'HB ANTIBODY', '2022-03-24', 1, '2022-03-24 14:53:43', '2022-03-24 14:53:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (127, 11, 'HBA2', '350.00', '300.00', 'HBA2', '2022-03-24', 1, '2022-03-24 14:56:13', '2022-03-24 14:56:13');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (128, 11, 'HBC 1GM', '600.00', '500.00', 'HBC', '2022-03-24', 1, '2022-03-24 15:01:42', '2022-03-24 15:01:42');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (129, 11, 'HB ELECTRO PHORASIS', '1200.00', '1000.00', 'HB E', '2022-03-24', 1, '2022-03-24 15:03:33', '2022-03-24 15:03:33');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (130, 11, 'HBCAB', '400.00', '300.00', 'HBCAB', '2022-03-24', 1, '2022-03-24 15:06:36', '2022-03-24 15:06:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (131, 11, 'HBEAB', '700.00', '600.00', 'HBE', '2022-03-24', 1, '2022-03-24 15:07:08', '2022-03-24 15:07:08');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (132, 11, 'HB TITER', '950.00', '900.00', 'HBT', '2022-03-24', 1, '2022-03-24 15:07:48', '2022-03-24 15:07:48');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (133, 11, 'HBV ANTOBODY', '550.00', '500.00', 'HBV', '2022-03-24', 1, '2022-03-24 15:10:00', '2022-03-24 15:10:00');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (134, 11, 'HCV//', '600.00', '500.00', 'HCV', '2022-03-24', 1, '2022-03-24 15:10:30', '2022-03-24 15:10:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (135, 11, 'HCV 1 GM', '600.00', '500.00', 'HCV 1 GM', '2022-03-24', 1, '2022-03-24 15:11:02', '2022-03-24 15:11:02');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (136, 11, 'HDL', '200.00', '150.00', 'HDL', '2022-03-24', 1, '2022-03-24 15:11:30', '2022-03-24 15:11:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (137, 11, 'HDL CHOLESTEROL', '200.00', '150.00', 'HDL', '2022-03-24', 1, '2022-03-24 15:13:08', '2022-03-24 15:13:08');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (138, 11, 'HIV 1&2', '400.00', '300.00', 'HIV', '2022-03-24', 1, '2022-03-24 15:13:54', '2022-03-24 15:13:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (139, 11, 'HIV ELISA', '400.00', '300.00', 'HIV ELISA', '2022-03-24', 1, '2022-03-24 15:14:32', '2022-03-24 15:14:32');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (140, 11, 'HLAB27', '2000.00', '1900.00', 'HLA', '2022-03-24', 1, '2022-03-24 15:15:24', '2022-03-24 15:15:24');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (141, 11, 'HOMOCYSTINURIA', '200.00', '180.00', 'HOMO', '2022-03-24', 1, '2022-03-24 15:16:38', '2022-03-24 15:16:38');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (142, 11, 'HSV 1&2 IGG & 1GM', '1280.00', '1200.00', 'HSV', '2022-03-24', 1, '2022-03-24 15:17:56', '2022-03-24 15:17:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (143, 11, 'HSV IGG &IGM', '600.00', '500.00', 'HSV', '2022-03-24', 1, '2022-03-24 15:19:47', '2022-03-24 15:19:47');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (144, 11, 'HZV IGG& IGM', '700.00', '600.00', 'HZV', '2022-03-24', 1, '2022-03-24 15:20:49', '2022-03-24 15:20:49');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (145, 11, 'IGA', '500.00', '400.00', 'IGA', '2022-03-24', 1, '2022-03-24 15:21:21', '2022-03-24 15:21:21');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (146, 11, 'IGE', '650.00', '600.00', 'IGE', '2022-03-24', 1, '2022-03-24 15:21:53', '2022-03-24 15:21:53');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (147, 11, 'IGG', '520.00', '500.00', 'IGG', '2022-03-24', 1, '2022-03-24 15:23:14', '2022-03-24 15:23:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (148, 11, 'IGG HBC', '600.00', '500.00', 'IGG', '2022-03-24', 1, '2022-03-24 15:23:52', '2022-03-24 15:23:52');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (149, 11, 'IGM', '520.00', '500.00', 'IGM', '2022-03-24', 1, '2022-03-24 15:24:19', '2022-03-24 15:24:19');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (150, 11, 'IMMUNOGLOBULIN IGE', '400.00', '300.00', 'IG IGE', '2022-03-24', 1, '2022-03-24 15:25:29', '2022-03-24 15:25:29');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (151, 11, 'IMMUNO PROFILE', '800.00', '700.00', 'IP', '2022-03-24', 1, '2022-03-24 15:26:55', '2022-03-24 15:26:55');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (152, 11, 'INDIAN INK CRYPTOCOCCI', '100.00', '90.00', 'IIC', '2022-03-24', 1, '2022-03-24 15:27:40', '2022-03-24 15:27:40');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (153, 11, 'INDIRECT COOMBS TEST(ICT)', '400.00', '300.00', 'ICT', '2022-03-24', 1, '2022-03-24 15:29:02', '2022-03-24 15:29:02');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (154, 11, 'INSULIN', '500.00', '400.00', 'INSULIN', '2022-03-24', 1, '2022-03-24 15:29:37', '2022-03-24 15:29:37');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (155, 11, 'KETONE', '70.00', '60.00', 'KT', '2022-03-24', 1, '2022-03-24 15:30:08', '2022-03-24 15:30:08');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (156, 11, 'LA IGG IGM', '700.00', '600.00', 'LA', '2022-03-24', 1, '2022-03-24 15:30:58', '2022-03-24 15:30:58');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (157, 11, 'LACATE', '100.00', '90.00', 'LA', '2022-03-24', 1, '2022-03-24 15:31:34', '2022-03-24 15:31:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (158, 11, 'LDH', '250.00', '200.00', 'LDH', '2022-03-24', 1, '2022-03-24 15:33:21', '2022-03-24 15:33:21');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (159, 11, 'LDL', '250.00', '200.00', 'LDL', '2022-03-24', 1, '2022-03-24 15:33:53', '2022-03-24 15:33:53');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (160, 11, 'LE CELL', '330.00', '300.00', 'LE', '2022-03-24', 1, '2022-03-24 15:34:36', '2022-03-24 15:34:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (161, 11, 'LACTATE', '600.00', '400.00', 'LACTATE', '2022-03-24', 1, '2022-03-24 15:35:36', '2022-03-24 15:35:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (162, 11, 'LEPTO SPIRAL ANTIBODY IGM ELIS', '900.00', '800.00', 'LEPTO', '2022-03-24', 1, '2022-03-24 15:36:50', '2022-03-24 15:36:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (163, 11, 'LEPTO SPIRAL ANTIBODY IGG', '900.00', '800.00', 'IGG', '2022-03-24', 1, '2022-03-24 15:37:55', '2022-03-24 15:37:55');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (164, 11, 'LEPTO SPIRAL ANTIBODY IGG..', '900.00', '800.00', 'IGG', '2022-03-24', 1, '2022-03-24 15:38:48', '2022-03-24 15:38:48');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (165, 11, 'LUPUS ANTICOAGULANT', '450.00', '400.00', 'LUPAS', '2022-03-24', 1, '2022-03-24 15:39:47', '2022-03-24 15:39:47');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (166, 11, 'LH', '500.00', '400.00', 'LH', '2022-03-24', 1, '2022-03-24 15:40:04', '2022-03-24 15:40:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (167, 11, 'LIPOPROTIN', '500.00', '300.00', 'LIPO', '2022-03-24', 1, '2022-03-24 15:41:11', '2022-03-24 15:41:11');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (168, 11, 'LIPOPROTIN..', '500.00', '300.00', 'LIPO', '2022-03-24', 1, '2022-03-24 15:41:34', '2022-03-24 15:41:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (169, 11, 'LITHIUM', '250.00', '200.00', 'LITHIYAM', '2022-03-24', 1, '2022-03-24 15:41:56', '2022-03-24 15:41:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (170, 11, 'LUPOUS ANTICOAGULANT(LA)', '500.00', '400.00', 'LA', '2022-03-24', 1, '2022-03-24 15:42:48', '2022-03-24 15:42:48');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (171, 11, 'LYMES ANTIBODY', '750.00', '700.00', 'LYMES', '2022-03-24', 1, '2022-03-24 15:43:15', '2022-03-24 15:43:15');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (172, 11, 'MAGNESIUM', '350.00', '300.00', 'MEG', '2022-03-24', 1, '2022-03-24 15:43:42', '2022-03-24 15:43:42');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (173, 11, 'MALARIAL PARASITE', '200.00', '150.00', 'MALA', '2022-03-24', 1, '2022-03-24 15:44:08', '2022-03-24 15:44:08');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (174, 11, 'MANTOUX TEST', '150.00', '100.00', 'MANTO', '2022-03-24', 1, '2022-03-24 15:44:31', '2022-03-24 15:44:31');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (175, 11, 'MCV,PCV,MCH,MCHC', '100.00', '90.00', 'MCV', '2022-03-24', 1, '2022-03-24 15:45:04', '2022-03-24 15:45:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (176, 11, 'METANEPHRINE', '1300.00', '1200.00', 'METAN', '2022-03-24', 1, '2022-03-24 15:45:38', '2022-03-24 15:45:38');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (177, 11, 'MICRO ALBUMIN', '500.00', '400.00', 'MICRO', '2022-03-24', 1, '2022-03-24 15:46:51', '2022-03-24 15:46:51');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (178, 11, 'MICRFILERIA', '60.00', '50.00', 'MICRO', '2022-03-24', 1, '2022-03-24 15:47:21', '2022-03-24 15:47:21');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (179, 11, 'MOTION OCCULT BLOOD', '120.00', '100.00', 'OCCULT MBLOOD', '2022-03-24', 1, '2022-03-24 15:48:24', '2022-03-24 15:48:24');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (180, 11, 'MOTION RE', '100.00', '90.00', 'REM', '2022-03-24', 1, '2022-03-24 15:49:02', '2022-03-24 15:49:02');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (181, 11, 'MAYOGLOBIN', '350.00', '300.00', 'MAYO', '2022-03-24', 1, '2022-03-24 15:49:44', '2022-03-24 15:49:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (182, 11, 'NEONATAL BILRUBIN', '60.00', '50.00', 'NEO', '2022-03-24', 1, '2022-03-24 15:50:24', '2022-03-24 15:50:24');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (183, 11, 'NEUTROPHIL COUNT', '40.00', '30.00', 'COUNT', '2022-03-24', 1, '2022-03-24 15:51:22', '2022-03-24 15:51:22');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (184, 11, 'OESTROGEN', '600.00', '400.00', 'OES', '2022-03-24', 1, '2022-03-24 15:52:04', '2022-03-24 15:52:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (185, 11, 'OZMOTIC FRAGILITY', '350.00', '300.00', 'OF', '2022-03-24', 1, '2022-03-24 15:53:14', '2022-03-24 15:53:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (186, 11, 'P ANCA', '850.00', '800.00', 'P ANCA', '2022-03-24', 1, '2022-03-24 15:53:46', '2022-03-24 15:53:46');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (187, 11, 'PAPPA..', '900.00', '800.00', 'PAPPA', '2022-03-24', 1, '2022-03-24 15:54:27', '2022-03-24 15:54:27');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (188, 11, 'PAPPA TEST', '1500.00', '1400.00', 'PA', '2022-03-24', 1, '2022-03-24 15:54:58', '2022-03-24 15:54:58');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (189, 11, 'PARA THYROID HORMONEITACT(PTH)', '1000.00', '900.00', 'PTH', '2022-03-24', 1, '2022-03-24 15:57:29', '2022-03-24 15:57:29');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (190, 11, 'PAUL BUNNEL TEST(IM)', '130.00', '100.00', 'IM', '2022-03-24', 1, '2022-03-24 15:58:54', '2022-03-24 15:58:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (191, 8, 'CT ABDOMEN PLAIN', '4900.00', '4000.00', 'CT A', '2022-03-24', 1, '2022-03-24 16:01:12', '2022-03-24 16:01:12');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (192, 8, 'CT ANKLE', '4500.00', '4000.00', 'CT A', '2022-03-24', 1, '2022-03-24 16:02:40', '2022-03-24 16:02:40');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (193, 8, 'CT BRAIN PLAIN', '2350.00', '2000.00', 'CT B', '2022-03-24', 1, '2022-03-24 16:03:38', '2022-03-24 16:03:38');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (194, 8, 'CT BRAIN AND PNS PLAIN', '4800.00', '4000.00', 'CT BRA P', '2022-03-24', 1, '2022-03-24 16:06:04', '2022-03-24 16:06:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (195, 8, 'CT CERVICAL SPINE', '4750.00', '4000.00', 'CT C', '2022-03-24', 1, '2022-03-24 16:06:58', '2022-03-24 16:06:58');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (196, 8, 'CT THORAX PLAIN', '4900.00', '4000.00', 'CT T', '2022-03-24', 1, '2022-03-24 16:07:59', '2022-03-24 16:07:59');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (197, 8, 'CT HRCT PLAIN', '4900.00', '400.00', 'CT H', '2022-03-24', 1, '2022-03-24 16:08:30', '2022-03-24 16:08:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (198, 8, 'CT THORACIC SPINE', '4900.00', '4000.00', 'CT TS', '2022-03-24', 1, '2022-03-24 16:09:30', '2022-03-24 16:09:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (199, 8, 'CT LUMBO SACRAL SPINE', '4900.00', '4000.00', 'CT LS', '2022-03-24', 1, '2022-03-24 16:12:05', '2022-03-24 16:12:05');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (200, 8, 'CT PELVIS', '4500.00', '4000.00', 'CT PEL', '2022-03-24', 1, '2022-03-24 16:13:15', '2022-03-24 16:13:15');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (201, 8, 'CT  CLAVICLE', '3500.00', '2500.00', 'CT C', '2022-03-24', 1, '2022-03-24 16:14:27', '2022-03-24 16:14:27');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (202, 8, 'CT ELBOW JOINT', '3750.00', '2500.00', 'CT EL', '2022-03-24', 1, '2022-03-24 16:15:23', '2022-03-24 16:15:23');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (203, 8, 'CT SHOULDER  JOINT', '3750.00', '3500.00', 'CT SH', '2022-03-24', 1, '2022-03-24 16:16:56', '2022-03-24 16:16:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (205, 8, 'CT WRIST JOINT', '3750.00', '2500.00', 'CT WR', '2022-03-24', 1, '2022-03-24 16:18:17', '2022-03-24 16:18:17');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (206, 8, 'CT FACIAL BONE AXIAL & CORONAL', '4500.00', '3500.00', 'CT FB', '2022-03-24', 1, '2022-03-24 16:19:39', '2022-03-24 16:19:39');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (207, 8, 'CT FINGER', '3250.00', '2500.00', 'CT FR', '2022-03-24', 1, '2022-03-24 16:20:16', '2022-03-24 16:20:16');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (208, 8, 'CT HAND', '3500.00', '3000.00', 'CT HA', '2022-03-24', 1, '2022-03-24 16:20:56', '2022-03-24 16:20:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (209, 8, 'CT HIP JOINT', '4000.00', '3500.00', 'CT HI', '2022-03-24', 1, '2022-03-24 16:21:47', '2022-03-24 16:21:47');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (210, 8, 'CT KNEE SINGLE', '3750.00', '3000.00', 'CT KNEE', '2022-03-24', 1, '2022-03-24 16:22:50', '2022-03-24 16:22:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (211, 8, 'CT KNEE  BOTH', '4000.00', '3500.00', 'CT KN', '2022-03-24', 1, '2022-03-24 16:23:38', '2022-03-24 16:23:38');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (212, 8, 'CT MANDIBLE AXIAL & CORONAL', '4500.00', '3500.00', 'CT MAN', '2022-03-24', 1, '2022-03-24 16:24:44', '2022-03-24 16:24:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (213, 8, 'CT NECK PLAIN', '4900.00', '4000.00', 'CT NE', '2022-03-24', 1, '2022-03-24 16:25:18', '2022-03-24 16:25:18');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (214, 8, 'CT THYROID PLAIN', '4500.00', '3500.00', 'CT THY', '2022-03-24', 1, '2022-03-24 16:25:47', '2022-03-24 16:25:47');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (215, 8, 'CT ORBIT AXIAL& CORONAL', '4500.00', '3500.00', 'CT ORB', '2022-03-24', 1, '2022-03-24 16:26:29', '2022-03-24 16:26:29');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (216, 8, 'CT PNS PLAIN', '2450.00', '2000.00', 'CT PN', '2022-03-24', 1, '2022-03-24 16:27:02', '2022-03-24 16:27:02');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (217, 8, 'CT PNS PLAIN.', '2450.00', '2000.00', 'CT PN', '2022-03-24', 1, '2022-03-24 16:27:16', '2022-03-24 16:27:16');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (218, 8, 'CT SACRUM', '3500.00', '3000.00', 'CT SC', '2022-03-24', 1, '2022-03-24 16:27:44', '2022-03-24 16:27:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (220, 8, 'CT SCAPULA', '3500.00', '3000.00', 'CT SCA', '2022-03-24', 1, '2022-03-24 16:28:45', '2022-03-24 16:28:45');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (221, 8, 'CT SI JOINT', '3500.00', '3000.00', 'CT SI', '2022-03-24', 1, '2022-03-24 16:29:35', '2022-03-24 16:29:35');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (222, 8, 'CT TM JOINT AXIAL &CORONAL', '4000.00', '3000.00', 'CT TM', '2022-03-24', 1, '2022-03-24 16:30:21', '2022-03-24 16:30:21');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (223, 8, 'CT HRCT TEMPRAL BONE', '4000.00', '3500.00', 'CT HR', '2022-03-24', 1, '2022-03-24 16:31:05', '2022-03-24 16:31:05');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (224, 8, 'CT FOOT', '3750.00', '3000.00', 'CT FOO', '2022-03-24', 1, '2022-03-24 16:32:49', '2022-03-24 16:32:49');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (225, 8, 'CT LEG SINGLE', '4500.00', '3500.00', 'CT LE', '2022-03-24', 1, '2022-03-24 16:33:51', '2022-03-24 16:33:51');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (226, 8, 'CT FEMOUR', '4500.00', '3500.00', 'CT FE', '2022-03-24', 1, '2022-03-24 16:34:39', '2022-03-24 16:34:39');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (228, 8, 'CT FOREARM', '3750.00', '3500.00', 'CT FO', '2022-03-24', 1, '2022-03-24 16:36:02', '2022-03-24 16:36:02');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (229, 8, 'CT ARM', '3750.00', '3500.00', 'CT AR', '2022-03-24', 1, '2022-03-24 16:36:43', '2022-03-24 16:36:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (230, 8, 'CT DORASL SPINE', '4750.00', '4000.00', 'CT DOR', '2022-03-24', 1, '2022-03-24 16:43:20', '2022-03-24 16:43:20');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (231, 8, 'CT NASOPHARYNX', '3750.00', '3000.00', 'CT NS', '2022-03-24', 1, '2022-03-24 16:45:47', '2022-03-24 16:45:47');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (232, 8, 'CT FACIAL BONE 3D', '4750.00', '4000.00', 'CT F3D', '2022-03-24', 1, '2022-03-24 16:47:01', '2022-03-24 16:47:01');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (233, 8, 'CT CARPAL BONE', '3750.00', '3000.00', 'CT CAR', '2022-03-24', 1, '2022-03-24 16:48:07', '2022-03-24 16:48:07');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (234, 8, 'CT TOE', '2750.00', '2500.00', 'CT TOE', '2022-03-24', 1, '2022-03-24 16:49:58', '2022-03-24 16:49:58');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (235, 8, 'CT CALCANEUM', '3750.00', '3500.00', 'CT CAL', '2022-03-24', 1, '2022-03-24 16:51:59', '2022-03-24 16:51:59');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (236, 8, 'CT PAROTID GLAND', '4500.00', '3500.00', 'CT PARO', '2022-03-24', 1, '2022-03-24 16:52:54', '2022-03-24 16:52:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (237, 8, 'CT KUB PLAIN', '4900.00', '4000.00', 'CT KUB', '2022-03-24', 1, '2022-03-24 16:58:03', '2022-03-24 16:58:03');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (238, 11, 'MICROFILARIA', '60.00', '50.00', 'MF', '2022-03-25', 1, '2022-03-25 09:03:46', '2022-03-25 09:03:46');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (239, 11, 'PH', '30.00', '20.00', 'PH', '2022-03-25', 1, '2022-03-25 09:06:30', '2022-03-25 09:06:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (240, 11, 'PHENO BARBITONE', '400.00', '350.00', 'PB', '2022-03-25', 1, '2022-03-25 09:07:29', '2022-03-25 09:07:29');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (241, 11, 'PHOSPHOROUS', '130.00', '120.00', 'PP', '2022-03-25', 1, '2022-03-25 09:08:59', '2022-03-25 09:08:59');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (242, 11, 'PLASMA PROGESTRONE', '400.00', '300.00', 'PRG', '2022-03-25', 1, '2022-03-25 09:10:20', '2022-03-25 09:10:20');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (243, 11, 'PULERLE FLUID', '450.00', '400.00', 'PF', '2022-03-25', 1, '2022-03-25 09:17:52', '2022-03-25 09:17:52');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (244, 11, 'PLEURAL MICRO', '30.00', '20.00', 'PM', '2022-03-25', 1, '2022-03-25 09:18:36', '2022-03-25 09:18:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (245, 11, 'PLEURAL PROTEIN', '60.00', '50.00', 'PPROTEIN', '2022-03-25', 1, '2022-03-25 09:20:04', '2022-03-25 09:20:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (246, 11, 'PLEURAL SUGAR', '30.00', '20.00', 'PS', '2022-03-25', 1, '2022-03-25 09:21:05', '2022-03-25 09:21:05');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (247, 11, 'QUADRIPLET TEST', '3850.00', '3000.00', 'QT', '2022-03-25', 1, '2022-03-25 09:21:46', '2022-03-25 09:21:46');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (248, 11, 'RA TEST', '400.00', '300.00', 'RT', '2022-03-25', 1, '2022-03-25 09:22:25', '2022-03-25 09:22:25');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (249, 11, 'RBC COUNT', '40.00', '30.00', 'RC', '2022-03-25', 1, '2022-03-25 09:23:06', '2022-03-25 09:23:06');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (250, 11, 'RUBELLA IGG', '500.00', '450.00', 'R IGG', '2022-03-25', 1, '2022-03-25 10:55:55', '2022-03-25 10:55:55');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (251, 11, 'RUBELLA IGM', '500.00', '400.00', 'R IGM', '2022-03-25', 1, '2022-03-25 10:56:41', '2022-03-25 10:56:41');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (252, 11, 'RUBELLA IGG & IGM', '500.00', '450.00', 'R IGG&IGM', '2022-03-25', 1, '2022-03-25 10:57:26', '2022-03-25 10:57:26');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (253, 11, 'LAB', '0.00', '0.00', '0 BILL', '2022-03-25', 1, '2022-03-25 11:05:29', '2022-03-25 11:05:29');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (254, 11, 'S IRON', '300.00', '250.00', 'SI', '2022-03-25', 1, '2022-03-25 11:15:44', '2022-03-25 11:15:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (255, 11, 'SCALP VEIN', '20.00', '10.00', 'SV', '2022-03-25', 1, '2022-03-25 11:16:36', '2022-03-25 11:16:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (256, 11, 'SEL.70', '1500.00', '1300.00', 'S 70', '2022-03-25', 1, '2022-03-25 11:17:26', '2022-03-25 11:17:26');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (257, 11, 'SEMEN ANALYSIS', '250.00', '200.00', 'SA', '2022-03-25', 1, '2022-03-25 11:19:02', '2022-03-25 11:19:02');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (258, 11, 'SERUM PHOSPHORUS', '130.00', '120.00', 'SP', '2022-03-25', 1, '2022-03-25 11:20:17', '2022-03-25 11:20:17');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (259, 11, 'SERUM ALBUMIN', '160.00', '100.00', 'SA', '2022-03-25', 1, '2022-03-25 11:20:50', '2022-03-25 11:20:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (260, 11, 'SERUM FERTIN', '600.00', '500.00', 'SF', '2022-03-25', 1, '2022-03-25 11:21:47', '2022-03-25 11:21:47');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (261, 11, 'SERUM FOLATE', '1200.00', '1000.00', 'SF', '2022-03-25', 1, '2022-03-25 11:22:43', '2022-03-25 11:22:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (262, 11, 'SERUM PROTEINE', '160.00', '150.00', 'SP', '2022-03-25', 1, '2022-03-25 11:23:29', '2022-03-25 11:23:29');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (263, 11, 'SERUM ACE', '850.00', '800.00', 'ACE', '2022-03-25', 1, '2022-03-25 11:24:09', '2022-03-25 11:24:09');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (264, 11, 'SERUM AMALYIS', '300.00', '250.00', 'SA', '2022-03-25', 1, '2022-03-25 11:25:34', '2022-03-25 11:25:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (265, 11, 'SERUM ANTROGEN', '1850.00', '1800.00', 'SA', '2022-03-25', 1, '2022-03-25 11:26:41', '2022-03-25 11:26:41');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (266, 11, 'SERUM CALCIUM', '160.00', '140.00', 'SC', '2022-03-25', 1, '2022-03-25 11:27:20', '2022-03-25 11:27:20');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (267, 11, 'SERUM CHOLESTEROL', '130.00', '120.00', 'SC', '2022-03-25', 1, '2022-03-25 11:28:10', '2022-03-25 11:28:10');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (268, 11, 'SERUM COPPER', '130.00', '120.00', 'SC', '2022-03-25', 1, '2022-03-25 11:29:33', '2022-03-25 11:29:33');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (269, 11, 'SERUM COPPER ..', '600.00', '200.00', 'SC', '2022-03-25', 1, '2022-03-25 11:32:27', '2022-03-25 11:32:27');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (270, 11, 'SERUM COPPER...', '1700.00', '1200.00', 'SC', '2022-03-25', 1, '2022-03-25 11:33:04', '2022-03-25 11:33:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (271, 11, 'SERUM CORTISOL', '500.00', '400.00', 'SC', '2022-03-25', 1, '2022-03-25 11:34:02', '2022-03-25 11:34:02');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (272, 11, 'SERUM CREATININE', '130.00', '120.00', 'SC', '2022-03-25', 1, '2022-03-25 11:36:01', '2022-03-25 11:36:01');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (273, 11, 'SERUM GONADO TROPY', '700.00', '400.00', 'SGT', '2022-03-25', 1, '2022-03-25 11:37:04', '2022-03-25 11:37:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (274, 11, 'SERUM IGE', '650.00', '500.00', 'S IGE', '2022-03-25', 1, '2022-03-25 11:37:37', '2022-03-25 12:34:19');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (275, 11, 'SERUM IRON', '300.00', '200.00', 'SI', '2022-03-25', 1, '2022-03-25 11:38:31', '2022-03-25 11:38:31');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (276, 11, 'SERUM  LIPAISE', '400.00', '300.00', 'SL', '2022-03-25', 1, '2022-03-25 11:40:05', '2022-03-25 11:40:05');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (277, 11, 'SERUM MAYOGLOBIN', '400.00', '300.00', 'SM', '2022-03-25', 1, '2022-03-25 11:40:45', '2022-03-25 11:40:45');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (278, 11, 'SERUM VITAMIN B12', '650.00', '600.00', 'S VB12', '2022-03-25', 1, '2022-03-25 11:42:46', '2022-03-25 11:42:46');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (279, 11, 'SERUM ZINC', '1900.00', '1800.00', 'S Z', '2022-03-25', 1, '2022-03-25 11:43:55', '2022-03-25 11:43:55');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (280, 11, 'SPUTUM A F P', '250.00', '200.00', 'S AFP', '2022-03-25', 1, '2022-03-25 11:45:29', '2022-03-25 11:45:29');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (281, 11, 'SPUTUM AFP 3 DAYS', '600.00', '500.00', 'S AFP 3 DAYS', '2022-03-25', 1, '2022-03-25 11:47:15', '2022-03-25 11:47:15');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (282, 11, 'T3', '160.00', '150.00', 'T3', '2022-03-25', 1, '2022-03-25 11:47:44', '2022-03-25 11:47:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (283, 11, 'T4', '160.00', '150.00', 'T4', '2022-03-25', 1, '2022-03-25 11:48:11', '2022-03-25 11:48:11');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (284, 11, 'TB IGA', '350.00', '300.00', 'TB IGA', '2022-03-25', 1, '2022-03-25 11:49:11', '2022-03-25 11:49:11');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (285, 11, 'TB IGA IGG IGM', '1100.00', '1000.00', 'TIII', '2022-03-25', 1, '2022-03-25 11:50:29', '2022-03-25 11:50:29');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (286, 11, 'TB IGG', '350.00', '240.00', 'TB IGG', '2022-03-25', 1, '2022-03-25 11:52:30', '2022-03-25 12:34:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (287, 11, 'TB IGM', '500.00', '300.00', 'TBI', '2022-03-25', 1, '2022-03-25 11:54:16', '2022-03-25 11:54:16');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (288, 11, 'TC', '40.00', '30.00', 'TC', '2022-03-25', 1, '2022-03-25 11:55:00', '2022-03-25 11:55:00');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (289, 11, 'TC,DC,HB', '120.00', '110.00', 'TDH', '2022-03-25', 1, '2022-03-25 11:56:42', '2022-03-25 11:56:42');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (290, 11, 'TIBC', '300.00', '200.00', 'TIBC', '2022-03-25', 1, '2022-03-25 11:57:28', '2022-03-25 11:57:28');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (291, 11, 'TORCH IGB IGM', '2500.00', '2400.00', 'T II', '2022-03-25', 1, '2022-03-25 12:00:44', '2022-03-25 12:00:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (292, 11, 'TROCH IGM', '1200.00', '1100.00', 'TI', '2022-03-25', 1, '2022-03-25 12:01:26', '2022-03-25 12:01:26');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (293, 11, 'TORCH SCREENING', '2200.00', '2100.00', 'TS', '2022-03-25', 1, '2022-03-25 12:02:31', '2022-03-25 12:02:31');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (294, 11, 'TORCH TEST IGB IGM', '2050.00', '2000.00', 'T T I I', '2022-03-25', 1, '2022-03-25 12:03:57', '2022-03-25 12:03:57');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (295, 11, 'TORCH IGG', '750.00', '700.00', 'TI', '2022-03-25', 1, '2022-03-25 12:04:34', '2022-03-25 12:04:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (296, 11, 'TOTAL IRON BINDING CAPACITY', '300.00', '200.00', 'TI', '2022-03-25', 1, '2022-03-25 12:05:56', '2022-03-25 12:05:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (297, 11, 'TOTAL PROTEIN', '160.00', '150.00', 'TP', '2022-03-25', 1, '2022-03-25 12:06:43', '2022-03-25 12:06:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (298, 11, 'TOTAL PROTEINS (AIB,GLB)', '160.00', '150.00', 'TP', '2022-03-25', 1, '2022-03-25 12:07:53', '2022-03-25 12:07:53');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (299, 11, 'TOTAL TESTISTRONE', '400.00', '300.00', 'TT', '2022-03-25', 1, '2022-03-25 12:08:53', '2022-03-25 12:08:53');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (300, 11, 'TOXOPLASMA IGG', '450.00', '400.00', 'TI', '2022-03-25', 1, '2022-03-25 12:10:41', '2022-03-25 12:10:41');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (301, 11, 'TOXOPLASMA IGM', '500.00', '450.00', 'TP', '2022-03-25', 1, '2022-03-25 12:11:36', '2022-03-25 12:11:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (302, 11, 'TPHA', '700.00', '600.00', 'TPHA', '2022-03-25', 1, '2022-03-25 12:12:16', '2022-03-25 12:12:16');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (303, 11, 'TPO', '450.00', '400.00', 'TPO', '2022-03-25', 1, '2022-03-25 12:13:57', '2022-03-25 12:13:57');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (304, 11, 'TPSH', '350.00', '300.00', 'TPSH', '2022-03-25', 1, '2022-03-25 12:14:26', '2022-03-25 12:14:26');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (305, 11, 'TRAN FERIN FLARATION', '800.00', '700.00', 'TF', '2022-03-25', 1, '2022-03-25 12:16:20', '2022-03-25 12:16:20');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (306, 11, 'TRIGLYCERIDES', '200.00', '150.00', 'T', '2022-03-25', 1, '2022-03-25 12:18:14', '2022-03-25 12:18:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (307, 11, 'TRIPPIL TEST', '2100.00', '2000.00', 'TT', '2022-03-25', 1, '2022-03-25 12:19:01', '2022-03-25 12:19:01');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (308, 11, 'TROP I', '950.00', '900.00', 'TROP I', '2022-03-25', 1, '2022-03-25 12:19:49', '2022-03-25 12:19:49');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (309, 11, 'TROPINE I', '1300.00', '1200.00', 'TROPINE I', '2022-03-25', 1, '2022-03-25 12:24:58', '2022-03-25 12:24:58');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (310, 11, 'TROPINE T', '850.00', '800.00', 'TT', '2022-03-25', 1, '2022-03-25 12:25:45', '2022-03-25 12:25:45');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (311, 11, 'URINE VMA', '1300.00', '1200.00', 'URINE VMA', '2022-03-25', 1, '2022-03-25 12:28:13', '2022-03-25 12:28:13');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (312, 11, 'URINE AFB', '80.00', '70.00', 'UA', '2022-03-25', 1, '2022-03-25 12:28:50', '2022-03-25 12:28:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (313, 11, 'URINE ACETONE', '50.00', '40.00', 'UA', '2022-03-25', 1, '2022-03-25 12:29:59', '2022-03-25 12:29:59');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (314, 11, 'URINE ALBUMIN', '70.00', '60.00', 'UA', '2022-03-25', 1, '2022-03-25 12:30:42', '2022-03-25 12:30:42');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (315, 11, 'URINE BJ PROTEIN', '250.00', '200.00', 'U BJ P', '2022-03-25', 1, '2022-03-25 12:33:33', '2022-03-25 12:33:33');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (316, 11, 'URINE BP & BS', '50.00', '40.00', 'U BP BS', '2022-03-25', 1, '2022-03-25 12:37:19', '2022-03-25 12:37:19');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (317, 11, 'URINE COMPLETE', '40.00', '30.00', 'UC', '2022-03-25', 1, '2022-03-25 12:37:56', '2022-03-25 12:37:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (318, 11, 'URINE DEPOSIT', '30.00', '20.00', 'UD', '2022-03-25', 1, '2022-03-25 12:38:41', '2022-03-25 12:38:41');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (319, 11, 'URINE GC', '70.00', '60.00', 'U GC', '2022-03-25', 1, '2022-03-25 12:39:14', '2022-03-25 12:39:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (320, 11, 'URINE MICROSCOPY', '30.00', '20.00', 'UM', '2022-03-25', 1, '2022-03-25 12:39:57', '2022-03-25 12:39:57');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (321, 11, 'URINE PC RATIO', '400.00', '300.00', 'UPR', '2022-03-25', 1, '2022-03-25 12:40:36', '2022-03-25 12:40:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (322, 11, 'URINE PROTEIN', '140.00', '120.00', 'UP', '2022-03-25', 1, '2022-03-25 12:42:06', '2022-03-25 12:42:06');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (323, 11, 'URINE PROTEIN 24 HRS', '300.00', '200.00', 'UP', '2022-03-25', 1, '2022-03-25 12:43:12', '2022-03-25 12:43:12');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (324, 11, 'URINE PROTEIN CREATINE RATIO', '400.00', '300.00', 'UPCR', '2022-03-25', 1, '2022-03-25 12:44:32', '2022-03-25 12:44:32');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (325, 11, 'ABSOLUTE ESINOPHIL COUNT', '140.00', '130.00', 'AEC', '2022-03-25', 1, '2022-03-25 12:46:59', '2022-03-25 12:46:59');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (326, 11, 'ACA,IGG,IGM', '1400.00', '1000.00', 'ACA', '2022-03-25', 1, '2022-03-25 12:47:54', '2022-03-25 12:47:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (327, 11, 'ACA&IGM', '950.00', '900.00', 'ACA', '2022-03-25', 1, '2022-03-25 12:48:39', '2022-03-25 12:48:39');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (328, 11, 'ACA IGG', '950.00', '900.00', 'AI', '2022-03-25', 1, '2022-03-25 12:49:21', '2022-03-25 12:49:21');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (329, 11, 'ACCP', '1200.00', '1100.00', 'ACCP', '2022-03-25', 1, '2022-03-25 12:49:50', '2022-03-25 12:49:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (330, 11, 'ACE', '800.00', '700.00', 'ACE', '2022-03-25', 1, '2022-03-25 12:51:51', '2022-03-25 12:51:51');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (331, 11, 'ACETAMINOPHAN/PARACETAMOL', '1500.00', '1000.00', 'AP', '2022-03-25', 1, '2022-03-25 12:57:50', '2022-03-25 12:57:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (332, 11, 'ACID PHOSPHATUSE', '180.00', '170.00', 'AP', '2022-03-25', 1, '2022-03-25 12:59:13', '2022-03-25 12:59:13');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (333, 11, 'ACID PHOSPATUSE (PROSTATIC)', '300.00', '200.00', 'ACID PP', '2022-03-25', 1, '2022-03-25 13:00:34', '2022-03-25 13:00:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (334, 11, 'ACTH', '1200.00', '1100.00', 'ACTH', '2022-03-25', 1, '2022-03-25 13:01:14', '2022-03-25 13:01:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (335, 11, 'ADA (ADENOSINE DEAMINASE)', '550.00', '400.00', 'ADA', '2022-03-25', 1, '2022-03-25 13:02:38', '2022-03-25 13:02:38');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (336, 11, 'AFB C&S', '1000.00', '900.00', 'AFB', '2022-03-25', 1, '2022-03-25 13:03:28', '2022-03-25 13:03:28');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (337, 11, 'AFB SPUTUM (CONCENTRATION)', '150.00', '120.00', 'AFB', '2022-03-25', 1, '2022-03-25 13:04:49', '2022-03-25 13:04:49');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (338, 11, 'AFB PCR', '2500.00', '2000.00', 'AFB', '2022-03-25', 1, '2022-03-25 13:05:46', '2022-03-25 13:05:46');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (339, 11, 'AFP', '750.00', '700.00', 'AFP', '2022-03-25', 1, '2022-03-25 13:06:12', '2022-03-25 13:06:12');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (340, 11, 'ALBUMIN', '70.00', '60.00', 'ALBUMIN', '2022-03-25', 1, '2022-03-25 13:06:55', '2022-03-25 13:06:55');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (341, 11, 'ALDOSTERONE', '1000.00', '900.00', 'ALD', '2022-03-25', 1, '2022-03-25 13:07:44', '2022-03-25 13:07:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (342, 11, 'ALKALINE PHOSPHATASE', '200.00', '100.00', 'AP', '2022-03-25', 1, '2022-03-25 13:08:44', '2022-03-25 13:08:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (343, 11, 'ALPHA FETA PROTIEN', '750.00', '700.00', 'AFP', '2022-03-25', 1, '2022-03-25 13:09:45', '2022-03-25 13:09:45');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (344, 11, 'AMALYSE', '500.00', '400.00', 'AMLYSE', '2022-03-25', 1, '2022-03-25 13:10:14', '2022-03-25 13:10:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (345, 11, 'AMINI ACIDS QUANTITATIVE', '6200.00', '6000.00', 'AAQ', '2022-03-25', 1, '2022-03-25 13:12:26', '2022-03-25 13:12:26');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (346, 11, 'AMONIA', '700.00', '600.00', 'AMONIA', '2022-03-25', 1, '2022-03-25 13:12:56', '2022-03-25 13:12:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (347, 11, 'ANA', '1000.00', '900.00', 'ANA', '2022-03-25', 1, '2022-03-25 13:13:20', '2022-03-25 13:13:20');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (348, 11, 'ANA PROFILE', '4950.00', '4000.00', 'ANAP', '2022-03-25', 1, '2022-03-25 13:14:01', '2022-03-25 13:14:01');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (349, 11, 'ANCA', '1590.00', '1500.00', 'ANCA', '2022-03-25', 1, '2022-03-25 13:14:56', '2022-03-25 13:14:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (350, 11, 'ANDROGEN PROFILE', '3880.00', '3000.00', 'AP', '2022-03-25', 1, '2022-03-25 13:15:51', '2022-03-25 13:15:51');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (351, 11, 'ANTI CARDIOLIPINE', '1200.00', '1100.00', 'ACL', '2022-03-25', 1, '2022-03-25 13:59:23', '2022-03-25 13:59:23');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (352, 11, 'ANTIGEN', '600.00', '500.00', 'AN', '2022-03-25', 1, '2022-03-25 14:05:08', '2022-03-25 14:05:08');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (353, 11, 'ANTIHERPEX 1&2', '1300.00', '1200.00', 'AN 1&2', '2022-03-25', 1, '2022-03-25 14:07:27', '2022-03-25 14:07:27');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (354, 11, 'ANTIPHOSPHO LIPID', '950.00', '850.00', 'AL', '2022-03-25', 1, '2022-03-25 14:09:04', '2022-03-25 14:09:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (355, 11, 'ANTISERUM ANTIBODY', '750.00', '650.00', 'AA', '2022-03-25', 1, '2022-03-25 14:10:10', '2022-03-25 14:10:10');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (356, 11, 'APLA', '1610.00', '1510.00', 'APLA', '2022-03-25', 1, '2022-03-25 14:11:07', '2022-03-25 14:11:07');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (357, 11, 'APTT', '250.00', '150.00', 'APTT', '2022-03-25', 1, '2022-03-25 14:12:12', '2022-03-25 14:12:12');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (358, 11, 'ASO TITRE', '400.00', '300.00', 'AT', '2022-03-25', 1, '2022-03-25 14:13:41', '2022-03-25 14:13:41');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (359, 11, 'B2 GLYCOPROTEIN IGG IGGM', '1800.00', '1700.00', 'B2G', '2022-03-25', 1, '2022-03-25 14:16:37', '2022-03-25 14:16:37');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (360, 11, 'CA-15', '1050.00', '950.00', 'CA', '2022-03-25', 1, '2022-03-25 14:35:10', '2022-03-25 14:35:10');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (361, 11, 'CALCITONIM', '1350.00', '1250.00', 'CAL', '2022-03-25', 1, '2022-03-25 14:35:55', '2022-03-25 14:35:55');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (362, 11, 'CALCIUM', '160.00', '150.00', 'CAL', '2022-03-25', 1, '2022-03-25 14:36:30', '2022-03-25 14:36:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (363, 11, 'CARBAMAPZINE', '450.00', '440.00', 'CAR', '2022-03-25', 1, '2022-03-25 14:38:01', '2022-03-25 14:38:01');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (364, 11, 'CARDIOLIPIN AB IGG', '500.00', '480.00', 'CARD', '2022-03-25', 1, '2022-03-25 14:39:18', '2022-03-25 14:39:18');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (365, 11, 'CARDIOLIPIN AB IGM', '500.00', '480.00', 'CARD', '2022-03-25', 1, '2022-03-25 14:40:22', '2022-03-25 14:40:22');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (366, 11, 'CEA', '580.00', '550.00', 'CE', '2022-03-25', 1, '2022-03-25 14:40:56', '2022-03-25 14:40:56');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (367, 11, 'CERULOPLASMIN', '500.00', '400.00', 'C', '2022-03-25', 1, '2022-03-25 14:54:26', '2022-03-25 14:54:26');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (368, 11, 'CERUOPLASMIN', '1200.00', '1100.00', 'CP', '2022-03-25', 1, '2022-03-25 14:55:44', '2022-03-25 14:55:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (369, 11, 'CERVICAL SMEAR', '200.00', '100.00', 'CS', '2022-03-25', 1, '2022-03-25 15:00:34', '2022-03-25 15:00:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (370, 11, 'CHLAMYDIAL AB IGG', '700.00', '600.00', 'CA', '2022-03-25', 1, '2022-03-25 15:01:40', '2022-03-25 15:01:40');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (371, 11, 'CHLORIDE', '120.00', '110.00', 'CH', '2022-03-25', 1, '2022-03-25 15:11:54', '2022-03-25 15:11:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (372, 11, 'CHLAMYDIAL IGM', '700.00', '600.00', 'CH, IGM', '2022-03-25', 1, '2022-03-25 15:13:43', '2022-03-25 15:13:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (373, 11, 'CK-MB(CL)', '200.00', '100.00', 'CK', '2022-03-25', 1, '2022-03-25 15:17:14', '2022-03-25 15:17:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (374, 11, 'CHOLINESTERASE', '350.00', '250.00', 'CHOL', '2022-03-25', 1, '2022-03-25 15:29:06', '2022-03-25 15:29:06');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (375, 11, 'CHROMOSOMAL ANTIBODY', '2250.00', '2150.00', 'CHR AN', '2022-03-25', 1, '2022-03-25 15:30:32', '2022-03-25 15:30:32');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (376, 11, 'CHROMOSOMAL STUDY', '2750.00', '2650.00', 'CHR ST', '2022-03-25', 1, '2022-03-25 15:31:29', '2022-03-25 15:31:29');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (377, 11, 'CK-MB(ENZYMATIC)', '200.00', '100.00', 'CK-EN', '2022-03-25', 1, '2022-03-25 15:32:33', '2022-03-25 15:32:33');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (378, 11, 'CK(CPK)', '280.00', '270.00', 'CK (C)', '2022-03-25', 1, '2022-03-25 15:33:41', '2022-03-25 15:33:41');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (379, 11, 'BETA-HCG', '600.00', '500.00', 'B-H', '2022-03-25', 1, '2022-03-25 15:36:06', '2022-03-28 14:17:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (380, 11, 'BRUCELLA AGGLUTINATION', '850.00', '750.00', 'BA', '2022-03-25', 1, '2022-03-25 15:39:07', '2022-03-25 15:39:07');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (381, 11, 'BRUCELLA IGG', '840.00', '740.00', 'B I', '2022-03-25', 1, '2022-03-25 15:40:34', '2022-03-25 15:40:34');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (382, 11, 'BRUCELLA IGM', '800.00', '700.00', 'BR IGM', '2022-03-25', 1, '2022-03-25 15:41:32', '2022-03-25 15:41:32');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (383, 11, 'BSL-13', '1350.00', '1250.00', 'BSL', '2022-03-25', 1, '2022-03-25 15:42:23', '2022-03-25 15:42:23');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (384, 11, 'BT&CT', '80.00', '70.00', 'BT- CT', '2022-03-25', 1, '2022-03-25 15:43:04', '2022-03-25 15:43:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (385, 11, 'CA 15.3', '1500.00', '1400.00', 'CA.15.3', '2022-03-25', 1, '2022-03-25 15:44:42', '2022-03-25 15:44:42');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (386, 11, 'C ANCA', '1350.00', '1250.00', 'C ANCA', '2022-03-25', 1, '2022-03-25 15:46:13', '2022-03-25 15:46:13');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (387, 11, 'CPK', '280.00', '180.00', 'CPK', '2022-03-25', 1, '2022-03-25 15:47:15', '2022-03-25 15:47:15');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (388, 11, 'C PEPTIDE', '1450.00', '1350.00', 'C P', '2022-03-25', 1, '2022-03-25 15:48:48', '2022-03-25 15:48:48');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (389, 11, 'C-REACTIVE PROTEIN', '300.00', '400.00', 'C-R P', '2022-03-25', 1, '2022-03-25 15:50:23', '2022-03-25 15:50:23');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (390, 11, 'CA 19.9', '1050.00', '950.00', 'CA 19.9', '2022-03-25', 1, '2022-03-25 15:53:14', '2022-03-25 15:53:14');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (391, 14, 'ECG', '200.00', '150.00', 'ECG', '2022-03-26', 1, '2022-03-26 09:23:43', '2022-03-26 09:23:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (392, 15, 'BONE MINERAL DENSITY', '2300.00', '2000.00', 'BMD', '2022-03-26', 1, '2022-03-26 12:39:16', '2022-03-26 12:39:16');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (393, 8, 'CT CHEST', '4900.00', '0.00', 'CT', '2022-03-26', 1, '2022-03-26 13:58:41', '2022-03-26 14:02:32');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (394, 9, 'XRAY', '250.00', '250.00', 'XX', '2022-03-26', 1, '2022-03-26 14:19:24', '2022-03-26 14:19:24');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (395, 7, 'USG OBG', '850.00', '300.00', 'OBG', '2022-03-26', 1, '2022-03-26 15:11:23', '2022-03-26 15:11:23');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (397, 23, '4D FOLLOW UP', '1000.00', '1000.00', '4DF', '2022-03-26', 1, '2022-03-26 15:28:59', '2022-03-29 10:38:42');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (398, 23, 'DOPPLER OBG', '1300.00', '1300.00', 'OBG', '2022-03-26', 1, '2022-03-26 15:46:04', '2022-03-29 09:37:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (399, 17, 'SONOMAMMOGRAM(SINGLE)', '1100.00', '600.00', 'SONO', '2022-03-26', 1, '2022-03-26 16:32:31', '2022-03-29 09:46:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (400, 17, 'SONOMAMMOGRAM(BOTH)', '2200.00', '1000.00', 'SONO', '2022-03-26', 1, '2022-03-26 16:34:46', '2022-03-29 09:47:06');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (401, 13, 'EEG', '1500.00', '1000.00', 'EEG', '2022-03-26', 1, '2022-03-26 17:42:28', '2022-03-26 17:42:28');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (402, 12, 'NCV', '1750.00', '1000.00', 'NCV', '2022-03-26', 1, '2022-03-26 17:43:10', '2022-03-26 17:43:10');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (403, 20, 'TMT', '1850.00', '1000.00', 'TMT', '2022-03-26', 1, '2022-03-26 17:44:19', '2022-03-29 09:33:44');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (404, 22, 'ECHO', '1650.00', '1000.00', 'ECHO', '2022-03-26', 1, '2022-03-26 17:47:18', '2022-03-26 17:47:18');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (405, 19, 'HSG', '2100.00', '1500.00', 'HSG', '2022-03-26', 1, '2022-03-26 17:48:04', '2022-03-26 17:48:04');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (406, 23, 'DOPPLER THYROID', '1100.00', '1000.00', 'DOP THY', '2022-03-28', 1, '2022-03-28 09:11:52', '2022-03-29 09:38:18');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (407, 23, 'DOPPLER LOWER LIMB(BOTH)', '3000.00', '1200.00', 'DOP LIMB', '2022-03-28', 1, '2022-03-28 09:14:46', '2022-03-29 09:38:50');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (408, 23, 'DOPPLER CAROTID', '1850.00', '1000.00', 'DOP CAROTID', '2022-03-28', 1, '2022-03-28 09:17:10', '2022-03-29 09:39:41');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (409, 23, 'DOPPLER PAROTID', '1300.00', '1000.00', 'DOP PAROTID', '2022-03-28', 1, '2022-03-28 09:21:11', '2022-03-29 09:39:24');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (410, 7, 'FOLLICULAR STUDY', '1300.00', '1000.00', 'FOLLICULAR', '2022-03-28', 1, '2022-03-28 09:26:54', '2022-03-28 09:26:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (411, 23, 'DOPPLER SCROTUM', '1300.00', '1000.00', 'DOP SCROTUM', '2022-03-28', 1, '2022-03-28 09:33:05', '2022-03-29 09:39:54');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (412, 7, 'ANOMALY SCAN', '1300.00', '1000.00', 'ANOMALY', '2022-03-28', 1, '2022-03-28 09:34:28', '2022-03-28 09:34:28');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (413, 23, 'DOPPLER UPPER LIMB', '3000.00', '2000.00', 'DOPPLER U LIMB', '2022-03-28', 1, '2022-03-28 09:42:13', '2022-03-29 09:40:19');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (414, 23, 'DOPPLER UPPER LIMB (SINGLE)', '1500.00', '1400.00', 'DOPPLER U LIMB SINGL', '2022-03-28', 1, '2022-03-28 09:44:02', '2022-03-29 09:40:40');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (415, 7, 'NEUROSONOGRAME', '1300.00', '1200.00', 'NSG', '2022-03-28', 1, '2022-03-28 09:44:43', '2022-03-28 09:44:43');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (416, 7, 'B SCAN (BOTH EYE)', '1750.00', '1700.00', 'EYE', '2022-03-28', 1, '2022-03-28 09:45:36', '2022-03-28 09:45:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (417, 7, 'USG CHEST', '1300.00', '1200.00', 'CHEST', '2022-03-28', 1, '2022-03-28 09:47:33', '2022-03-28 09:47:33');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (418, 7, 'USG PELVIS', '850.00', '800.00', 'PELVIS', '2022-03-28', 1, '2022-03-28 10:04:24', '2022-03-28 10:04:24');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (419, 23, 'DOPPLER PELVIS', '1850.00', '1000.00', 'DP', '2022-03-28', 1, '2022-03-28 11:09:27', '2022-03-29 09:41:06');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (420, 11, 'VITAMIN D3', '1250.00', '1000.00', 'D3', '2022-03-28', 1, '2022-03-28 13:02:49', '2022-03-28 13:02:49');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (421, 11, 'WIDAL TEST', '200.00', '150.00', 'WT', '2022-03-28', 1, '2022-03-28 13:17:26', '2022-03-28 13:17:26');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (422, 11, 'WESTERN BLOAT', '2000.00', '1800.00', 'WB', '2022-03-28', 1, '2022-03-28 13:19:00', '2022-03-28 13:19:00');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (423, 11, 'WBC COUNT', '30.00', '20.00', 'WC', '2022-03-28', 1, '2022-03-28 13:19:36', '2022-03-28 13:19:36');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (424, 11, 'WATER ANALYSIS', '200.00', '150.00', 'WA', '2022-03-28', 1, '2022-03-28 13:21:26', '2022-03-28 13:21:26');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (425, 11, 'VMA', '1050.00', '1000.00', 'VMA', '2022-03-28', 1, '2022-03-28 13:21:53', '2022-03-28 13:21:53');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (426, 11, 'VLDL', '20.00', '10.00', 'VLDL', '2022-03-28', 1, '2022-03-28 13:22:30', '2022-03-28 13:22:30');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (427, 11, 'VITAMIN 25 OH', '1250.00', '1200.00', 'VIT 25 OH', '2022-03-28', 1, '2022-03-28 13:23:13', '2022-03-28 13:23:13');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (428, 11, 'VITAMIN 125 OH-', '3200.00', '300.00', 'VIT 125OH', '2022-03-28', 1, '2022-03-28 13:24:45', '2022-03-28 13:24:45');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (429, 11, 'VDRL', '130.00', '100.00', 'VD', '2022-03-28', 1, '2022-03-28 13:25:49', '2022-03-28 13:25:49');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (430, 11, 'URINE ALBUMIN DEPOSIT', '70.00', '40.00', 'UAD', '2022-03-28', 1, '2022-03-28 13:27:01', '2022-03-28 13:27:01');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (431, 11, 'URINE UROBILIN OGEN', '70.00', '40.00', 'UUO', '2022-03-28', 1, '2022-03-28 13:28:38', '2022-03-28 13:28:38');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (432, 11, 'URINE SPECIFIC GRAVITY', '50.00', '20.00', 'USG', '2022-03-28', 1, '2022-03-28 13:30:01', '2022-03-28 13:30:01');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (433, 23, 'DOPPLER AXICILLA', '1300.00', '1000.00', 'DOP AXICILLA', '2022-03-28', 1, '2022-03-28 14:07:55', '2022-03-29 09:41:20');
INSERT INTO `lab_test` (`id`, `category_id`, `name`, `patient_price`, `production_cost`, `test_code`, `date`, `created_by`, `created_at`, `updated_at`) VALUES (434, 16, 'OPG/CEPH', '850.00', '500.00', 'OPG CEPH', '2022-03-29', 1, '2022-03-29 09:36:03', '2022-03-29 09:36:03');


#
# TABLE STRUCTURE FOR: lab_test_category
#

DROP TABLE IF EXISTS `lab_test_category`;

CREATE TABLE `lab_test_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8;

INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (7, 'USG', '2022-03-14 12:10:04', '2022-03-14 12:10:04');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (8, 'CT Scaning', '2022-03-14 12:10:31', '2022-03-14 12:10:31');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (9, 'X-RAY', '2022-03-14 13:54:45', '2022-03-14 13:54:45');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (10, 'CONSUMERABLE', '2022-03-14 15:59:19', '2022-03-14 15:59:19');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (11, 'LAB', '2022-03-14 16:47:09', '2022-03-14 16:47:09');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (12, 'NCV', '2022-03-15 13:01:47', '2022-03-15 13:01:47');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (13, 'EEG', '2022-03-15 13:01:59', '2022-03-15 13:01:59');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (14, 'ECG', '2022-03-15 13:02:13', '2022-03-15 13:02:13');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (15, 'BMD / DEXA', '2022-03-15 13:02:27', '2022-03-28 15:20:05');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (16, 'OPG', '2022-03-15 13:02:35', '2022-03-15 13:02:35');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (17, 'MAMMOGRAM', '2022-03-15 13:03:01', '2022-03-15 13:03:01');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (18, 'FNAC', '2022-03-15 15:46:03', '2022-03-15 15:46:03');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (19, 'HSG', '2022-03-17 17:52:54', '2022-03-17 17:52:54');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (20, 'TMT', '2022-03-17 17:53:07', '2022-03-17 17:53:07');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (22, 'ECHO', '2022-03-26 17:46:13', '2022-03-26 17:46:13');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (23, 'DOPPLER', '2022-03-28 15:17:47', '2022-03-28 15:17:47');
INSERT INTO `lab_test_category` (`id`, `name`, `created_at`, `updated_at`) VALUES (24, '5D / 4D & FOLL', '2022-03-28 15:18:18', '2022-03-28 15:18:18');


#
# TABLE STRUCTURE FOR: labtest_bill
#

DROP TABLE IF EXISTS `labtest_bill`;

CREATE TABLE `labtest_bill` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(10) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `referral_id` int(11) NOT NULL,
  `total` decimal(18,2) NOT NULL DEFAULT '0.00',
  `discount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `tax_amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `commission` decimal(18,2) DEFAULT '0.00',
  `paid` decimal(18,2) NOT NULL DEFAULT '0.00',
  `due` decimal(18,2) NOT NULL DEFAULT '0.00',
  `status` tinyint(1) NOT NULL,
  `date` date DEFAULT NULL,
  `hash` varchar(50) NOT NULL,
  `prepared_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=131 DEFAULT CHARSET=utf8;

INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (38, '0004', 5, 19, '3000.00', '0.00', '0.00', '0.00', '2500.00', '500.00', 2, '2022-03-25', '26afa3358707642d1f3902f029c0f721', 1, '2022-03-25 17:58:12', '2022-03-25 17:58:12');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (39, '0005', 59, 145, '1250.00', '0.00', '0.00', '0.00', '1250.00', '0.00', 3, '2022-03-26', '81a782c91abd67a7cdbf894c67bc46a1', 1, '2022-03-26 09:09:20', '2022-03-26 09:09:20');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (40, '0006', 61, 146, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-03-26', 'e5391bcb91a9eeac4676cd201c0e1ce8', 1, '2022-03-26 10:30:13', '2022-03-26 10:30:13');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (41, '0007', 1, 16, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-03-26', 'c106606f3a6a7fd0c4fac45294ceb02c', 1, '2022-03-26 10:42:51', '2022-03-26 10:42:51');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (42, '0008', 2, 18, '50.00', '0.00', '0.00', '0.00', '50.00', '0.00', 3, '2022-03-26', 'b1e1de45b5e18dc16b731fe9e3dc5193', 1, '2022-03-26 10:46:08', '2022-03-26 10:46:08');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (43, '0009', 1, 20, '650.00', '0.00', '0.00', '0.00', '650.00', '0.00', 3, '2022-03-26', '60d065e50876952206a92189de1c794a', 1, '2022-03-26 10:51:45', '2022-03-26 14:14:27');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (48, '0010', 64, 145, '1250.00', '0.00', '0.00', '0.00', '1250.00', '0.00', 3, '2022-03-26', '1eb60e634dc9104441fcde58cb78977b', 1, '2022-03-26 12:33:48', '2022-03-26 12:33:48');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (49, '0011', 64, 145, '2300.00', '0.00', '0.00', '0.00', '2300.00', '0.00', 3, '2022-03-26', 'f5247accb90bbff55d561c9883877295', 1, '2022-03-26 12:41:03', '2022-03-26 12:41:03');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (50, '0012', 65, 148, '450.00', '0.00', '0.00', '0.00', '450.00', '0.00', 3, '2022-03-26', 'a2efca51b99379a2fe23f329e695a514', 1, '2022-03-26 12:45:00', '2022-03-26 12:47:02');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (51, '0013', 66, 149, '250.00', '0.00', '0.00', '0.00', '250.00', '0.00', 3, '2022-03-26', 'e16c3d1e7e8553e2d7a93b5266a38102', 1, '2022-03-26 13:00:15', '2022-03-26 13:00:15');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (52, '0014', 67, 148, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-03-26', '52f9ec3048fe37cbceaf5fa9b2841994', 1, '2022-03-26 13:07:18', '2022-03-26 13:07:18');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (53, '0015', 68, 78, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-03-26', '569ec6613b25be07f528888b7aa5f746', 1, '2022-03-26 13:10:39', '2022-03-26 13:10:39');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (55, '0017', 69, 150, '4900.00', '0.00', '0.00', '0.00', '4900.00', '0.00', 3, '2022-03-26', '669e0a9b99032db8b7896ec939526f16', 1, '2022-03-26 14:13:01', '2022-03-26 14:13:01');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (56, '0018', 70, 55, '250.00', '0.00', '0.00', '0.00', '250.00', '0.00', 3, '2022-03-26', '28f53d9a0b7d4c48fd819640c35bfd1c', 1, '2022-03-26 14:21:10', '2022-03-26 14:21:10');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (57, '0019', 71, 151, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-03-26', 'bd7f0a557a2471dd0165e2efb0cf7105', 1, '2022-03-26 14:30:29', '2022-03-26 14:30:29');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (58, '0020', 72, 55, '4900.00', '0.00', '0.00', '0.00', '4900.00', '0.00', 3, '2022-03-26', '5a438762f43bc46475a971da17ea1b10', 1, '2022-03-26 14:32:41', '2022-03-26 14:32:41');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (59, '0021', 73, 152, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-03-26', 'af59ff899dd4e526f346dae0133acbdd', 1, '2022-03-26 14:36:51', '2022-03-26 17:11:37');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (60, '0022', 74, 25, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-03-26', '172664afc1004dce808ae0d13bf8e15b', 1, '2022-03-26 15:20:08', '2022-03-26 15:20:08');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (61, '0023', 75, 76, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-03-26', '5140fcb3d91a96f0383cf1737cb2fa1e', 1, '2022-03-26 15:21:57', '2022-03-26 15:21:57');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (62, '0024', 76, 89, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-03-26', 'f4cdc8beb90642d27df409efa4ba403e', 1, '2022-03-26 15:23:57', '2022-03-26 15:23:57');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (63, '0025', 77, 109, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-03-26', '368e73dc12282d1bc903e9c4fb54b2d7', 1, '2022-03-26 15:31:19', '2022-03-26 15:31:19');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (64, '0026', 78, 39, '3100.00', '200.00', '0.00', '0.00', '2900.00', '0.00', 3, '2022-03-26', '9ffd6461322ba5395dda76c05e0a1776', 1, '2022-03-26 15:43:49', '2022-03-26 15:43:49');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (65, '0027', 68, 78, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-03-26', 'f1f50d846dafddb7065663da356d3809', 1, '2022-03-26 15:55:13', '2022-03-26 15:55:13');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (66, '0028', 79, 57, '600.00', '0.00', '0.00', '0.00', '600.00', '0.00', 3, '2022-03-26', 'd95992030814bc39e0f5bd73e9c8b49a', 1, '2022-03-26 15:58:18', '2022-03-26 15:58:18');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (67, '0029', 80, 78, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-03-26', '3f043f70ae0e8f3a9b9682e18b6d832d', 1, '2022-03-26 16:00:25', '2022-03-26 16:00:25');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (68, '0030', 81, 68, '600.00', '0.00', '0.00', '0.00', '600.00', '0.00', 3, '2022-03-26', 'ec8322a57274c7751cfda114a6d2bc91', 1, '2022-03-26 16:02:10', '2022-03-26 16:02:10');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (69, '0031', 82, 153, '300.00', '0.00', '0.00', '0.00', '300.00', '0.00', 3, '2022-03-26', 'fa78a5931203301ef0e760595d6cd1fd', 1, '2022-03-26 16:03:17', '2022-03-26 16:03:17');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (70, '0032', 83, 51, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-03-26', '973a4314a6ee7043deb13bcada985447', 1, '2022-03-26 16:15:52', '2022-03-26 16:15:52');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (71, '0033', 84, 62, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-03-26', '6e90a70f4fe09192bbfe0d040935979b', 1, '2022-03-26 16:16:43', '2022-03-26 16:16:43');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (72, '0034', 84, 62, '2100.00', '0.00', '0.00', '0.00', '2100.00', '0.00', 3, '2022-03-26', '4a09e3e6cb7ef89dad67f4375d412e92', 1, '2022-03-26 16:17:43', '2022-03-26 16:17:43');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (73, '0035', 85, 147, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-03-26', 'b02890c4f0308ab039bd4a1ef2900186', 1, '2022-03-26 16:20:56', '2022-03-26 16:20:56');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (74, '0036', 86, 85, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-03-26', '0d93f9f1797d2ef6263668b678f413d5', 1, '2022-03-26 16:22:27', '2022-03-26 16:22:27');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (75, '0037', 87, 62, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-03-26', '00c43c2f0ea505611e65d72807e6d313', 1, '2022-03-26 16:23:47', '2022-03-26 16:23:47');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (76, '0038', 88, 154, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-03-26', '8e7e71d3fc8378d8c4604a25b31b9875', 1, '2022-03-26 16:26:44', '2022-03-26 16:26:44');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (77, '0039', 89, 148, '2200.00', '0.00', '0.00', '0.00', '2200.00', '0.00', 3, '2022-03-26', 'a69544b01b95a25b52ffb1639913a9f5', 1, '2022-03-26 16:37:56', '2022-03-26 16:37:56');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (78, '0040', 90, 155, '2500.00', '1000.00', '0.00', '0.00', '1500.00', '0.00', 3, '2022-03-26', '874ef169fc835e9c1ff5fdcf0bb42dfa', 1, '2022-03-26 16:41:38', '2022-03-26 16:41:38');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (79, '0041', 91, 155, '2500.00', '1000.00', '0.00', '0.00', '1500.00', '0.00', 3, '2022-03-26', '072989a8515d4bc29ecedc5176e88710', 1, '2022-03-26 16:52:03', '2022-03-26 16:52:03');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (80, '0042', 92, 68, '600.00', '0.00', '0.00', '0.00', '600.00', '0.00', 3, '2022-03-26', 'b66cae3242c477da7641241e14fc5168', 1, '2022-03-26 16:54:03', '2022-03-26 16:54:03');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (81, '0043', 93, 155, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-03-26', '465e5e7032926739b00b8748f51613e6', 1, '2022-03-26 16:56:51', '2022-03-26 16:56:51');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (82, '0044', 94, 59, '300.00', '0.00', '0.00', '0.00', '300.00', '0.00', 3, '2022-03-26', 'b44cb7882be0388cd920d31819879c7e', 1, '2022-03-26 16:59:44', '2022-03-26 16:59:44');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (83, '0045', 95, 59, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-03-26', '04225b97e8c834fea8820bf17d6f58f9', 1, '2022-03-26 17:00:57', '2022-03-26 17:00:57');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (84, '0046', 96, 148, '600.00', '100.00', '0.00', '0.00', '500.00', '0.00', 3, '2022-03-26', '7009c0bbadd4916cae47b91c06e17e84', 1, '2022-03-26 17:04:06', '2022-03-26 17:04:06');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (85, '0047', 97, 154, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-03-26', '432f5997c0c019ac0ba9d09f741b886d', 1, '2022-03-26 17:07:03', '2022-03-26 17:07:03');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (86, '0048', 98, 156, '850.00', '0.00', '0.00', '0.00', '700.00', '150.00', 2, '2022-03-26', '6c36e7e6649d86079510a8b36fec769d', 1, '2022-03-26 17:26:19', '2022-03-26 17:26:19');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (87, '0049', 99, 102, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-03-28', 'cda386cef0b5d99238ea478881b771a4', 1, '2022-03-28 08:38:36', '2022-03-28 08:38:36');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (88, '0050', 100, 157, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-03-28', 'ea8400bc4f8ea3b73a5d4fc238db145b', 1, '2022-03-28 08:50:39', '2022-03-28 08:50:39');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (89, '0051', 101, 158, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-03-28', 'e1ffc0391fd0d36dcedf739431dd8b40', 1, '2022-03-28 09:28:51', '2022-03-28 09:28:51');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (90, '0052', 102, 159, '2350.00', '0.00', '0.00', '0.00', '2350.00', '0.00', 3, '2022-03-28', '812bf926b87ee59252fd205978b7000e', 1, '2022-03-28 09:50:18', '2022-03-28 09:50:18');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (91, '0053', 103, 43, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-03-28', '72c3540468ef7b97a9a1f6324ce76629', 1, '2022-03-28 10:33:25', '2022-03-28 10:33:25');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (92, '0054', 104, 160, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-03-28', '76614c657ae08b60ce2bdaf434a1109a', 1, '2022-03-28 10:42:41', '2022-03-28 10:42:41');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (93, '0055', 105, 161, '4800.00', '0.00', '0.00', '0.00', '4800.00', '0.00', 3, '2022-03-28', '5ef404554f76a4ae9727bdc543ac7843', 1, '2022-03-28 10:49:13', '2022-03-28 11:45:44');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (95, '0056', 107, 104, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-03-28', '1749450f4ef03bf4395e23b4ba2bcae2', 1, '2022-03-28 11:00:55', '2022-03-28 11:00:55');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (97, '0057', 109, 86, '1850.00', '0.00', '0.00', '0.00', '1850.00', '0.00', 3, '2022-03-28', '7c681fc8920994b306aba82edcde0d1d', 1, '2022-03-28 11:10:43', '2022-03-28 11:10:43');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (98, '0058', 110, 102, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-03-28', 'bd10b5d273589e16186c978ccd3b6b1a', 1, '2022-03-28 11:14:02', '2022-03-28 11:14:02');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (99, '0059', 111, 16, '1000.00', '0.00', '0.00', '0.00', '1000.00', '0.00', 3, '2022-03-28', 'e37fe08e915047c69c1552e1b3a622f3', 1, '2022-03-28 11:18:25', '2022-03-28 11:18:25');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (100, '0060', 112, 153, '250.00', '0.00', '0.00', '0.00', '250.00', '0.00', 3, '2022-03-28', 'b809431ec33baec373617f9421013b09', 1, '2022-03-28 11:22:38', '2022-03-28 11:22:38');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (101, '0061', 113, 163, '600.00', '0.00', '0.00', '0.00', '600.00', '0.00', 3, '2022-03-28', 'dfd6d4cab7706e887a2bc80c69a6ee37', 1, '2022-03-28 11:29:01', '2022-03-28 11:29:01');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (102, '0062', 114, 78, '1100.00', '0.00', '0.00', '0.00', '1100.00', '0.00', 3, '2022-03-28', 'fedc4f22e4ec5be1f0750cd68f2ab701', 1, '2022-03-28 11:38:08', '2022-03-28 11:38:08');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (103, '0063', 115, 164, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-03-28', '2f520dbcdac9d919a7c57f4f5185fdc6', 1, '2022-03-28 11:57:00', '2022-03-28 11:57:00');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (104, '0064', 116, 159, '2350.00', '0.00', '0.00', '0.00', '2350.00', '0.00', 3, '2022-03-28', '87d4dd2e39f9f1d28b574d78b1663583', 1, '2022-03-28 12:01:40', '2022-03-28 12:01:40');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (105, '0065', 117, 40, '3000.00', '0.00', '0.00', '0.00', '3000.00', '0.00', 3, '2022-03-28', '78dae3880abd577a506bcb1b2d1313c1', 1, '2022-03-28 12:05:09', '2022-03-28 12:05:09');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (106, '0066', 118, 165, '2500.00', '0.00', '0.00', '0.00', '2500.00', '0.00', 3, '2022-03-28', 'bbcdbff1fdc974c827ca9c91c4301f95', 1, '2022-03-28 12:10:07', '2022-03-28 12:10:07');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (107, '0067', 119, 166, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-03-28', '9e14d7a1add34d6ae1b7a58391ef6843', 1, '2022-03-28 12:22:18', '2022-03-28 12:22:18');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (108, '0068', 120, 167, '4900.00', '200.00', '0.00', '0.00', '4700.00', '0.00', 3, '2022-03-28', '0922da8a752fd26b2e013613eb284f7b', 1, '2022-03-28 12:36:34', '2022-03-28 12:36:34');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (109, '0069', 121, 168, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-03-28', '82de6b5b65d06812b664c674745e2ac5', 1, '2022-03-28 12:40:01', '2022-03-28 12:40:01');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (110, '0070', 122, 169, '600.00', '0.00', '0.00', '0.00', '600.00', '0.00', 3, '2022-03-28', 'dbea0797189c58fc5376e7238dcb6e54', 1, '2022-03-28 12:51:11', '2022-03-28 12:51:11');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (111, '0071', 123, 170, '3290.00', '0.00', '0.00', '0.00', '3290.00', '0.00', 3, '2022-03-28', '5b05769734a49935e8239d34d1cbaf9a', 1, '2022-03-28 13:05:00', '2022-03-28 13:05:00');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (112, '0072', 123, 170, '1250.00', '0.00', '0.00', '0.00', '1250.00', '0.00', 3, '2022-03-28', 'f81522a268c3a13ea4ae59c6776a4d6d', 1, '2022-03-28 13:06:36', '2022-03-28 13:06:36');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (113, '0073', 124, 34, '750.00', '0.00', '0.00', '0.00', '750.00', '0.00', 3, '2022-03-28', '82f199569f759722b64b8149070a7a06', 1, '2022-03-28 14:02:52', '2022-03-28 14:02:52');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (114, '0074', 125, 148, '1300.00', '0.00', '0.00', '0.00', '1300.00', '0.00', 3, '2022-03-28', 'e9ebb68a4865603d56ef944eaa2412eb', 1, '2022-03-28 14:10:19', '2022-03-28 14:10:19');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (115, '0075', 126, 171, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-03-28', '6c60db12391787ea31ae0f4f30a32da1', 1, '2022-03-28 14:40:51', '2022-03-28 14:40:51');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (116, '0076', 127, 39, '2200.00', '0.00', '0.00', '0.00', '2200.00', '0.00', 3, '2022-03-28', '592f326f6643c8168915acf29e6750a5', 1, '2022-03-28 14:45:15', '2022-03-28 14:45:15');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (117, '0077', 128, 172, '1100.00', '0.00', '0.00', '0.00', '1100.00', '0.00', 3, '2022-03-28', '4961cf23dcdb8d8fcb9f8a1b9861f074', 1, '2022-03-28 14:51:19', '2022-03-28 14:51:19');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (118, '0078', 129, 76, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-03-28', 'f02a0a43b03164379d15f7772e514c2f', 1, '2022-03-28 15:10:25', '2022-03-28 15:10:25');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (120, '0079', 130, 155, '250.00', '0.00', '0.00', '0.00', '250.00', '0.00', 3, '2022-03-28', 'fbb6326551ff33ba6f9e80c0abe0e234', 1, '2022-03-28 15:52:11', '2022-03-28 15:52:11');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (121, '0080', 131, 51, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-03-28', '402914be9c57a1c0b5261aa0de5b47b2', 1, '2022-03-28 16:39:39', '2022-03-28 16:39:39');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (122, '0081', 132, 173, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-03-28', '017c8771120b5386c28402019e1d5bf3', 1, '2022-03-28 16:47:12', '2022-03-28 16:47:12');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (123, '0082', 133, 59, '1100.00', '0.00', '0.00', '0.00', '1100.00', '0.00', 3, '2022-03-28', '1cb13d72b996cbf38fb1b02d70ec968b', 1, '2022-03-28 17:53:21', '2022-03-28 17:53:21');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (124, '0083', 134, 34, '850.00', '0.00', '0.00', '0.00', '500.00', '350.00', 2, '2022-03-28', '941bc24cf7c428120f9a7b4122406dac', 1, '2022-03-28 18:00:23', '2022-03-28 18:00:23');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (126, '0084', 136, 175, '950.00', '150.00', '0.00', '0.00', '800.00', '0.00', 3, '2022-03-29', 'e7b75bf2c87b57064117de5ab69d3a54', 1, '2022-03-29 08:47:51', '2022-03-29 08:47:51');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (127, '0085', 137, 78, '850.00', '0.00', '0.00', '0.00', '850.00', '0.00', 3, '2022-03-29', 'caec0ddcb7e4dc2e61b2747d92df3f7d', 1, '2022-03-29 10:00:33', '2022-03-29 10:00:33');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (128, '0086', 138, 176, '950.00', '0.00', '0.00', '0.00', '950.00', '0.00', 3, '2022-03-29', 'b18495a983b32280b2e553a9460ab6b5', 1, '2022-03-29 10:09:58', '2022-03-29 10:09:58');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (129, '0087', 139, 177, '2400.00', '0.00', '0.00', '0.00', '2400.00', '0.00', 3, '2022-03-29', '1cb2920ab9ad394385e3d06f1e21da4a', 1, '2022-03-29 10:32:23', '2022-03-29 10:32:23');
INSERT INTO `labtest_bill` (`id`, `bill_no`, `patient_id`, `referral_id`, `total`, `discount`, `tax_amount`, `commission`, `paid`, `due`, `status`, `date`, `hash`, `prepared_by`, `created_at`, `updated_at`) VALUES (130, '0088', 140, 178, '1750.00', '0.00', '0.00', '0.00', '1750.00', '0.00', 3, '2022-03-29', '9206cec89dac3b808a2d1012d9640eb7', 1, '2022-03-29 10:48:03', '2022-03-29 10:48:03');


#
# TABLE STRUCTURE FOR: labtest_bill_details
#

DROP TABLE IF EXISTS `labtest_bill_details`;

CREATE TABLE `labtest_bill_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `labtest_bill_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `test_id` int(11) NOT NULL,
  `price` decimal(18,2) NOT NULL DEFAULT '0.00',
  `discount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `commission_amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=179 DEFAULT CHARSET=utf8;

INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (73, 48, 11, 56, '50.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (74, 48, 11, 66, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (75, 48, 11, 59, '200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (76, 48, 11, 92, '200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (77, 48, 11, 65, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (78, 49, 15, 392, '2300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (79, 50, 11, 56, '50.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (80, 50, 11, 66, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (81, 51, 9, 12, '250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (82, 52, 7, 54, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (83, 53, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (87, 55, 8, 393, '4900.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (88, 56, 9, 394, '250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (89, 57, 7, 54, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (90, 58, 8, 393, '4900.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (91, 59, 7, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (92, 60, 7, 396, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (93, 61, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (94, 62, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (95, 63, 7, 397, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (96, 64, 7, 32, '3000.00', '100.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (97, 64, 10, 42, '100.00', '100.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (98, 65, 11, 63, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (99, 65, 11, 92, '200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (100, 65, 11, 60, '250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (101, 66, 16, 4, '600.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (102, 67, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (103, 68, 9, 4, '600.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (104, 69, 9, 8, '300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (105, 70, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (106, 71, 7, 33, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (107, 72, 11, 307, '2100.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (108, 73, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (109, 74, 7, 54, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (110, 75, 7, 54, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (111, 76, 7, 31, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (112, 77, 7, 400, '2200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (113, 78, 7, 20, '2500.00', '1000.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (114, 79, 7, 20, '2500.00', '1000.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (115, 80, 9, 4, '600.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (116, 81, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (117, 82, 9, 9, '300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (118, 83, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (119, 84, 9, 9, '300.00', '100.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (120, 84, 9, 8, '300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (121, 85, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (122, 86, 9, 23, '250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (123, 86, 9, 4, '600.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (124, 87, 7, 395, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (125, 88, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (126, 89, 7, 410, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (127, 90, 8, 193, '2350.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (128, 91, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (129, 92, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (130, 93, 8, 194, '4800.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (132, 95, 7, 395, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (134, 97, 7, 419, '1850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (135, 98, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (136, 99, 7, 33, '1000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (137, 100, 9, 394, '250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (138, 101, 16, 4, '600.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (139, 102, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (140, 102, 11, 75, '100.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (141, 102, 11, 316, '50.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (142, 103, 7, 410, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (143, 104, 8, 193, '2350.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (144, 105, 7, 24, '3000.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (145, 106, 15, 40, '2500.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (146, 107, 7, 395, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (147, 108, 8, 191, '4900.00', '200.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (148, 109, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (149, 110, 16, 4, '600.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (150, 111, 15, 40, '2500.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (151, 111, 11, 59, '200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (152, 111, 11, 70, '130.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (153, 111, 11, 78, '130.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (154, 111, 11, 77, '130.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (155, 111, 11, 92, '200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (156, 112, 11, 420, '1250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (157, 113, 11, 379, '750.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (158, 114, 7, 433, '1300.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (159, 115, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (160, 116, 7, 400, '2200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (161, 117, 7, 406, '1100.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (162, 118, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (164, 120, 9, 12, '250.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (165, 121, 7, 395, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (166, 122, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (167, 123, 7, 406, '1100.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (168, 124, 7, 395, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (170, 126, 7, 34, '950.00', '150.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (171, 127, 7, 54, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (172, 128, 7, 34, '950.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (173, 129, 7, 36, '850.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (174, 129, 11, 59, '200.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (175, 129, 11, 63, '400.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (176, 129, 11, 64, '450.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (177, 129, 11, 344, '500.00', '0.00', '0.00');
INSERT INTO `labtest_bill_details` (`id`, `labtest_bill_id`, `category_id`, `test_id`, `price`, `discount`, `commission_amount`) VALUES (178, 130, 12, 402, '1750.00', '0.00', '0.00');


#
# TABLE STRUCTURE FOR: labtest_payment_history
#

DROP TABLE IF EXISTS `labtest_payment_history`;

CREATE TABLE `labtest_payment_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `labtest_bill_id` int(11) NOT NULL,
  `collect_by` int(11) DEFAULT NULL,
  `amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `method_id` int(11) NOT NULL,
  `remarks` text NOT NULL,
  `paid_on` date NOT NULL,
  `coll_type` tinyint(4) NOT NULL DEFAULT '0',
  `cash` decimal(18,2) NOT NULL,
  `upi` decimal(18,2) NOT NULL,
  `online` decimal(18,2) NOT NULL,
  `card` decimal(18,2) NOT NULL,
  `due` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=127 DEFAULT CHARSET=utf8;

INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (40, 48, 1, '1250.00', 1, '', '2022-03-26', 0, '1250.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (41, 49, 1, '2300.00', 1, '', '2022-03-26', 0, '2300.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (42, 50, 1, '300.00', 1, '', '2022-03-26', 0, '300.00', '0.00', '0.00', '0.00', '150.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (43, 50, 1, '150.00', 1, '', '2022-03-26', 1, '150.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (44, 51, 1, '250.00', 1, '', '2022-03-26', 0, '250.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (45, 52, 1, '850.00', 1, '', '2022-03-26', 0, '850.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (46, 53, 1, '850.00', 1, '', '2022-03-26', 0, '850.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (48, 55, 1, '4900.00', 1, '', '2022-03-26', 0, '4900.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (49, 43, 1, '50.00', 1, '', '2022-03-26', 1, '50.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (50, 56, 1, '250.00', 1, '', '2022-03-26', 0, '250.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (51, 57, 1, '850.00', 1, '', '2022-03-26', 0, '850.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (52, 58, 1, '4900.00', 1, '', '2022-03-26', 0, '4900.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (53, 59, 1, '2000.00', 1, '', '2022-03-26', 0, '2000.00', '0.00', '0.00', '0.00', '1000.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (54, 60, 1, '850.00', 1, '', '2022-03-26', 0, '850.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (55, 61, 1, '850.00', 1, '', '2022-03-26', 0, '850.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (56, 62, 1, '950.00', 1, '', '2022-03-26', 0, '950.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (57, 63, 1, '1000.00', 1, '', '2022-03-26', 0, '1000.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (58, 64, 1, '2900.00', 2, '', '2022-03-26', 0, '0.00', '2900.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (59, 65, 1, '850.00', 1, '', '2022-03-26', 0, '850.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (60, 66, 1, '600.00', 1, '', '2022-03-26', 0, '600.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (61, 67, 1, '950.00', 1, '', '2022-03-26', 0, '950.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (62, 68, 1, '600.00', 1, '', '2022-03-26', 0, '600.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (63, 69, 1, '300.00', 1, '', '2022-03-26', 0, '300.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (64, 70, 1, '950.00', 1, '', '2022-03-26', 0, '950.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (65, 71, 1, '1000.00', 1, '', '2022-03-26', 0, '1000.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (66, 72, 1, '2100.00', 1, '', '2022-03-26', 0, '2100.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (67, 73, 1, '850.00', 1, '', '2022-03-26', 0, '850.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (68, 74, 1, '850.00', 2, '', '2022-03-26', 0, '0.00', '850.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (69, 75, 1, '850.00', 2, '', '2022-03-26', 0, '0.00', '850.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (70, 76, 1, '1300.00', 1, '', '2022-03-26', 0, '1300.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (71, 77, 1, '2200.00', 1, '', '2022-03-26', 0, '2200.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (72, 78, 1, '1500.00', 1, '', '2022-03-26', 0, '1500.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (73, 79, 1, '1500.00', 1, '', '2022-03-26', 0, '1500.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (74, 80, 1, '600.00', 1, '', '2022-03-26', 0, '600.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (75, 81, 1, '850.00', 1, '', '2022-03-26', 0, '850.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (76, 82, 1, '300.00', 4, '', '2022-03-26', 0, '0.00', '0.00', '0.00', '300.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (77, 83, 1, '850.00', 4, '', '2022-03-26', 0, '0.00', '0.00', '0.00', '850.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (78, 84, 1, '500.00', 1, '', '2022-03-26', 0, '500.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (79, 85, 1, '950.00', 1, '', '2022-03-26', 0, '950.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (80, 59, 1, '1000.00', 1, '', '2022-03-26', 1, '1000.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (81, 86, 1, '700.00', 2, '', '2022-03-26', 0, '400.00', '300.00', '0.00', '0.00', '150.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (82, 87, 1, '850.00', 1, '', '2022-03-28', 0, '850.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (83, 88, 1, '950.00', 1, '', '2022-03-28', 0, '950.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (84, 89, 1, '1300.00', 1, '', '2022-03-28', 0, '1300.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (85, 90, 1, '2350.00', 1, '', '2022-03-28', 0, '2350.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (86, 91, 1, '950.00', 1, '', '2022-03-28', 0, '950.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (87, 92, 1, '850.00', 1, '', '2022-03-28', 0, '850.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (88, 93, 1, '2000.00', 1, '', '2022-03-28', 0, '2000.00', '0.00', '0.00', '0.00', '2800.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (90, 95, 1, '850.00', 4, '', '2022-03-28', 0, '0.00', '0.00', '0.00', '850.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (92, 97, 1, '1850.00', 1, '', '2022-03-28', 0, '1850.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (93, 98, 1, '950.00', 1, '', '2022-03-28', 0, '950.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (94, 99, 1, '1000.00', 2, '', '2022-03-28', 0, '0.00', '1000.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (95, 100, 1, '250.00', 1, '', '2022-03-28', 0, '250.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (96, 101, 1, '600.00', 1, '', '2022-03-28', 0, '600.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (97, 102, 1, '1100.00', 1, '', '2022-03-28', 0, '1100.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (98, 93, 1, '2800.00', 1, '', '2022-03-28', 1, '2800.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (99, 103, 1, '1300.00', 2, '', '2022-03-28', 0, '0.00', '1300.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (100, 104, 1, '2350.00', 1, '', '2022-03-28', 0, '2350.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (101, 105, 1, '3000.00', 1, '', '2022-03-28', 0, '3000.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (102, 106, 1, '2500.00', 1, '', '2022-03-28', 0, '2500.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (103, 107, 1, '850.00', 1, '', '2022-03-28', 0, '850.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (104, 108, 1, '4700.00', 4, '', '2022-03-28', 0, '2700.00', '0.00', '0.00', '2000.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (105, 109, 1, '950.00', 1, '', '2022-03-28', 0, '950.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (106, 110, 1, '600.00', 1, '', '2022-03-28', 0, '600.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (107, 111, 1, '3290.00', 1, '', '2022-03-28', 0, '3290.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (108, 112, 1, '1250.00', 1, '', '2022-03-28', 0, '1250.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (109, 113, 1, '750.00', 1, '', '2022-03-28', 0, '750.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (110, 114, 1, '1300.00', 4, '', '2022-03-28', 0, '0.00', '0.00', '0.00', '1300.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (111, 115, 1, '950.00', 1, '', '2022-03-28', 0, '950.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (112, 116, 1, '2200.00', 1, '', '2022-03-28', 0, '2200.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (113, 117, 1, '1100.00', 4, '', '2022-03-28', 0, '0.00', '0.00', '0.00', '1100.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (114, 118, 1, '850.00', 4, '', '2022-03-28', 0, '0.00', '0.00', '0.00', '850.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (116, 120, 1, '250.00', 2, '', '2022-03-28', 0, '0.00', '250.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (117, 121, 1, '850.00', 1, '', '2022-03-28', 0, '850.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (118, 122, 1, '950.00', 4, '', '2022-03-28', 0, '0.00', '0.00', '0.00', '950.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (119, 123, 1, '1100.00', 1, '', '2022-03-28', 0, '1100.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (120, 124, 1, '500.00', 1, '', '2022-03-28', 0, '500.00', '0.00', '0.00', '0.00', '350.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (122, 126, 1, '800.00', 1, '', '2022-03-29', 0, '800.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (123, 127, 1, '850.00', 1, '', '2022-03-29', 0, '850.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (124, 128, 1, '950.00', 1, '', '2022-03-29', 0, '950.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (125, 129, 1, '2400.00', 1, '', '2022-03-29', 0, '2400.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `labtest_payment_history` (`id`, `labtest_bill_id`, `collect_by`, `amount`, `method_id`, `remarks`, `paid_on`, `coll_type`, `cash`, `upi`, `online`, `card`, `due`) VALUES (126, 130, 1, '1750.00', 1, '', '2022-03-29', 0, '1750.00', '0.00', '0.00', '0.00', '0.00');


#
# TABLE STRUCTURE FOR: labtest_report
#

DROP TABLE IF EXISTS `labtest_report`;

CREATE TABLE `labtest_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `labtest_bill_id` int(11) NOT NULL,
  `reporting_date` date DEFAULT NULL,
  `delivery_date` date DEFAULT NULL,
  `delivery_time` time DEFAULT NULL,
  `report_description` longtext,
  `report_remarks` text,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=125 DEFAULT CHARSET=utf8;

INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (42, 48, '2022-03-28', '2022-03-26', '12:30:00', '<p><u><strong>PROGESTERONE</strong></u></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">Progesterone&nbsp;(Serum,CMIA)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;1.00 ng/mL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Menstrual Cycle:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Follicular Phase:&nbsp;&lt;0.3ng/mL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;LutealPhase:1.2-15.9ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Post menopausal:&lt;0.2ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Pregnancy:</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;First Trimester:2.8-147.3ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Second Trimester:22.5-95.3ng/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Third trimester:27.9-242.5ng/mL</span></span></span></p>\r\n', '', 2);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (43, 49, '2022-03-28', '2022-03-26', '12:45:00', '<p style=\"margin-bottom:14px\"><strong><u>EXAMINATION OF URINE</u></strong>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">a) PHYSICAL CHARACTERS :&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Colour&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Pale Yellow&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Transparency&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;:&nbsp; &nbsp;Clear&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;Reaction&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Acidic&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\"><strong>b) CHEMICAL CONSTITUENTS :&nbsp;</strong>&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Albumin&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Sugar&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">c) MICROSCOPICAL EXAMINATION :</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Amorphous Urates&nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Epithelial Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;0-2/HPF</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Pus Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;:&nbsp; &nbsp;1-2/HPF</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;R B C s&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Casts&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Crystals Uric Acid&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Bacteria&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Yeast Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil</span></span></span></p>\r\n', '', 2);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (44, 50, '2022-03-28', '2022-03-26', '12:45:00', '<p style=\"margin-bottom:14px\"><u><strong>THYROID FUNCTION TEST (Child)</strong></u> &nbsp;&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;T3(CLIA METHOD)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;141.8ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Cord blood:15.0-75.0ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1-3 Days:32.0-216.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3-30 Days::50.0-250.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;1-12 Months:105.0-280.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;1-5 Years:105.0-269.0,ng/dL&nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">5-10Years:94.0-241.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">10-16Years:83.0-213.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">15-18 Years:80.0-210.0ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T4 (CLIA METHOD)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 9.3 ug/dL&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Cord blood :&nbsp;4.6-&nbsp;13.0,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1- 3 Days&nbsp; :&nbsp; 11.8-23.2,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;3-10 Days&nbsp; :&nbsp;&nbsp; 9.9-21.9,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 10-45 Days :&nbsp;&nbsp; 8.2-16.2ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 45-95 Days :&nbsp;&nbsp; 6.4-14.0ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3-12 Months:&nbsp;&nbsp; 7.8-16.5,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1- 5 Years :&nbsp;&nbsp; 7.3-15.0,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 5-10 Years :&nbsp;&nbsp; 6.4-13.3,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;10-15 Years :&nbsp;&nbsp; 5.6-11.7,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;15-18 Years :&nbsp;&nbsp; 4.2-11.8&#39;ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">TSH (CLIA-ULTRASENSITIVE)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 4.31 uIU/ml&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&lt;1 Month : 0.4 - 20.0 uIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1 Month to 10 Year : 0.4 - 10.0 uIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Above 10 Year : 0.4 - 4.5 uIU/mL</span></span></span></p>\r\n', '', 2);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (45, 51, '2022-03-28', '2022-03-26', '13:00:00', '<p style=\"margin-bottom:14px\"><u><strong>THYROID FUNCTION TEST (Child)</strong></u> &nbsp;&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;T3(CLIA METHOD)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;141.8ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Cord blood:15.0-75.0ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1-3 Days:32.0-216.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3-30 Days::50.0-250.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;1-12 Months:105.0-280.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;1-5 Years:105.0-269.0,ng/dL&nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">5-10Years:94.0-241.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">10-16Years:83.0-213.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">15-18 Years:80.0-210.0ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T4 (CLIA METHOD)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 9.3 ug/dL&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Cord blood :&nbsp;4.6-&nbsp;13.0,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1- 3 Days&nbsp; :&nbsp; 11.8-23.2,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;3-10 Days&nbsp; :&nbsp;&nbsp; 9.9-21.9,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 10-45 Days :&nbsp;&nbsp; 8.2-16.2ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 45-95 Days :&nbsp;&nbsp; 6.4-14.0ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3-12 Months:&nbsp;&nbsp; 7.8-16.5,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1- 5 Years :&nbsp;&nbsp; 7.3-15.0,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 5-10 Years :&nbsp;&nbsp; 6.4-13.3,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;10-15 Years :&nbsp;&nbsp; 5.6-11.7,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;15-18 Years :&nbsp;&nbsp; 4.2-11.8&#39;ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">TSH (CLIA-ULTRASENSITIVE)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 4.31 uIU/ml&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&lt;1 Month : 0.4 - 20.0 uIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1 Month to 10 Year : 0.4 - 10.0 uIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Above 10 Year : 0.4 - 4.5 uIU/mL</span></span></span></p>\r\n', '', 2);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (46, 52, '2022-03-29', '2022-03-26', '13:00:00', '<p style=\"margin-bottom:14px\"><strong><u>EXAMINATION OF URINE</u></strong>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">a) PHYSICAL CHARACTERS :&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Colour&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Pale Yellow&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Transparency&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;:&nbsp; &nbsp;Clear&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;Reaction&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Acidic&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\"><strong>b) CHEMICAL CONSTITUENTS :&nbsp;</strong>&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Albumin&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Sugar&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">c) MICROSCOPICAL EXAMINATION :</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Amorphous Urates&nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Epithelial Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;0-2/HPF</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Pus Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;:&nbsp; &nbsp;1-2/HPF</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;R B C s&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Casts&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Crystals Uric Acid&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Bacteria&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Yeast Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil</span></span></span></p>\r\n', '', 2);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (47, 53, '2022-03-29', '2022-03-26', '13:15:00', '<p style=\"margin-bottom:14px\"><strong><u>EXAMINATION OF URINE</u></strong>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">a) PHYSICAL CHARACTERS :&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Colour&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Pale Yellow&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Transparency&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Clear&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;Reaction&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Acidic&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\"><strong>b) CHEMICAL CONSTITUENTS :&nbsp;</strong>&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Albumin&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Sugar&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">c) MICROSCOPICAL EXAMINATION :</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Amorphous Urates&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Epithelial Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;0-2/HPF</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Pus Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;1-2/HPF</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;R B C s&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Casts&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Crystals Uric Acid&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Bacteria&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Yeast Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Nil</span></span></span></p>\r\n', '', 2);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (49, 55, '2022-03-29', '2022-03-26', '14:15:00', '<p style=\"margin-bottom:14px\"><strong><u>EXAMINATION OF URINE</u></strong>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">a) PHYSICAL CHARACTERS :&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Colour&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Pale Yellow&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Transparency&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Clear&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;Reaction&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Acidic&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\"><strong>b) CHEMICAL CONSTITUENTS :&nbsp;</strong>&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Albumin&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Sugar&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">c) MICROSCOPICAL EXAMINATION :</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Amorphous Urates&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Epithelial Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;0-2/HPF</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Pus Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;1-2/HPF</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;R B C s&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Casts&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Crystals Uric Acid&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Bacteria&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Yeast Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil</span></span></span></p>\r\n', '', 2);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (50, 56, NULL, '2022-03-26', '14:30:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (51, 57, NULL, '2022-03-26', '14:30:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (52, 58, NULL, '2022-03-26', '14:30:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (53, 59, NULL, '2022-03-26', '14:45:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (54, 60, NULL, '2022-03-26', '15:30:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (55, 61, NULL, '2022-03-26', '15:30:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (56, 62, NULL, '2022-03-26', '15:30:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (57, 63, NULL, '2022-03-26', '15:30:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (58, 64, NULL, '2022-03-26', '15:45:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (59, 65, NULL, '2022-03-26', '16:00:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (60, 66, NULL, '2022-03-26', '16:00:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (61, 67, NULL, '2022-03-26', '16:00:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (62, 68, NULL, '2022-03-26', '16:00:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (63, 69, NULL, '2022-03-26', '16:00:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (64, 70, NULL, '2022-03-26', '16:15:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (65, 71, NULL, '2022-03-26', '16:15:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (66, 72, NULL, '2022-03-26', '16:30:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (67, 73, NULL, '2022-03-26', '16:30:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (68, 74, NULL, '2022-03-26', '16:30:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (69, 75, NULL, '2022-03-26', '16:30:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (70, 76, NULL, '2022-03-26', '16:30:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (71, 77, NULL, '2022-03-26', '16:45:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (72, 78, NULL, '2022-03-26', '16:45:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (73, 79, NULL, '2022-03-26', '17:00:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (74, 80, NULL, '2022-03-26', '17:00:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (75, 81, NULL, '2022-03-26', '17:00:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (76, 82, NULL, '2022-03-26', '17:00:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (77, 83, NULL, '2022-03-26', '17:00:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (78, 84, NULL, '2022-03-26', '17:00:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (79, 85, NULL, '2022-03-26', '17:15:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (80, 86, NULL, '2022-03-26', '17:30:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (81, 87, NULL, '2022-03-28', '08:45:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (82, 88, NULL, '2022-03-28', '08:45:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (83, 89, NULL, '2022-03-28', '09:30:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (84, 90, NULL, '2022-03-28', '10:00:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (85, 91, NULL, '2022-03-28', '10:30:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (86, 92, NULL, '2022-03-28', '10:45:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (87, 93, NULL, '2022-03-28', '10:45:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (89, 95, NULL, '2022-03-28', '11:00:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (91, 97, NULL, '2022-03-28', '11:15:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (92, 98, NULL, '2022-03-28', '11:15:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (93, 99, NULL, '2022-03-28', '11:15:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (94, 100, NULL, '2022-03-28', '11:30:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (95, 101, NULL, '2022-03-28', '11:30:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (96, 102, '2022-03-28', '2022-03-28', '11:45:00', '<p style=\"margin-bottom:14px\"><strong><u>EXAMINATION OF URINE</u></strong>&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">a) PHYSICAL CHARACTERS :&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Colour&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Pale Yellow&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Transparency&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;:&nbsp; &nbsp;Clear&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp;&nbsp;Reaction&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Acidic&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\"><strong>b) CHEMICAL CONSTITUENTS :&nbsp;</strong>&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Albumin&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;&nbsp; Sugar&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><strong><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">c) MICROSCOPICAL EXAMINATION :</span></span></span></strong></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Amorphous Urates&nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Epithelial Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;0-2/HPF</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Pus Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp;:&nbsp; &nbsp;1-2/HPF</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;R B C s&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Casts&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Crystals Uric Acid&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Bacteria&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp;Yeast Cells&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; &nbsp;Nil</span></span></span></p>\r\n', '', 2);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (97, 103, NULL, '2022-03-28', '11:45:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (98, 104, NULL, '2022-03-28', '12:00:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (99, 105, NULL, '2022-03-28', '12:15:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (100, 106, NULL, '2022-03-28', '12:15:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (101, 107, NULL, '2022-03-28', '12:30:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (102, 108, NULL, '2022-03-28', '12:45:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (103, 109, NULL, '2022-03-28', '12:45:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (104, 110, NULL, '2022-03-28', '12:45:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (105, 111, '2022-03-28', '2022-03-28', '13:00:00', '<p style=\"margin-bottom:14px\"><u><strong>THYROID FUNCTION TEST (Child)</strong></u> &nbsp;&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;T3(CLIA METHOD)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;141.8ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Cord blood:15.0-75.0ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1-3 Days:32.0-216.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3-30 Days::50.0-250.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;1-12 Months:105.0-280.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;1-5 Years:105.0-269.0,ng/dL&nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">5-10Years:94.0-241.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">10-16Years:83.0-213.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">15-18 Years:80.0-210.0ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T4 (CLIA METHOD)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 9.3 ug/dL&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Cord blood :&nbsp;4.6-&nbsp;13.0,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1- 3 Days&nbsp; :&nbsp; 11.8-23.2,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;3-10 Days&nbsp; :&nbsp;&nbsp; 9.9-21.9,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 10-45 Days :&nbsp;&nbsp; 8.2-16.2ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 45-95 Days :&nbsp;&nbsp; 6.4-14.0ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3-12 Months:&nbsp;&nbsp; 7.8-16.5,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1- 5 Years :&nbsp;&nbsp; 7.3-15.0,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 5-10 Years :&nbsp;&nbsp; 6.4-13.3,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;10-15 Years :&nbsp;&nbsp; 5.6-11.7,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;15-18 Years :&nbsp;&nbsp; 4.2-11.8&#39;ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">TSH (CLIA-ULTRASENSITIVE)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 4.31 uIU/ml&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&lt;1 Month : 0.4 - 20.0 uIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1 Month to 10 Year : 0.4 - 10.0 uIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Above 10 Year : 0.4 - 4.5 uIU/mL</span></span></span></p>\r\n', '', 2);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (106, 112, '2022-03-28', '2022-03-28', '13:15:00', '<p style=\"margin-bottom:14px\"><u><strong>THYROID FUNCTION TEST (Child)</strong></u> &nbsp;&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;T3(CLIA METHOD)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;141.8ng/dL&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Cord blood:15.0-75.0ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1-3 Days:32.0-216.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3-30 Days::50.0-250.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp;1-12 Months:105.0-280.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;1-5 Years:105.0-269.0,ng/dL&nbsp; &nbsp; &nbsp;</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">5-10Years:94.0-241.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">10-16Years:83.0-213.0,ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </span></span></span><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">15-18 Years:80.0-210.0ng/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\">&nbsp;</p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">T4 (CLIA METHOD)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 9.3 ug/dL&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Cord blood :&nbsp;4.6-&nbsp;13.0,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1- 3 Days&nbsp; :&nbsp; 11.8-23.2,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;3-10 Days&nbsp; :&nbsp;&nbsp; 9.9-21.9,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 10-45 Days :&nbsp;&nbsp; 8.2-16.2ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 45-95 Days :&nbsp;&nbsp; 6.4-14.0ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 3-12 Months:&nbsp;&nbsp; 7.8-16.5,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1- 5 Years :&nbsp;&nbsp; 7.3-15.0,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 5-10 Years :&nbsp;&nbsp; 6.4-13.3,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;10-15 Years :&nbsp;&nbsp; 5.6-11.7,ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;15-18 Years :&nbsp;&nbsp; 4.2-11.8&#39;ug/dL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">TSH (CLIA-ULTRASENSITIVE)&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 4.31 uIU/ml&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;&lt;1 Month : 0.4 - 20.0 uIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1 Month to 10 Year : 0.4 - 10.0 uIU/mL</span></span></span></p>\r\n\r\n<p style=\"margin-bottom:14px\"><span style=\"font-size:11pt\"><span style=\"line-height:115%\"><span style=\"font-family:Calibri,sans-serif\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;Above 10 Year : 0.4 - 4.5 uIU/mL</span></span></span></p>\r\n', '', 2);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (107, 113, NULL, '2022-03-28', '14:15:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (108, 114, NULL, '2022-03-28', '14:15:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (109, 115, NULL, '2022-03-28', '14:45:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (110, 116, NULL, '2022-03-28', '14:45:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (111, 117, NULL, '2022-03-28', '15:00:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (112, 118, NULL, '2022-03-28', '15:15:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (114, 120, NULL, '2022-03-28', '16:00:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (115, 121, NULL, '2022-03-28', '16:15:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (116, 122, NULL, '2022-03-28', '16:45:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (117, 123, NULL, '2022-03-28', '18:00:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (118, 124, NULL, '2022-03-28', '18:00:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (120, 126, NULL, '2022-03-29', '08:45:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (121, 127, NULL, '2022-03-29', '10:00:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (122, 128, NULL, '2022-03-29', '10:15:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (123, 129, NULL, '2022-03-29', '10:30:00', NULL, '', 1);
INSERT INTO `labtest_report` (`id`, `labtest_bill_id`, `reporting_date`, `delivery_date`, `delivery_time`, `report_description`, `report_remarks`, `status`) VALUES (124, 130, NULL, '2022-03-29', '10:45:00', NULL, '', 1);


#
# TABLE STRUCTURE FOR: language_list
#

DROP TABLE IF EXISTS `language_list`;

CREATE TABLE `language_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `lang_field` varchar(100) NOT NULL,
  `status` varchar(11) NOT NULL DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8;

INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (1, 'English', 'english', '1', '2018-11-15 17:36:31', '2020-01-09 11:45:23');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (2, 'Bengali', 'bengali', '0', '2018-11-15 17:36:31', '2022-03-16 17:38:48');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (3, 'Arabic', 'arabic', '0', '2018-11-15 17:36:31', '2020-01-07 13:22:02');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (4, 'German', 'german', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:26');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (5, 'Greek', 'greek', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:28');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (6, 'Spanish', 'spanish', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:29');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (7, 'French', 'french', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:31');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (8, 'Hindi', 'hindi', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:33');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (9, 'Hungarian', 'hungarian', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:34');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (10, 'Indonesian', 'indonesian', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:35');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (11, 'Italian', 'italian', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:37');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (12, 'Japanese', 'japanese', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:38');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (13, 'Korean', 'korean', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:40');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (14, 'Latin', 'latin', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:41');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (15, 'Dutch', 'dutch', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:43');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (16, 'Portuguese', 'portuguese', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:44');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (17, 'Russian', 'russian', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:46');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (18, 'Thai', 'thai', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:47');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (19, 'Turkish', 'turkish', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:49');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (20, 'Urdu', 'urdu', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:50');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (21, 'Chinese', 'chinese', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:51');


#
# TABLE STRUCTURE FOR: languages
#

DROP TABLE IF EXISTS `languages`;

CREATE TABLE `languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `word` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `english` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `bengali` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `arabic` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `german` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `greek` varchar(100) COLLATE utf32_unicode_ci NOT NULL,
  `spanish` varchar(100) COLLATE utf32_unicode_ci NOT NULL,
  `french` varchar(100) COLLATE utf32_unicode_ci NOT NULL,
  `hindi` varchar(100) COLLATE utf32_unicode_ci NOT NULL,
  `hungarian` varchar(100) COLLATE utf32_unicode_ci NOT NULL,
  `indonesian` varchar(100) COLLATE utf32_unicode_ci NOT NULL,
  `italian` varchar(100) COLLATE utf32_unicode_ci NOT NULL,
  `japanese` varchar(100) COLLATE utf32_unicode_ci NOT NULL,
  `korean` varchar(100) COLLATE utf32_unicode_ci NOT NULL,
  `latin` varchar(100) COLLATE utf32_unicode_ci NOT NULL,
  `dutch` varchar(100) COLLATE utf32_unicode_ci NOT NULL,
  `portuguese` varchar(100) COLLATE utf32_unicode_ci NOT NULL,
  `russian` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `thai` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `turkish` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `urdu` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `chinese` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=464 DEFAULT CHARSET=utf32 COLLATE=utf32_unicode_ci;

INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (1, 'dashboard', 'Dashboard', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (2, 'create', 'Create', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (3, 'patient', 'Patient', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (4, 'test', 'Test', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (5, 'bill', 'Bill', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (6, 'commission', 'Commission', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (7, 'withdrawal', 'Withdrawal', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (8, 'appointment', 'Appointment', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (9, 'voucher', 'Voucher', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (10, 'income_vs_expense', 'Income Vs Expense', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (11, 'search', 'Search', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (12, 'visit_home_page', 'Visit Home Page', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (13, 'language', 'Language', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (14, 'logout', 'Logout', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (15, 'profile', 'Profile', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (16, 'reset_password', 'Reset Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (17, 'global', 'Global', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (18, 'settings', 'Settings', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (19, 'frontend', 'Frontend', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (20, 'setting', 'Setting', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (21, 'menu', 'Menu', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (22, 'page', 'Page', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (23, 'section', 'Section', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (24, 'manage', 'Manage', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (25, 'slider', 'Slider', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (26, 'features', 'Features', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (27, 'testimonial', 'Testimonial', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (28, 'service', 'Service', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (29, 'faq', 'Faq', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (30, 'details', 'Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (31, 'list', 'List', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (32, 'category', 'Category', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (33, 'login_deactivate', 'Login Deactivate', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (34, 'inventory', 'Inventory', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (35, 'chemical', 'Chemical', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (36, 'supplier', 'Supplier', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (37, 'unit', 'Unit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (38, 'purchase', 'Purchase', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (39, 'stock', 'Stock', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (40, 'reagent', 'Reagent', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (41, 'assigned', 'Assigned', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (42, 'reports', 'Reports', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (43, 'report', 'Report', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (44, 'payment', 'Payment', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (45, 'schedule', 'Schedule', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (46, 'add', 'Add', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (47, 'requested_list', 'Requested List', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (48, 'employee', 'Employee', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (49, 'department', 'Department', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (50, 'designation', 'Designation', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (51, 'hrm', 'Human Resource', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (52, 'payroll', 'Payroll', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (53, 'salary', 'Salary', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (54, 'template', 'Template', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (55, 'assign', 'Assign', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (56, 'summary', 'Summary', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (57, 'leaves', 'Leaves', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (58, 'my_leave', 'My Leave', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (59, 'leave_manage', 'Leave Manage', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (60, 'attendance', 'Attendance', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (61, 'set', 'Set', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (62, 'pathology', 'Pathology', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (63, 'lab', 'Lab', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (64, 'refer_manager', 'Refer Manager', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (65, 'referral', 'Referral', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (66, 'my_commission', 'My Commission', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (67, 'statement', 'Statement', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (68, 'payout', 'Payout', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (69, 'office_accounting', 'Office Accounting', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (70, 'account', 'Account', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (71, 'head', 'Head', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (72, 'income', 'Income', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (73, 'repots', 'Repots', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (74, 'expense', 'Expense', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (75, 'transitions', 'Transitions', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (76, 'balance', 'Balance', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (77, 'sheet', 'Sheet', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (78, 'billing', 'Billing', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (79, 'due', 'Due', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (80, 'paid', 'Paid', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (81, 'collect', 'Collect', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (82, 'investigation', 'Investigation', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (83, 'sms', 'Sms', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (84, 'email', 'Email', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (85, 'role', 'Role', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (86, 'permission', 'Permission', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (87, 'database', 'Database', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (88, 'backup', 'Backup', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (89, 'invoice', 'Invoice', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (90, 'today_total', 'Today Total', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (91, 'annual', 'Annual', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (92, 'total_strength', 'Total Strength', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (93, 'doctor', 'Doctor', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (94, 'pending', 'Pending', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (95, 'request', 'Request', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (96, 'fees', 'Fees', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (97, 'net', 'Net', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (98, 'payable', 'Payable', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (99, 'total', 'Total', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (100, 'this_value_is_required', 'This Value Is Required', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (101, 'enter_valid_email', 'Enter Valid Email', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (102, 'are_you_sure', 'Are You Sure', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (103, 'delete_this_information', 'Delete This Information', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (104, 'yes_continue', 'Yes Continue', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (105, 'cancel', 'Cancel', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (106, 'deleted_note', '*Note : This Data Will Be Permanently Deleted', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (107, 'deleted', 'Deleted', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (108, 'information_deleted', 'Information Deleted', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (109, 'website', 'Website', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (110, 'application', 'Application', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (111, 'name', 'Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (112, 'receive_email_to', 'Receive Email To', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (113, 'captcha_status', 'Captcha Status', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (114, 'select', 'Select', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (115, 'disable', 'Disable', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (116, 'enable', 'Enable', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (117, 'recaptcha_site_key', 'Recaptcha Site Key', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (118, 'recaptcha_secret_key', 'Recaptcha Secret Key', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (119, 'working_hours', 'Working Hours', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (120, 'logo', 'Logo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (121, 'fav_icon', 'Fav Icon', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (122, 'address', 'Address', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (123, 'mobile_no', 'Mobile No', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (124, 'fax', 'Fax', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (125, 'footer_text', 'Footer Text', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (126, 'facebook_url', 'Facebook Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (127, 'twitter_url', 'Twitter Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (128, 'youtube_url', 'Youtube Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (129, 'google_plus', 'Google Plus', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (130, 'linkedin_url', 'Linkedin Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (131, 'pinterest_url', 'Pinterest Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (132, 'instagram_url', 'Instagram Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (133, 'save', 'Save', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (134, 'website_page', 'Website Page', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (135, 'welcome', 'Welcome', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (136, 'message', 'Message', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (137, 'doctors', 'Doctors', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (138, 'services', 'Services', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (139, 'call_to_action_section', 'Call To Action Section', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (140, 'options', 'Options', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (141, 'title', 'Title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (142, 'subtitle', 'Subtitle', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (143, 'description', 'Description', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (144, 'photo', 'Photo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (145, 'cta', 'Cta', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (146, 'button_text', 'Button Text', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (147, 'button_url', 'Button Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (148, '_title', ' Title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (149, 'meta', 'Meta', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (150, 'keyword', 'Keyword', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (151, 'banner_photo', 'Banner Photo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (152, 'about', 'About', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (153, 'content', 'Content', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (154, 'about_photo', 'About Photo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (155, 'parallax_photo', 'Parallax Photo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (156, 'sl', 'Sl', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (157, 'url', 'Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (158, 'action', 'Action', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (159, 'my_appointment', 'My Appointment', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (160, 'appointment_status', 'Appointment Status', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (161, 'date', 'Date', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (162, 'time_slot', 'Time Slot', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (163, 'consultation_fees', 'Consultation Fees', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (164, 'discount', 'Discount', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (165, 'remarks', 'Remarks', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (166, 'exploring', 'Exploring', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (167, 'no_schedule_found', 'No Schedule Found', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (168, 'information_has_been_saved_successfully', 'Information Has Been Saved Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (169, 'id', 'Id', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (170, 'consultation', 'Consultation', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (171, 'serial', 'Serial', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (172, 'status', 'Status', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (173, 'confirmed', 'Confirmed', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (174, 'available', 'Available', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (175, 'staff_id', 'Staff Id', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (176, 'general', 'General', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (177, 'theme', 'Theme', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (178, 'institute_name', 'Institute Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (179, 'currency', 'Currency', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (180, 'currency_symbol', 'Currency Symbol', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (181, 'timezone', 'Timezone', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (182, 'date_format', 'Date Format', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (183, 'system_logo', 'System Logo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (184, 'text_logo', 'Text Logo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (185, 'upload', 'Upload', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (186, 'select_ground', 'Select Ground', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (187, 'filter', 'Filter', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (188, 'bill_no', 'Bill No', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (189, 'delivery', 'Delivery', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (190, 'lab_test', 'Lab Test', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (191, 'edit', 'Edit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (192, 'code', 'Code', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (193, 'purchase_unit', 'Purchase Unit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (194, 'sale_unit', 'Sale Unit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (195, 'unit_ratio', 'Unit Ratio', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (196, 'purchase_price', 'Purchase Price', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (197, 'sales_price', 'Sales Price', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (198, 'all_select', 'All Select', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (199, 'unpaid', 'Unpaid', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (200, 'partly_paid', 'Partly Paid', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (201, 'total_paid', 'Total Paid', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (202, 'type', 'Type', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (203, 'ref_no', 'Ref No', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (204, 'pay_via', 'Pay Via', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (205, 'amount', 'Amount', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (206, 'dr', 'Dr', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (207, 'cr', 'Cr', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (208, 'ref', 'Ref', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (209, 'attachment', 'Attachment', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (210, 'login', 'Login', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (211, 'welcome_to', 'Welcome To', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (212, 'username', 'Username', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (213, 'password', 'Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (214, 'remember', 'Remember', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (215, 'lose_your_password', 'Lose Your Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (216, 'position', 'Position', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (217, 'publish', 'Publish', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (218, 'target_new_window', 'Target New Window', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (219, 'external_url', 'External Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (220, 'external_link', 'External Link', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (221, 'successfully', 'Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (222, 'access_denied', 'Access Denied', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (223, 'username_has_already_been_used', 'Username Has Already Been Used', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (224, 'week_day', 'Week Day', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (225, 'time_start', 'Time Start', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (226, 'time_end', 'Time End', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (227, 'per_patient_duration', 'Per Patient Duration', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (228, 'make_closed', 'Make Closed', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (229, 'the_consultation_completed', 'The Consultation Completed', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (230, 'done', 'Done', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (231, 'the_consultation_has_been_closed', 'The Consultation Has Been Closed', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (232, 'requested', 'Requested', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (233, 'create_at', 'Create At', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (234, 'canceled', 'Canceled', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (235, 'apply', 'Apply', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (236, 'close', 'Close', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (237, 'information_has_been_updated_successfully', 'Information Has Been Updated Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (238, 'birthday', 'Birthday', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (239, 'joining_date', 'Joining Date', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (240, 'basic_details', 'Basic Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (241, 'gender', 'Gender', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (242, 'male', 'Male', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (243, 'female', 'Female', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (244, 'religion', 'Religion', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (245, 'blood_group', 'Blood Group', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (246, 'marital_status', 'Marital Status', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (247, 'single', 'Single', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (248, 'married', 'Married', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (249, 'profile_picture', 'Profile Picture', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (250, 'login_details', 'Login Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (251, 'office_details', 'Office Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (252, 'qualification', 'Qualification', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (253, 'social_links', 'Social Links', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (254, 'update', 'Update', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (255, 'patient_id', 'Patient Id', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (256, 'guardian', 'Guardian', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (257, 'authentication', 'Authentication', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (258, 'basic', 'Basic', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (259, 'age', 'Age', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (260, 'blood_pressure', 'Blood Pressure', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (261, 'height', 'Height', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (262, 'weight', 'Weight', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (263, 'emergency_contact', 'Emergency Contact', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (264, 'relationship', 'Relationship', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (265, 'history', 'History', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (266, 'completed', 'Completed', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (267, 'undelivered', 'Undelivered', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (268, 'login_authentication_deactivate', 'Login Authentication Deactivate', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (269, 'deactivate_account', 'Deactivate Account', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (270, 'authentication_activate', 'Authentication Activate', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (271, 'referred_by', 'Referred By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (272, 'time', 'Time', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (273, 'price', 'Price', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (274, 'add_rows', 'Add Rows', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (275, 'sub_total', 'Sub Total', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (276, 'tax', 'Tax', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (277, 'received', 'Received', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (278, 'enter_payment_amount', 'Enter Payment Amount', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (279, 'write_your_remarks', 'Write Your Remarks', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (280, 'roles', 'Roles', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (281, 'system_role', 'System Role', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (282, 'yes', 'Yes', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (283, 'role_permission_for', 'Role Permission For', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (284, 'feature', 'Feature', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (285, 'view', 'View', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (286, 'delete', 'Delete', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (287, 'ordered', 'Ordered', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (288, 'quantity', 'Quantity', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (289, 'net_total', 'Net Total', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (290, 'bill_view', 'Bill View', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (291, 'add_payment', 'Add Payment', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (292, 'to', 'To', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (293, 'company', 'Company', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (294, 'sub', 'Sub', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (295, 'paid_amount', 'Paid Amount', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (296, 'prepared_by', 'Prepared By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (297, 'authorised_by', 'Authorised By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (298, 'print', 'Print', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (299, 'paid_on', 'Paid On', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (300, 'attach_document', 'Attach Document', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (301, 'the_configuration_has_been_updated', 'The Configuration Has Been Updated', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (302, 'retype_password', 'Retype Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (303, 'contact_number', 'Contact Number', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (304, 'company_name', 'Company Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (305, 'product', 'Product', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (306, 'stock_by', 'Stock By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (307, 'inovice_no', 'Inovice No', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (308, 'sales_unit', 'Sales Unit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (309, 'for', 'For', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (310, 'select_multiple_chemical', 'Select Multiple Chemical', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (311, 'payment_history', 'Payment History', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (312, 'sex', 'Sex', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (313, 'from', 'From', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (314, 'net_payable', 'Net Payable', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (315, 'collect_by', 'Collect By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (316, 'unpublished_on_website', 'Unpublished On Website', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (317, 'published_on_website', 'Published On Website', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (318, 'grade', 'Grade', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (319, 'overtime', 'Overtime', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (320, 'allowances', 'Allowances', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (321, 'name_of_allowance', 'Name Of Allowance', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (322, 'deductions', 'Deductions', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (323, 'name_of_deductions', 'Name Of Deductions', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (324, 'allowance', 'Allowance', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (325, 'deduction', 'Deduction', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (326, 'salary_details', 'Salary Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (327, 'no_information_available', 'No Information Available', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (328, 'transactions', 'Transactions', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (329, 'sms_config', 'Sms Config', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (330, 'sms_template', 'Sms Template', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (331, 'select_a_sms_service', 'Select A Sms Service', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (332, 'disabled', 'Disabled', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (333, 'clickatell_username', 'Clickatell Username', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (334, 'clickatell_password', 'Clickatell Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (335, 'clickatell_api_key', 'Clickatell Api Key', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (336, 'registered_number', 'Registered Number', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (337, 'account_sid', 'Account Sid', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (338, 'auth_token', 'Auth Token', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (339, 'account_registered', 'Account Registered', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (340, 'notify_enable', 'Notify Enable', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (341, 'body', 'Body', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (342, 'appointment_confirmation', 'Appointment Confirmation', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (343, 'appointment_canceled', 'Appointment Canceled', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (344, 'appointment_request', 'Appointment Request', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (345, 'reporting', 'Reporting', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (346, 'button_text_1', 'Button Text 1', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (347, 'button_url_1', 'Button Url 1', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (348, 'button_text_2', 'Button Text 2', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (349, 'button_url_2', 'Button Url 2', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (350, 'left', 'Left', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (351, 'center', 'Center', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (352, 'right', 'Right', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (353, 'icon', 'Icon', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (354, 'surname', 'Surname', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (355, 'rank', 'Rank', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (356, 'staff', 'Staff', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (357, 'paid_by', 'Paid By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (358, 'user', 'User', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (359, 'payslip', 'Payslip', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (360, 'add_employee', 'Add Employee', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (361, 'bank_details', 'Bank Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (362, 'skipped_bank_details', 'Skipped Bank Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (363, 'bank_name', 'Bank Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (364, 'holder_name', 'Holder Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (365, 'bank', 'Bank', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (366, 'branch', 'Branch', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (367, 'ifsc_code', 'Ifsc Code', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (368, 'account_no', 'Account No', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (369, 'restore', 'Restore', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (370, 'create_backup', 'Create Backup', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (371, 'file', 'File', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (372, 'backup_size', 'Backup Size', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (373, 'file_upload', 'File Upload', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (374, 'flag', 'Flag', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (375, 'stats', 'Stats', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (376, 'created_at', 'Created At', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (377, 'updated_at', 'Updated At', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (378, 'edit_word', 'Edit Word', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (379, 'flag_icon', 'Flag Icon', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (380, 'language_unpublished', 'Language Unpublished', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (381, 'language_published', 'Language Published', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (382, 'transaction', 'Transaction', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (383, 'month_of_salary', 'Month Of Salary', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (384, 'basic_salary', 'Basic Salary', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (385, 'payment_type', 'Payment Type', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (386, 'bank_account', 'Bank Account', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (387, 'actions', 'Actions', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (388, 'document', 'Document', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (389, 'download', 'Download', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (390, 'opening_balance', 'Opening Balance', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (391, 'total_dr', 'Total Dr', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (392, 'total_cr', 'Total Cr', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (393, 'contact', 'Contact', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (394, 'box_title', 'Box Title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (395, 'box_description', 'Box Description', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (396, 'box_photo', 'Box Photo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (397, 'form_title', 'Form Title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (398, 'phone', 'Phone', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (399, 'submit_button_text', 'Submit Button Text', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (400, 'map_iframe', 'Map Iframe', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (401, 'system_name', 'System Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (402, 'month', 'Month', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (403, 'patient_price', 'Patient Price', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (404, 'production_cost', 'Production Cost', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (405, 'created_by', 'Created By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (406, 'test_category', 'Test Category', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (407, 'test_name', 'Test Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (408, 'test_code', 'Test Code', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (409, 'staff_name', 'Staff Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (410, 'percentage', 'Percentage', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (411, 'salary_assign', 'Salary Assign', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (412, 'pay_now', 'Pay Now', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (413, 'overtime_total_hour', 'Overtime Total Hour', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (414, 'overtime_amount', 'Overtime Amount', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (415, 'leave_category', 'Leave Category', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (416, 'days', 'Days', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (417, 'leave', 'Leave', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (418, 'date_of_start', 'Date Of Start', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (419, 'date_of_end', 'Date Of End', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (420, 'leave_type', 'Leave Type', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (421, 'reason', 'Reason', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (422, 'comments', 'Comments', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (423, 'accepted', 'Accepted', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (424, 'start_date', 'Start Date', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (425, 'end_date', 'End Date', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (426, 'approved', 'Approved', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (427, 'reject', 'Reject', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (428, 'select_all', 'Select All', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (429, 'not_selected', 'Not Selected', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (430, 'present', 'Present', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (431, 'absent', 'Absent', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (432, 'holiday', 'Holiday', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (433, 'late', 'Late', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (434, 'current_balance', 'Current Balance', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (435, 'no', 'No', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (436, 'current', 'Current', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (437, 'qty', 'Qty', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (438, 'payment_successfull', 'Payment Successfull', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (439, 'payment_by', 'Payment By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (440, 'chemical_wise_stock', 'Chemical Wise Stock', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (441, 'sale', 'Sale', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (442, 'in_qty', 'In Qty', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (443, 'out_qty', 'Out Qty', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (444, 'sale_profit', 'Sale Profit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (445, 'paid_via', 'Paid Via', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (446, 'collected_by', 'Collected By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (447, 'all', 'All', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (448, 'add_short_bio', 'Add Short Bio', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (449, 'email_config', 'Email Config', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (450, 'email_triggers', 'Email Triggers', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (451, 'system_email', 'System Email', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (452, 'subject', 'Subject', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (453, 'forgot_password', 'Forgot Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (454, 'payslip_generated', 'Payslip Generated', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (455, 'leave_approve', 'Leave Approve', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (456, 'leave_reject', 'Leave Reject', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (457, 'password_restoration', 'Password Restoration', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (458, 'forgot', 'Forgot', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (459, 'back_to_login', 'Back To Login', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (460, 'username_password_incorrect', 'Username Password Incorrect', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (461, 'word', 'Word', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (462, 'translations', 'Translations', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (463, 'referred', 'Referred', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');


#
# TABLE STRUCTURE FOR: leave_application
#

DROP TABLE IF EXISTS `leave_application`;

CREATE TABLE `leave_application` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `category_id` varchar(20) NOT NULL,
  `reason` text CHARACTER SET utf32 COLLATE utf32_unicode_ci NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `leave_days` varchar(20) NOT NULL DEFAULT '0',
  `status` varchar(10) NOT NULL DEFAULT '1',
  `apply_date` datetime NOT NULL,
  `orig_file_name` varchar(255) NOT NULL,
  `enc_file_name` varchar(255) NOT NULL,
  `approved_by` longtext NOT NULL,
  `comments` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: leave_category
#

DROP TABLE IF EXISTS `leave_category`;

CREATE TABLE `leave_category` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf32 COLLATE utf32_unicode_ci NOT NULL,
  `days` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: login_credential
#

DROP TABLE IF EXISTS `login_credential`;

CREATE TABLE `login_credential` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `username` varchar(100) NOT NULL,
  `password` varchar(250) NOT NULL,
  `role` int(11) NOT NULL,
  `active` int(11) NOT NULL COMMENT '1(active) 0(deactivate)',
  `last_login` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=319 DEFAULT CHARSET=utf8;

INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (1, 1, 'admin@gmail.com', '$2y$10$Jeo3lJWDGnf6rwBg4m75KOZPStXOpbrqdDL828fbCY5nhFpfp7eCu', 1, 1, '2022-03-31 15:07:04', '2022-03-08 15:54:41', '2022-03-31 14:37:04');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (3, 2, 'papachan@gmail.com', '$2y$10$vUQPIIcORYFg6ic1zaOU/O27zYgwaUOsJyV6BBovgy/W8uwENJtiC', 3, 1, NULL, '2022-03-08 21:26:18', '2022-03-08 21:26:18');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (5, 3, 'dr.vinodjacob', '$2y$10$GU07aJJfPrOJTTumkmW3oO55GUPMbXaDDKIsql3LrdANgUSSyvWRm', 3, 1, NULL, '2022-03-14 12:02:20', '2022-03-14 12:02:20');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (8, 4, 'ashifa', '$2y$10$hFKnPy8QxrW6NMBqrMxXBOO7Z9bMES5aHdLxNW98.5U3tUlbGVrc2', 3, 1, NULL, '2022-03-14 16:18:43', '2022-03-14 16:18:43');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_logi